/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.Collection;
import java.util.logging.Level;
import tigase.component.exceptions.ComponentException;
import tigase.criteria.Criteria;
import tigase.muc.MucContext;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.AbstractMucModule;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class IqStanzaForwarderModule
extends AbstractMucModule {
    public static final String ID = "iqforwarder";
    private final Criteria crit = new Criteria(){

        public Criteria add(Criteria criteria) {
            return null;
        }

        public boolean match(Element element) {
            return IqStanzaForwarderModule.this.checkIfProcessed(element);
        }
    };

    protected boolean checkIfProcessed(Element element) {
        if (element.getName() != "iq") {
            return false;
        }
        try {
            return IqStanzaForwarderModule.getNicknameFromJid(JID.jidInstance((String)element.getAttributeStaticStr("to"))) != null;
        }
        catch (TigaseStringprepException e2) {
            return false;
        }
    }

    public String[] getFeatures() {
        return null;
    }

    public Criteria getModuleCriteria() {
        return this.crit;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        try {
            JID senderJID = packet.getStanzaFrom();
            BareJID roomJID = packet.getStanzaTo().getBareJID();
            String recipientNickname = IqStanzaForwarderModule.getNicknameFromJid(packet.getStanzaTo());
            if (recipientNickname == null) {
                throw new MUCException(Authorization.BAD_REQUEST);
            }
            Room room = ((MucContext)this.context).getMucRepository().getRoom(roomJID);
            if (room == null) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND);
            }
            String senderNickname = room.getOccupantsNickname(senderJID);
            Role senderRole = room.getRole(senderNickname);
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "Processing IQ stanza, from: {0}, to: {1}, recipientNickname: {2}, senderNickname: {3}, senderRole: {4} ", new Object[]{senderJID, roomJID, recipientNickname, senderNickname, senderRole});
            }
            if (!senderRole.isSendPrivateMessages()) {
                throw new MUCException(Authorization.NOT_ALLOWED, "Role is not allowed to send private messages");
            }
            if (room.getOccupantsJidsByNickname(senderNickname).size() > 1) {
                throw new MUCException(Authorization.NOT_ALLOWED, "Many source resources detected.");
            }
            Collection<JID> recipientJids = room.getOccupantsJidsByNickname(recipientNickname);
            if (recipientJids == null || recipientJids.isEmpty()) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND, "Unknown recipient");
            }
            if (recipientJids.size() > 1) {
                throw new MUCException(Authorization.NOT_ALLOWED, "Many destination resources detected.");
            }
            JID recipientJid = recipientJids.iterator().next();
            Element iq = packet.getElement().clone();
            iq.setAttribute("from", roomJID.toString() + "/" + senderNickname);
            iq.setAttribute("to", recipientJid.toString());
            Packet p = Packet.packetInstance((Element)iq);
            p.setXMLNS("jabber:client");
            this.write(p);
        }
        catch (MUCException e1) {
            throw e1;
        }
        catch (TigaseStringprepException e2) {
            throw new MUCException(Authorization.BAD_REQUEST);
        }
        catch (Exception e3) {
            e3.printStackTrace();
            throw new RuntimeException(e3);
        }
    }
}

