/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.history;

import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import tigase.component.PacketWriter;
import tigase.db.DBInitException;
import tigase.db.Repository;
import tigase.muc.Affiliation;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.history.AbstractHistoryProvider;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

@Repository.Meta(supportedUris={"memory"})
public class MemoryHistoryProvider
extends AbstractHistoryProvider {
    private final Map<BareJID, LinkedList<HItem>> history = new ConcurrentHashMap<BareJID, LinkedList<HItem>>();
    private int maxSize = 256;

    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
    }

    @Override
    public void addJoinEvent(Room room, Date date, JID senderJID, String nickName) {
    }

    @Override
    public void addLeaveEvent(Room room, Date date, JID senderJID, String nickName) {
    }

    @Override
    public void addMessage(Room room, Element message, String body, JID senderJid, String senderNickname, Date time) {
        LinkedList<HItem> stanzas = this.history.get(room.getRoomJID());
        if (stanzas == null) {
            stanzas = new LinkedList();
            this.history.put(room.getRoomJID(), stanzas);
        }
        if (stanzas.size() >= this.maxSize) {
            stanzas.poll();
        }
        HItem item = new HItem();
        item.body = body;
        item.senderJid = senderJid;
        item.senderNickname = senderNickname;
        item.timestamp = time;
        item.msg = message == null ? null : message.toString();
        stanzas.add(item);
    }

    @Override
    public void addSubjectChange(Room room, Element message, String subject, JID senderJid, String senderNickname, Date time) {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void getHistoryMessages(Room room, JID senderJID, Integer maxchars, Integer maxstanzas, Integer seconds, Date since, PacketWriter writer) {
        LinkedList<HItem> stanzas = this.history.get(room.getRoomJID());
        if (stanzas == null) {
            stanzas = new LinkedList();
            this.history.put(room.getRoomJID(), stanzas);
        }
        int c2 = 0;
        Date now = new Date();
        for (HItem item : stanzas) {
            if (since != null) {
                if (item.timestamp.before(since)) {
                    continue;
                }
            } else if (maxstanzas != null) {
                if (c2 >= maxstanzas) {
                    break;
                }
            } else if (seconds != null) {
                if (item.timestamp.getTime() < now.getTime() - (long)(seconds * 1000)) {
                    continue;
                }
            } else if (c2 >= 25) break;
            Affiliation recipientAffiliation = room.getAffiliation(senderJID.getBareJID());
            boolean addRealJids = room.getConfig().getRoomAnonymity() == RoomConfig.Anonymity.nonanonymous || room.getConfig().getRoomAnonymity() == RoomConfig.Anonymity.semianonymous && (recipientAffiliation == Affiliation.owner || recipientAffiliation == Affiliation.admin);
            try {
                Packet message = this.createMessage(room.getRoomJID(), senderJID, item.senderNickname, item.msg, item.body, item.senderJid.toString(), addRealJids, item.timestamp);
                writer.write(message);
                ++c2;
            }
            catch (Exception e2) {
                if (this.log.isLoggable(Level.SEVERE)) {
                    this.log.log(Level.SEVERE, "Can't get history", e2);
                }
                throw new RuntimeException(e2);
            }
        }
    }

    @Override
    public void init(Map<String, Object> props) {
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public void removeHistory(Room room) {
        this.history.remove(room.getRoomJID());
    }

    private static class HItem {
        String body;
        String msg;
        JID senderJid;
        String senderNickname;
        Date timestamp;

        private HItem() {
        }
    }
}

