/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.cluster;

import java.util.logging.Level;
import tigase.component.exceptions.RepositoryException;
import tigase.muc.MucContext;
import tigase.muc.Room;
import tigase.muc.exceptions.MUCException;
import tigase.muc.repository.MucDAO;
import tigase.muc.repository.inmemory.InMemoryMucRepository;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class InMemoryMucRepositoryClustered
extends InMemoryMucRepository {
    private RoomListener a;
    private Room.RoomOccupantListener b;

    public InMemoryMucRepositoryClustered(MucContext mucConfig, MucDAO dao) throws RepositoryException {
        super(mucConfig, dao);
    }

    @Override
    public Room createNewRoom(BareJID roomJID, JID senderJid) throws RepositoryException {
        Room room = super.createNewRoom(roomJID, senderJid);
        this.a(room);
        if (this.a != null) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "notifing listener that room {0} was created", roomJID);
            }
            this.a.onRoomCreated(room);
        }
        return room;
    }

    public Room createNewRoomWithoutListener(BareJID roomJID, JID senderJid) throws RepositoryException {
        Room room = super.createNewRoom(roomJID, senderJid);
        this.a(room);
        return room;
    }

    @Override
    public void destroyRoom(Room room, Element destroyElement) throws RepositoryException {
        super.destroyRoom(room, destroyElement);
        if (this.a != null) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "notifing listener that room {0} was destroyed", room.getRoomJID());
            }
            this.a.onRoomDestroyed(room, destroyElement);
        }
    }

    public void destroyRoomWithoutListener(Room room, Element destroyElement) throws RepositoryException {
        super.destroyRoom(room, destroyElement);
    }

    @Override
    public Room getRoom(BareJID roomJID) throws RepositoryException, MUCException {
        boolean bl = !this.getActiveRooms().containsKey(roomJID);
        Room room = super.getRoom(roomJID);
        if (bl && room != null) {
            this.a(room);
        }
        return room;
    }

    public void setRoomListener(RoomListener roomListener) {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "setting room listener to {0}", roomListener);
        }
        this.a = roomListener;
    }

    public void setRoomOccupantListener(Room.RoomOccupantListener roomOccupantListener) {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "setting room occupants listener to " + this.a);
        }
        this.b = roomOccupantListener;
    }

    private void a(Room room) {
        if (this.b != null) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "adding room occupant listener for room {0}", room.getRoomJID());
            }
            room.addOccupantListener(this.b);
        }
        if (this.a != null && this.a instanceof Room.RoomListener) {
            room.addListener((Room.RoomListener)((Object)this.a));
        }
    }

    public static interface RoomListener {
        public void onRoomCreated(Room var1);

        public void onRoomDestroyed(Room var1, Element var2);
    }
}

