/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.cluster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.CommandListener;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.component.exceptions.RepositoryException;
import tigase.muc.Affiliation;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.cluster.AbstractClusteredRoomStrategy;
import tigase.muc.cluster.Occupant;
import tigase.muc.cluster.RoomClustered;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.PresenceModule;
import tigase.muc.modules.PresenceModuleImpl;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class ClusteredRoomStrategyV2
extends AbstractClusteredRoomStrategy {
    private static final Logger a = Logger.getLogger(ClusteredRoomStrategyV2.class.getCanonicalName());
    private static final String b = "occupants-remote-key";
    private static final String c = "muc-occupant-presence-cmd";
    private static final String d = "request-occupants-sync";
    private final a e = new a();
    private final b f = new b();

    @Override
    public void setClusterController(ClusterControllerIfc cl_controller) {
        if (this.cl_controller != null) {
            this.cl_controller.removeCommandListener((CommandListener)this.e);
            this.cl_controller.removeCommandListener((CommandListener)this.f);
        }
        super.setClusterController(cl_controller);
        if (cl_controller != null) {
            cl_controller.setCommandListener((CommandListener)this.e);
            cl_controller.setCommandListener((CommandListener)this.f);
        }
    }

    @Override
    public void onOccupantChangedPresence(Room room, JID occupantJid, String nickname, Element presence, boolean newOccupant) {
        List<JID> list = this.getAllNodes();
        list.remove(this.localNodeJid);
        if (occupantJid != null && presence == null) {
            presence = new Element("presence", new String[]{"type", "xmlns"}, new String[]{"unavailable", "jabber:client"});
        }
        if (occupantJid == null) {
            occupantJid = JID.jidInstanceNS((String)presence.getAttributeStaticStr("from"));
        }
        Affiliation affiliation = room.getAffiliation(nickname);
        Role role = room.getRole(nickname);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("room", room.getRoomJID().toString());
        hashMap.put("userId", occupantJid.toString());
        hashMap.put("nickname", nickname);
        hashMap.put("affiliation", affiliation.name());
        hashMap.put("role", role.name());
        if (newOccupant) {
            hashMap.put("new-occupant", String.valueOf(newOccupant));
        }
        if (a.isLoggable(Level.FINEST)) {
            StringBuilder stringBuilder = new StringBuilder(100);
            for (JID jID : list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(jID.toString());
            }
            a.log(Level.FINEST, "room = {0}, notifing nodes [{1}] that occupant {2} in room {3} changed presence = {4}", new Object[]{room.getRoomJID(), stringBuilder, occupantJid, room.getRoomJID(), presence});
        }
        this.cl_controller.sendToNodes(c, hashMap, presence, this.localNodeJid, null, list.toArray(new JID[list.size()]));
        if (newOccupant) {
            this.a(room, occupantJid);
        }
    }

    @Override
    protected void requestSync(JID nodeJid) {
        super.requestSync(nodeJid);
        this.cl_controller.sendToNodes(d, this.localNodeJid, new JID[]{nodeJid});
    }

    @Override
    protected void sendRemoteOccupantRemovalOnDisconnect(Room room, JID occupant, String occupantNick, boolean sendRemovalToOccupant) {
        super.sendRemoteOccupantRemovalOnDisconnect(room, occupant, occupantNick, sendRemovalToOccupant);
        RoomClustered roomClustered = (RoomClustered)room;
        roomClustered.removeRemoteOccupant(occupant);
    }

    private void a(Room room, JID jID) {
        ArrayList<Occupant> arrayList = new ArrayList<Occupant>(((RoomClustered)room).getRemoteOccupants());
        for (Occupant occupant : arrayList) {
            try {
                this.a(room, jID, occupant);
            }
            catch (TigaseStringprepException tigaseStringprepException) {
                a.log(Level.SEVERE, null, tigaseStringprepException);
            }
        }
    }

    private void a(Room room, JID jID, Occupant occupant) throws TigaseStringprepException {
        PresenceModule.PresenceWrapper presenceWrapper = PresenceModule.PresenceWrapper.preparePresenceW(room, jID, occupant.getBestPresence().clone(), occupant.getOccupantJID(), occupant.getOccupants(), occupant.getNickname(), occupant.getAffiliation(), occupant.getRole());
        PresenceModuleImpl.addCodes(presenceWrapper, false, occupant.getNickname());
        this.muc.addOutPacket(presenceWrapper.getPacket());
    }

    private class b
    extends CommandListenerAbstract {
        public b() {
            super(ClusteredRoomStrategyV2.d);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            ArrayList<Room> arrayList = new ArrayList<Room>(ClusteredRoomStrategyV2.this.muc.getMucRepository().getActiveRooms().values());
            a.log(Level.FINEST, "executig OccupantsSyncRequestCmd command fromNode = {0}, rooms = {1}", new Object[]{fromNode.toString(), ((Object)arrayList).toString()});
            for (Room room : arrayList) {
                for (String string : room.getOccupantsNicknames()) {
                    Collection<JID> collection = room.getOccupantsJidsByNickname(string);
                    if (collection.isEmpty()) continue;
                    JID jID = collection.iterator().next();
                    Element element = room.getLastPresenceCopyByJid(jID.getBareJID());
                    ClusteredRoomStrategyV2.this.onOccupantChangedPresence(room, jID, string, element, false);
                }
            }
        }
    }

    private class a
    extends CommandListenerAbstract {
        public a() {
            super(ClusteredRoomStrategyV2.c);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            try {
                BareJID bareJID = BareJID.bareJIDInstanceNS((String)data.get("room"));
                JID jID = JID.jidInstanceNS((String)data.get("userId"));
                String string = data.get("nickname");
                Affiliation affiliation = Affiliation.valueOf(data.get("affiliation"));
                Role role = Role.valueOf(data.get("role"));
                boolean bl = data.containsKey("new-occupant");
                Element element = packets.poll();
                a.log(Level.FINEST, "executig OccupantChangedPresenceCmd command for room = {0}, occupantJID = {1},nickname: {2}, occupantAffiliation = {3}, occupantRole = {4}, newOccupant = {5} ", new Object[]{bareJID.toString(), jID.toString(), string, affiliation, role, bl});
                PresenceModule presenceModule = (PresenceModule)ClusteredRoomStrategyV2.this.muc.getModule("presences");
                RoomClustered roomClustered = (RoomClustered)ClusteredRoomStrategyV2.this.muc.getMucRepository().getRoom(bareJID);
                if ("unavailable".equals(element.getAttribute("type"))) {
                    roomClustered.removeRemoteOccupant(jID);
                } else {
                    roomClustered.addRemoteOccupant(string, jID, role, affiliation, element);
                }
                Element element2 = roomClustered.getLastPresenceCopy(jID.getBareJID(), string);
                if (element2 != null && !"unavailable".equals(element2.getAttributeStaticStr("type"))) {
                    element = element2;
                }
                for (JID jID2 : roomClustered.getAllOccupantsJID()) {
                    Element element3 = element.clone();
                    PresenceModule.PresenceWrapper presenceWrapper = PresenceModule.PresenceWrapper.preparePresenceW(roomClustered, jID2, element3, jID.getBareJID(), Collections.singleton(jID), string, affiliation, role);
                    if (!"unavailable".equals(element3.getAttributeStaticStr("type"))) {
                        PresenceModuleImpl.addCodes(presenceWrapper, false, string);
                    }
                    ClusteredRoomStrategyV2.this.muc.addOutPacket(presenceWrapper.getPacket());
                }
            }
            catch (RepositoryException repositoryException) {
                Logger.getLogger(AbstractClusteredRoomStrategy.class.getName()).log(Level.SEVERE, null, repositoryException);
            }
            catch (MUCException mUCException) {
                Logger.getLogger(AbstractClusteredRoomStrategy.class.getName()).log(Level.SEVERE, null, (Throwable)((Object)mUCException));
            }
            catch (TigaseStringprepException tigaseStringprepException) {
                Logger.getLogger(AbstractClusteredRoomStrategy.class.getName()).log(Level.SEVERE, null, tigaseStringprepException);
            }
        }
    }
}

