/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.comp;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserRepository;
import tigase.db.comp.ConfigRepository;
import tigase.db.comp.RepositoryItem;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.BareJID;

public abstract class UserRepoRepository<Item extends RepositoryItem>
extends ConfigRepository<Item> {
    public static final String REPO_CLASS_PROP_KEY = "repo-class";
    public static final String REPO_URI_PROP_KEY = "repo-uri";
    private static final Logger log = Logger.getLogger(UserRepoRepository.class.getName());
    private String items_list_pkey = "items-lists";
    private UserRepository repo = null;

    public abstract BareJID getRepoUser();

    @Override
    public void getDefaults(Map<String, Object> defs, Map<String, Object> params) {
        super.getDefaults(defs, params);
    }

    public String getItemsListPKey() {
        return this.items_list_pkey;
    }

    @Override
    public void reload() {
        int hashCode = 0;
        super.reload();
        try {
            String items_list = this.repo.getData(this.getRepoUser(), this.getItemsListPKey());
            if (items_list != null) {
                hashCode = items_list.hashCode();
                if (!items_list.isEmpty() && hashCode != this.itemsHash) {
                    DomBuilderHandler domHandler = new DomBuilderHandler();
                    SimpleParser parser = SingletonFactory.getParserInstance();
                    parser.parse(domHandler, items_list.toCharArray(), 0, items_list.length());
                    Queue<Element> elems = domHandler.getParsedElements();
                    if (elems != null && elems.size() > 0) {
                        for (Element elem : elems) {
                            Object item = this.getItemInstance();
                            item.initFromElement(elem);
                            this.addItemNoStore(item);
                        }
                    }
                    log.log(Level.CONFIG, "All loaded items: {0}", this.items);
                    this.itemsHash = hashCode;
                }
            }
        }
        catch (TigaseDBException ex) {
            log.log(Level.SEVERE, "Problem with loading items list from the database.", ex);
        }
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        super.setProperties(properties);
        String repo_class = (String)properties.get(REPO_CLASS_PROP_KEY);
        String repo_uri = (String)properties.get(REPO_URI_PROP_KEY);
        if (repo_uri != null) {
            log.log(Level.INFO, "Initializing custom component repository: {0}, db connection: {1}", new Object[]{repo_class, repo_uri});
            try {
                this.repo = RepositoryFactory.getUserRepository(repo_class, repo_uri, null);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Can't initialize Items repository", e);
                this.repo = null;
            }
        }
        if (this.repo == null) {
            this.repo = (UserRepository)properties.get("shared-user-repo");
            log.config("Using shared repository instance.");
        }
        if (this.repo != null) {
            try {
                if (!this.repo.userExists(this.getRepoUser())) {
                    this.repo.addUser(this.getRepoUser());
                }
                this.repo.addUser(this.getRepoUser());
            }
            catch (UserExistsException e) {
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Problem with adding '" + this.getRepoUser() + "' user to the database", e);
            }
            this.reload();
        }
    }

    @Override
    public void store() {
        super.store();
        if (this.repo != null) {
            StringBuilder sb = new StringBuilder();
            for (RepositoryItem item : this.items.values()) {
                sb.append(item.toElement().toString());
            }
            try {
                this.repo.setData(this.getRepoUser(), this.getItemsListPKey(), sb.toString());
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error storing items list in the repository", e);
            }
        }
    }
}

