/*
 * Decompiled with CFR 0.152.
 */
package tigase.component;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import tigase.component.Context;
import tigase.component.PacketWriter;
import tigase.component.exceptions.ComponentException;
import tigase.component.modules.Module;
import tigase.component.modules.ModuleProvider;
import tigase.component.modules.ModulesManager;
import tigase.component.modules.impl.AdHocCommandModule;
import tigase.component.responses.AsyncCallback;
import tigase.component.responses.ResponseManager;
import tigase.conf.ConfigurationException;
import tigase.disco.XMPPService;
import tigase.disteventbus.EventBus;
import tigase.disteventbus.EventBusFactory;
import tigase.disteventbus.EventHandler;
import tigase.server.AbstractMessageReceiver;
import tigase.server.DisableDisco;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public abstract class AbstractComponent<CTX extends Context>
extends AbstractMessageReceiver
implements XMPPService,
DisableDisco {
    protected static final String COMPONENT = "component";
    protected final CTX context;
    protected final AdHocCommandModule.ScriptCommandProcessor defaultScriptCommandProcessor = new AdHocCommandModule.ScriptCommandProcessor(){

        @Override
        public List<Element> getScriptItems(String node, JID jid, JID from) {
            return AbstractComponent.this.getScriptItems(node, jid, from);
        }

        @Override
        public boolean processScriptCommand(Packet pc, Queue<Packet> results) {
            return AbstractComponent.this.processScriptCommand(pc, results);
        }
    };
    private EventBus eventBus = new EventBus(){
        private final EventBus eventBus = EventBusFactory.getInstance();

        @Override
        public void addHandler(String name, String xmlns, EventHandler handler) {
            this.eventBus.addHandler(name, xmlns, handler);
        }

        @Override
        public void fire(Element event) {
            event.setAttribute("eventSource", AbstractComponent.this.getComponentId().toString());
            event.setAttribute("eventTimestamp", Long.toString(System.currentTimeMillis()));
            this.eventBus.fire(event);
        }

        @Override
        public void removeHandler(String name, String xmlns, EventHandler handler) {
            this.eventBus.removeHandler(name, xmlns, handler);
        }
    };
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    protected final ModulesManager modulesManager;
    private ResponseManager responseManager;
    protected PacketWriter writer = new PacketWriter(){

        @Override
        public void write(Collection<Packet> elements) {
            if (elements != null) {
                for (Packet element : elements) {
                    if (element == null) continue;
                    this.write(element);
                }
            }
        }

        @Override
        public void write(Packet packet) {
            if (AbstractComponent.this.log.isLoggable(Level.FINER)) {
                AbstractComponent.this.log.finer("Sent: " + packet.getElement());
            }
            AbstractComponent.this.addOutPacket(packet);
        }

        @Override
        public void write(Packet packet, AsyncCallback callback) {
            if (AbstractComponent.this.log.isLoggable(Level.FINER)) {
                AbstractComponent.this.log.finer("Sent: " + packet.getElement());
            }
            AbstractComponent.this.addOutPacket(packet, callback);
        }
    };

    public AbstractComponent() {
        this(null);
    }

    public AbstractComponent(Context context) {
        this.context = context == null ? this.createContext() : context;
        this.modulesManager = new ModulesManager((Context)this.context);
        this.responseManager = new ResponseManager((Context)this.context);
    }

    protected void addOutPacket(Packet packet, AsyncCallback asyncCallback) {
        this.responseManager.registerResponseHandler(packet, 60000L, asyncCallback);
        this.addOutPacket(packet);
    }

    protected abstract CTX createContext();

    protected Module createModuleInstance(Class<Module> moduleClass) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.log.finer("Create instance of: " + moduleClass.getName());
        for (Constructor<?> x : moduleClass.getConstructors()) {
            Object[] args = new Object[x.getParameterTypes().length];
            boolean ok = true;
            for (int i = 0; i < x.getParameterTypes().length; ++i) {
                Class<Object> type = x.getParameterTypes()[i];
                Object value = type.isAssignableFrom(Context.class) ? this.context : (type.isAssignableFrom(AdHocCommandModule.ScriptCommandProcessor.class) ? this.defaultScriptCommandProcessor : null);
                ok = ok && value != null;
                args[i] = value;
            }
            if (!ok) continue;
            this.log.finest("Use constructor " + x);
            return (Module)x.newInstance(args);
        }
        return null;
    }

    @Override
    public synchronized void everyMinute() {
        super.everyMinute();
        this.responseManager.checkTimeouts();
    }

    public abstract String getComponentVersion();

    protected CTX getContext() {
        return this.context;
    }

    protected abstract Map<String, Class<? extends Module>> getDefaultModulesList();

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        Map<String, Class<Module>> modules = this.getDefaultModulesList();
        if (modules != null) {
            for (Map.Entry<String, Class<Module>> m : modules.entrySet()) {
                props.put("modules/" + m.getKey(), m.getValue().getName());
            }
        }
        return props;
    }

    EventBus getEventBus() {
        return this.eventBus;
    }

    public ModuleProvider getModuleProvider() {
        return this.modulesManager;
    }

    public PacketWriter getWriter() {
        return this.writer;
    }

    @Override
    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        binds.put(COMPONENT, (Object)this);
    }

    protected void initModules(Map<String, Object> props) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        for (Map.Entry<String, Object> e : props.entrySet()) {
            try {
                if (!e.getKey().startsWith("modules/")) continue;
                String id = e.getKey().substring(8);
                Class<Module> moduleClass = Class.forName(e.getValue().toString());
                Module module = this.createModuleInstance(moduleClass);
                this.registerModule(id, module);
            }
            catch (ClassNotFoundException ex) {
                this.log.warning("Cannot find Module class " + e.getValue().toString() + ".");
            }
        }
    }

    public abstract boolean isDiscoNonAdmin();

    public boolean isRegistered(String id) {
        return this.modulesManager.isRegistered(id);
    }

    @Override
    public void processPacket(Packet packet) {
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer("Received: " + packet.getElement());
        }
        try {
            boolean handled;
            Runnable responseHandler = this.responseManager.getResponseHandler(packet);
            if (responseHandler != null) {
                handled = true;
                responseHandler.run();
            } else {
                handled = this.modulesManager.process(packet);
            }
            if (!handled) {
                StanzaType type;
                String t = packet.getElement().getAttributeStaticStr("type");
                StanzaType stanzaType = type = t == null ? null : StanzaType.valueof(t);
                if (type != StanzaType.error) {
                    throw new ComponentException(Authorization.FEATURE_NOT_IMPLEMENTED);
                }
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer(packet.getElemName() + " stanza with type='error' ignored");
                }
            }
        }
        catch (TigaseStringprepException e) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, e.getMessage() + " when processing " + packet.toString());
            }
            this.sendException(packet, new ComponentException(Authorization.JID_MALFORMED));
        }
        catch (ComponentException e) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, e.getMessageWithPosition() + " when processing " + packet.toString());
            }
            this.sendException(packet, e);
        }
        catch (Exception e) {
            if (this.log.isLoggable(Level.SEVERE)) {
                this.log.log(Level.SEVERE, e.getMessage() + " when processing " + packet.toString(), e);
            }
            this.sendException(packet, new ComponentException(Authorization.INTERNAL_SERVER_ERROR));
        }
    }

    public <M extends Module> M registerModule(String id, M module) {
        if (this.modulesManager.isRegistered(id)) {
            this.modulesManager.unregister(id);
        }
        M r = this.modulesManager.register(id, module);
        return r;
    }

    protected void sendException(Packet packet, ComponentException e) {
        block5: {
            try {
                String t = packet.getElement().getAttributeStaticStr("type");
                if (t != null && t == "error") {
                    if (this.log.isLoggable(Level.FINER)) {
                        this.log.finer(packet.getElemName() + " stanza already with type='error' ignored");
                    }
                    return;
                }
                Packet result = e.makeElement(packet, true);
                Element el = result.getElement();
                el.setAttribute("from", BareJID.bareJIDInstance(el.getAttributeStaticStr("from")).toString());
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.log(Level.FINEST, "Sending back: " + result.toString());
                }
                this.context.getWriter().write(result);
            }
            catch (Exception e1) {
                if (!this.log.isLoggable(Level.WARNING)) break block5;
                this.log.log(Level.WARNING, "Problem during generate error response", e1);
            }
        }
    }

    @Override
    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        super.setProperties(props);
        try {
            this.initModules(props);
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Can't initialize modules!", e);
        }
    }

    @Override
    public void updateServiceEntity() {
        super.updateServiceEntity();
        this.updateServiceDiscoveryItem(this.getName(), null, this.getDiscoDescription(), !this.isDiscoNonAdmin());
    }
}

