/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class TimestampHelper {
    private static final SimpleDateFormat formatter4 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final SimpleDateFormat formatter3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final SimpleDateFormat formatter2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseTimestamp(String tmp) throws ParseException {
        if (tmp == null) {
            return null;
        }
        Date date = null;
        if (tmp.endsWith("Z")) {
            if (tmp.contains(".")) {
                SimpleDateFormat simpleDateFormat = formatter4;
                synchronized (simpleDateFormat) {
                    date = formatter4.parse(tmp);
                }
            } else {
                SimpleDateFormat simpleDateFormat = formatter;
                synchronized (simpleDateFormat) {
                    date = formatter.parse(tmp);
                }
            }
        } else {
            if (tmp.contains(".")) {
                SimpleDateFormat simpleDateFormat = formatter3;
                synchronized (simpleDateFormat) {
                    date = formatter3.parse(tmp);
                }
            }
            SimpleDateFormat simpleDateFormat = formatter2;
            synchronized (simpleDateFormat) {
                date = formatter2.parse(tmp);
            }
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(Date ts) {
        SimpleDateFormat simpleDateFormat = formatter2;
        synchronized (simpleDateFormat) {
            return formatter2.format(ts);
        }
    }

    static {
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        formatter2.setTimeZone(TimeZone.getTimeZone("UTC"));
        formatter3.setTimeZone(TimeZone.getTimeZone("UTC"));
        formatter4.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

