/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.archive.RetentionType;
import tigase.archive.StoreMethod;
import tigase.archive.VHostItemHelper;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.util.DNSResolver;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.C2SDeliveryErrorProcessor;

public class MessageArchivePlugin
extends XMPPProcessor
implements XMPPProcessorIfc {
    public static final String DEFAULT_SAVE = "default-save";
    public static final String LIST = "list";
    public static final String OWNER_JID = "owner";
    public static final String REMOVE = "remove";
    public static final String RETRIEVE = "retrieve";
    public static final String XEP0136NS = "urn:xmpp:archive";
    private static final String ARCHIVE = "message-archive";
    private static final String AUTO = "auto";
    private static final String EXPIRE = "expire";
    private static final String ID = "message-archive-xep-0136";
    private static final Logger log = Logger.getLogger(MessageArchivePlugin.class.getCanonicalName());
    private static final String MESSAGE = "message";
    private static final String SETTINGS = "message-archive/settings";
    private static final String XMLNS = "jabber:client";
    private static final String[][] ELEMENT_PATHS = new String[][]{{"message"}, {"iq", "auto"}, {"iq", "retrieve"}, {"iq", "list"}, {"iq", "remove"}, {"iq", "pref"}, {"iq", "tags"}};
    private static final String[] XMLNSS = new String[]{"jabber:client", "urn:xmpp:archive", "urn:xmpp:archive", "urn:xmpp:archive", "urn:xmpp:archive", "urn:xmpp:archive", "http://tigase.org/protocol/archive#query"};
    private static final Set<StanzaType> TYPES;
    private static final Element[] DISCO_FEATURES;
    private static final String DEFAULT_STORE_METHOD_KEY = "default-store-method";
    private static final String REQUIRED_STORE_METHOD_KEY = "required-store-method";
    private StoreMethod globalDefaultStoreMethod = StoreMethod.Body;
    private StoreMethod globalRequiredStoreMethod = StoreMethod.False;
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private JID ma_jid = null;

    public void init(Map<String, Object> settings) throws TigaseDBException {
        super.init(settings);
        VHostItemHelper.register();
        String componentJidStr = (String)settings.get("component-jid");
        if (componentJidStr != null) {
            this.ma_jid = JID.jidInstanceNS((String)componentJidStr);
        } else {
            String defHost = DNSResolver.getDefaultHostname();
            this.ma_jid = JID.jidInstanceNS((String)ARCHIVE, (String)defHost, null);
        }
        log.log(Level.CONFIG, "Loaded message archiving component jid option: {0} = {1}", new Object[]{"component-jid", this.ma_jid});
        System.out.println("MA LOADED = " + this.ma_jid.toString());
        if (settings.containsKey(REQUIRED_STORE_METHOD_KEY)) {
            this.globalRequiredStoreMethod = StoreMethod.valueof((String)settings.get(REQUIRED_STORE_METHOD_KEY));
        }
        if (settings.containsKey(DEFAULT_STORE_METHOD_KEY)) {
            this.globalDefaultStoreMethod = StoreMethod.valueof((String)settings.get(DEFAULT_STORE_METHOD_KEY));
        }
        if (this.globalDefaultStoreMethod.ordinal() < this.globalRequiredStoreMethod.ordinal()) {
            this.globalDefaultStoreMethod = this.globalRequiredStoreMethod;
        }
    }

    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        block70: {
            if (session == null) {
                return;
            }
            try {
                if (MESSAGE == packet.getElemName()) {
                    if (C2SDeliveryErrorProcessor.isDeliveryError((Packet)packet)) {
                        return;
                    }
                    StanzaType type = packet.getType();
                    if (packet.getElement().findChildStaticStr(Message.MESSAGE_BODY_PATH) == null || type != null && type != StanzaType.chat && type != StanzaType.normal) {
                        return;
                    }
                    boolean auto = this.getAutoSave(session);
                    if (auto && packet.getElemCDataStaticStr(Message.MESSAGE_BODY_PATH) != null) {
                        StoreMethod storeMethod = this.getStoreMethod(session);
                        if (storeMethod == StoreMethod.False) {
                            return;
                        }
                        Packet result = packet.copyElementOnly();
                        result.setPacketTo(this.ma_jid);
                        result.getElement().addAttribute(OWNER_JID, session.getBareJID().toString());
                        switch (storeMethod) {
                            case Body: {
                                Element message = result.getElement();
                                block41: for (Element elem : message.getChildren()) {
                                    switch (elem.getName()) {
                                        case "body": {
                                            continue block41;
                                        }
                                    }
                                    message.removeChild(elem);
                                }
                                break;
                            }
                        }
                        results.offer(result);
                    }
                    break block70;
                }
                if ("iq" != packet.getElemName()) break block70;
                if (this.ma_jid.equals((Object)packet.getPacketFrom())) {
                    JID connId = session.getConnectionId(packet.getStanzaTo());
                    Packet result = packet.copyElementOnly();
                    result.setPacketTo(connId);
                    results.offer(result);
                    return;
                }
                if (packet.getType() != StanzaType.get && packet.getType() != StanzaType.set) {
                    return;
                }
                Element auto = packet.getElement().getChild(AUTO);
                Element pref = packet.getElement().getChild("pref");
                StoreMethod requiredStoreMethod = this.getRequiredStoreMethod(session);
                if (auto == null && pref == null) {
                    Packet result = packet.copyElementOnly();
                    result.setPacketTo(this.ma_jid);
                    results.offer(result);
                    break block70;
                }
                if (pref != null) {
                    if (packet.getType() == StanzaType.get) {
                        Element prefEl = new Element("pref");
                        prefEl.setXMLNS(XEP0136NS);
                        Element autoEl = new Element(AUTO);
                        autoEl.setAttribute("save", String.valueOf(this.getAutoSave(session)));
                        prefEl.addChild((XMLNodeIfc)autoEl);
                        Element defaultEl = new Element("default");
                        defaultEl.setAttribute("otr", "forbid");
                        try {
                            RetentionType retentionType = VHostItemHelper.getRetentionType(session.getDomain());
                            String expire = null;
                            switch (retentionType) {
                                case userDefined: {
                                    expire = session.getData(SETTINGS, EXPIRE, null);
                                    break;
                                }
                                case numberOfDays: {
                                    Integer retention = VHostItemHelper.getRetentionDays(session.getDomain());
                                    if (retention == null) break;
                                    expire = String.valueOf(retention.longValue() * 60L * 60L * 24L);
                                    break;
                                }
                            }
                            if (expire != null) {
                                defaultEl.setAttribute(EXPIRE, expire);
                            }
                        }
                        catch (TigaseDBException ex) {
                            log.log(Level.WARNING, "could not retrieve expire setting for message archive for user {0}", session.getjid());
                        }
                        StoreMethod storeMethod = this.getStoreMethod(session);
                        defaultEl.setAttribute("save", storeMethod.toString());
                        prefEl.addChild((XMLNodeIfc)defaultEl);
                        Element methodEl = new Element("method");
                        methodEl.setAttribute("type", AUTO);
                        methodEl.setAttribute("use", "prefer");
                        prefEl.addChild((XMLNodeIfc)methodEl);
                        methodEl = new Element("method");
                        methodEl.setAttribute("type", "local");
                        methodEl.setAttribute("use", "prefer");
                        prefEl.addChild((XMLNodeIfc)methodEl);
                        methodEl = new Element("method");
                        methodEl.setAttribute("type", "manual");
                        methodEl.setAttribute("use", "prefer");
                        prefEl.addChild((XMLNodeIfc)methodEl);
                        results.offer(packet.okResult(prefEl, 0));
                        break block70;
                    }
                    if (packet.getType() == StanzaType.set) {
                        Authorization error = null;
                        StoreMethod storeMethod = null;
                        Boolean autoSave = null;
                        String errorMsg = null;
                        String expire = null;
                        block42: for (Element elem : pref.getChildren()) {
                            switch (elem.getName()) {
                                case "default": {
                                    storeMethod = StoreMethod.valueof(elem.getAttributeStaticStr("save"));
                                    if (storeMethod == StoreMethod.Stream) {
                                        error = Authorization.FEATURE_NOT_IMPLEMENTED;
                                        errorMsg = "Value stream of save attribute is not supported";
                                        break;
                                    }
                                    if (storeMethod.ordinal() < requiredStoreMethod.ordinal()) {
                                        error = Authorization.NOT_ACCEPTABLE;
                                        errorMsg = "Required minimal message archiving level is " + requiredStoreMethod.toString();
                                        break;
                                    }
                                    String otr = elem.getAttributeStaticStr("otr");
                                    if (otr != null && !"forbid".equals(otr)) {
                                        error = Authorization.FEATURE_NOT_IMPLEMENTED;
                                        errorMsg = "Value " + otr + " of otr attribute is not supported";
                                    }
                                    if ((expire = elem.getAttributeStaticStr(EXPIRE)) == null) continue block42;
                                    if (RetentionType.userDefined != VHostItemHelper.getRetentionType(session.getDomain())) {
                                        error = Authorization.NOT_ALLOWED;
                                        errorMsg = "Expire value is not allowed to be changed by user";
                                        break;
                                    }
                                    try {
                                        long val = Long.parseLong(expire);
                                        if (val > 0L) continue block42;
                                        error = Authorization.NOT_ACCEPTABLE;
                                        errorMsg = "Value of expire attribute must be bigger than 0";
                                    }
                                    catch (NumberFormatException ex) {
                                        error = Authorization.BAD_REQUEST;
                                        errorMsg = "Value of expire attribute must be a number";
                                    }
                                    break;
                                }
                                case "auto": {
                                    autoSave = Boolean.valueOf(elem.getAttributeStaticStr("save"));
                                    if (!(requiredStoreMethod == StoreMethod.False || autoSave != null && autoSave.booleanValue())) {
                                        error = Authorization.NOT_ACCEPTABLE;
                                        errorMsg = "Required minimal message archiving level is " + requiredStoreMethod.toString() + " and that requires automatic archiving to be enabled";
                                    }
                                    if (!autoSave.booleanValue() || VHostItemHelper.isEnabled(session.getDomain())) continue block42;
                                    error = Authorization.NOT_ALLOWED;
                                    errorMsg = "Message archiving is not allowed for domain " + session.getDomainAsJID().toString();
                                    break;
                                }
                                default: {
                                    error = Authorization.FEATURE_NOT_IMPLEMENTED;
                                    errorMsg = null;
                                }
                            }
                        }
                        if (error != null) {
                            results.offer(error.getResponseMessage(packet, errorMsg, true));
                        } else {
                            try {
                                if (autoSave != null) {
                                    this.setAutoSave(session, autoSave);
                                }
                                if (storeMethod != null) {
                                    this.setStoreMethod(session, storeMethod);
                                }
                                if (expire != null) {
                                    session.setData(SETTINGS, EXPIRE, expire);
                                }
                                results.offer(packet.okResult((String)null, 0));
                            }
                            catch (TigaseDBException ex) {
                                results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, null, false));
                            }
                        }
                    } else {
                        results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, null, true));
                    }
                    break block70;
                }
                String val = auto.getAttributeStaticStr("save");
                if (val == null) {
                    val = "";
                }
                boolean save = false;
                switch (val) {
                    case "true": 
                    case "1": {
                        save = true;
                        break;
                    }
                    case "false": 
                    case "0": {
                        save = false;
                        break;
                    }
                    default: {
                        results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Save value is incorrect or missing", false));
                        return;
                    }
                }
                if (!save && requiredStoreMethod != StoreMethod.False) {
                    results.offer(Authorization.NOT_ACCEPTABLE.getResponseMessage(packet, "Required minimal message archiving level is " + requiredStoreMethod.toString() + " and that requires automatic archiving to be enabled", false));
                    return;
                }
                if (save && !VHostItemHelper.isEnabled(session.getDomain())) {
                    results.offer(Authorization.NOT_ACCEPTABLE.getResponseMessage(packet, "Message archiving is not allowed for domain " + session.getDomainAsJID().toString(), false));
                    return;
                }
                try {
                    this.setAutoSave(session, save);
                    session.putCommonSessionData("message-archive-xep-0136/auto", (Object)save);
                    Element res = new Element(AUTO);
                    res.setXMLNS(XEP0136NS);
                    res.setAttribute("save", save ? "true" : "false");
                    results.offer(packet.okResult(res, 0));
                    return;
                }
                catch (TigaseDBException ex) {
                    log.log(Level.WARNING, "Error setting Message Archive state: {0}", ex.getMessage());
                    results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database error occured", true));
                }
            }
            catch (NotAuthorizedException ex) {
                log.log(Level.WARNING, "NotAuthorizedException for packet: {0}", packet);
                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
            }
        }
    }

    public String id() {
        return ID;
    }

    public String[][] supElementNamePaths() {
        return ELEMENT_PATHS;
    }

    public String[] supNamespaces() {
        return XMLNSS;
    }

    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    public Set<StanzaType> supTypes() {
        return TYPES;
    }

    private boolean getAutoSave(XMPPResourceConnection session) throws NotAuthorizedException {
        StoreMethod requiredStoreMethod = this.getRequiredStoreMethod(session);
        if (requiredStoreMethod != StoreMethod.False) {
            return true;
        }
        Boolean auto = (Boolean)session.getCommonSessionData("message-archive-xep-0136/auto");
        if (auto == null) {
            try {
                String data = session.getData(SETTINGS, AUTO, "false");
                auto = Boolean.parseBoolean(data);
                if (!VHostItemHelper.isEnabled(session.getDomain()) && auto.booleanValue()) {
                    auto = false;
                    session.setData(SETTINGS, AUTO, String.valueOf(auto));
                }
                session.putCommonSessionData("message-archive-xep-0136/auto", (Object)auto);
            }
            catch (TigaseDBException ex) {
                log.log(Level.WARNING, "Error getting Message Archive state: {0}", ex.getMessage());
                auto = false;
            }
        }
        return auto;
    }

    private StoreMethod getRequiredStoreMethod(XMPPResourceConnection session) {
        return StoreMethod.valueof(VHostItemHelper.getRequiredStoreMethod(session.getDomain(), this.globalRequiredStoreMethod.toString()));
    }

    private StoreMethod getStoreMethod(XMPPResourceConnection session) throws NotAuthorizedException {
        StoreMethod save = (StoreMethod)((Object)session.getCommonSessionData("message-archive-xep-0136/default-save"));
        if (save == null) {
            try {
                String data = session.getData(SETTINGS, DEFAULT_SAVE, null);
                if (data == null) {
                    data = VHostItemHelper.getDefaultStoreMethod(session.getDomain(), this.globalDefaultStoreMethod.toString());
                }
                save = StoreMethod.valueof(data);
                session.putCommonSessionData("message-archive-xep-0136/default-save", (Object)save);
            }
            catch (TigaseDBException ex) {
                log.log(Level.WARNING, "Error getting Message Archive state: {0}", ex.getMessage());
                save = StoreMethod.False;
            }
            StoreMethod requiredStoreMethod = this.getRequiredStoreMethod(session);
            if (save.ordinal() < requiredStoreMethod.ordinal()) {
                save = requiredStoreMethod;
                session.putCommonSessionData("message-archive-xep-0136/default-save", (Object)save);
                try {
                    this.setStoreMethod(session, save);
                }
                catch (TigaseDBException ex) {
                    log.log(Level.WARNING, "Error updating message archiving level to required level {0}", ex.getMessage());
                }
            }
        }
        return save;
    }

    public void setAutoSave(XMPPResourceConnection session, Boolean auto) throws NotAuthorizedException, TigaseDBException {
        session.setData(SETTINGS, AUTO, String.valueOf(auto));
        session.putCommonSessionData("message-archive-xep-0136/auto", (Object)auto);
    }

    public void setStoreMethod(XMPPResourceConnection session, StoreMethod save) throws NotAuthorizedException, TigaseDBException {
        session.setData(SETTINGS, DEFAULT_SAVE, (save == null ? StoreMethod.False : save).toString());
        session.putCommonSessionData("message-archive-xep-0136/default-save", (Object)save);
    }

    static {
        DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"urn:xmpp:archive:auto"}), new Element("feature", new String[]{"var"}, new String[]{"urn:xmpp:archive:manage"})};
        HashSet<StanzaType[]> tmpTYPES = new HashSet<StanzaType[]>();
        tmpTYPES.add(null);
        tmpTYPES.addAll(EnumSet.of(StanzaType.normal, new StanzaType[]{StanzaType.chat, StanzaType.get, StanzaType.set, StanzaType.error, StanzaType.result}));
        TYPES = Collections.unmodifiableSet(tmpTYPES);
    }
}

