/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.migration;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import tigase.db.UserRepository;
import tigase.pubsub.repository.PubSubDAOJDBC;
import tigase.pubsub.repository.RepositoryException;
import tigase.xmpp.BareJID;

public class PubSubNewDAOJDBC
extends PubSubDAOJDBC {
    private CallableStatement fix_node_st = null;
    private CallableStatement fix_item_st = null;

    @Override
    public void init(String resource_uri, Map<String, String> params, UserRepository userRepository) throws RepositoryException {
        super.init(resource_uri, params, userRepository);
        try {
            this.fix_node_st = this.conn.prepareCall("{ call TigPubSubFixNode(?,?) }");
            this.fix_item_st = this.conn.prepareCall("{ call TigPubSubFixItem(?,?,?,?) }");
        }
        catch (SQLException ex) {
            throw new RepositoryException("could not initialize repository", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixNode(BareJID serviceJid, long nodeId, Date creationDate) throws RepositoryException {
        if (creationDate == null) {
            return;
        }
        try {
            CallableStatement callableStatement = this.fix_node_st;
            synchronized (callableStatement) {
                this.fix_node_st.setLong(1, nodeId);
                this.fix_node_st.setTimestamp(2, new Timestamp(creationDate.getTime()));
                this.fix_node_st.execute();
            }
        }
        catch (SQLException ex) {
            throw new RepositoryException("could not fix node creation date", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixItem(BareJID serviceJid, long nodeId, String itemId, Date creationDate, Date updateDate) throws RepositoryException {
        try {
            CallableStatement callableStatement = this.fix_item_st;
            synchronized (callableStatement) {
                this.fix_item_st.setLong(1, nodeId);
                this.fix_item_st.setString(2, itemId);
                if (creationDate == null) {
                    this.fix_item_st.setNull(3, 93);
                } else {
                    this.fix_item_st.setTimestamp(3, new Timestamp(creationDate.getTime()));
                }
                if (updateDate == null) {
                    this.fix_item_st.setNull(4, 93);
                } else {
                    this.fix_item_st.setTimestamp(4, new Timestamp(updateDate.getTime()));
                }
                this.fix_item_st.execute();
            }
        }
        catch (SQLException ex) {
            throw new RepositoryException("could not fix node creation date", ex);
        }
    }
}

