/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import tigase.component2.PacketWriter;
import tigase.component2.eventbus.EventBus;
import tigase.component2.modules.Module;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.Affiliation;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.Subscription;
import tigase.pubsub.Utils;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.server.Packet;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterElement;

public abstract class AbstractPubSubModule
implements Module {
    protected final PubSubConfig config;
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    protected final PacketWriter packetWriter;

    public static Element createResultIQ(Element iq) {
        Element e = new Element("iq");
        e.setXMLNS("jabber:client");
        String id = iq.getAttributeStaticStr("id");
        String from = iq.getAttributeStaticStr("from");
        String to = iq.getAttributeStaticStr("to");
        e.addAttribute("type", "result");
        if (to != null) {
            e.addAttribute("from", to);
        }
        if (from != null) {
            e.addAttribute("to", from);
        }
        if (id != null) {
            e.addAttribute("id", id);
        }
        return e;
    }

    public static List<Element> createResultIQArray(Element iq) {
        return AbstractPubSubModule.makeArray(AbstractPubSubModule.createResultIQ(iq));
    }

    @Deprecated
    protected static String findBestJid(String[] allSubscribers, String jid) {
        String bareJid = JIDUtils.getNodeID((String)jid);
        String best = null;
        for (String j : allSubscribers) {
            if (j.equals(jid)) {
                return j;
            }
            if (!bareJid.equals(j)) continue;
            best = j;
        }
        return best;
    }

    public static Collection<BareJID> getActiveSubscribers(AbstractNodeConfig nodeConfig, BareJID[] jids, IAffiliations affiliations, ISubscriptions subscriptions) {
        HashSet<BareJID> result = new HashSet<BareJID>();
        boolean presenceExpired = nodeConfig.isPresenceExpired();
        if (jids != null) {
            for (BareJID jid : jids) {
                Subscription subscription;
                UsersAffiliation affiliation;
                if (presenceExpired) {
                    // empty if block
                }
                if ((affiliation = affiliations.getSubscriberAffiliation(jid)).getAffiliation() == Affiliation.outcast || (subscription = subscriptions.getSubscription(jid)) != Subscription.subscribed) continue;
                result.add(jid);
            }
        }
        return result;
    }

    public static Collection<BareJID> getActiveSubscribers(AbstractNodeConfig nodeConfig, IAffiliations affiliations, ISubscriptions subscriptions) throws RepositoryException {
        UsersSubscription[] subscribers = subscriptions.getSubscriptionsForPublish();
        if (subscribers == null) {
            return Collections.emptyList();
        }
        BareJID[] jids = new BareJID[subscribers.length];
        for (int i = 0; i < subscribers.length; ++i) {
            jids[i] = subscribers[i].getJid();
        }
        return AbstractPubSubModule.getActiveSubscribers(nodeConfig, jids, affiliations, subscriptions);
    }

    public static List<Element> makeArray(Element ... elements) {
        LinkedList<Element> result = new LinkedList<Element>();
        for (Element element : elements) {
            result.add(element);
        }
        return result;
    }

    public static List<Packet> makeArray(Packet ... packets) {
        LinkedList<Packet> result = new LinkedList<Packet>();
        for (Packet packet : packets) {
            result.add(packet);
        }
        return result;
    }

    public AbstractPubSubModule(PubSubConfig config, PacketWriter packetWriter) {
        this.config = config;
        this.packetWriter = packetWriter;
    }

    protected EventBus getEventBus() {
        return this.config.getEventBus();
    }

    protected IPubSubRepository getRepository() {
        return this.config.getPubSubRepository();
    }

    protected boolean hasSenderSubscription(BareJID bareJid, IAffiliations affiliations, ISubscriptions subscriptions) throws RepositoryException {
        UsersSubscription[] subscribers;
        for (UsersSubscription owner : subscribers = subscriptions.getSubscriptions()) {
            UsersAffiliation affiliation = affiliations.getSubscriberAffiliation(owner.getJid());
            if (affiliation.getAffiliation() != Affiliation.owner) continue;
            if (bareJid.equals((Object)owner.getJid())) {
                return true;
            }
            Map<BareJID, RosterElement> buddies = this.getRepository().getUserRoster(owner.getJid());
            RosterElement re = buddies.get(bareJid);
            if (re == null || re.getSubscription() != RosterAbstract.SubscriptionType.both && re.getSubscription() != RosterAbstract.SubscriptionType.from && re.getSubscription() != RosterAbstract.SubscriptionType.from_pending_out) continue;
            return true;
        }
        return false;
    }

    protected boolean isSenderInRosterGroup(BareJID bareJid, AbstractNodeConfig nodeConfig, IAffiliations affiliations, ISubscriptions subscriptions) throws RepositoryException {
        UsersSubscription[] subscribers = subscriptions.getSubscriptions();
        String[] groupsAllowed = nodeConfig.getRosterGroupsAllowed();
        if (groupsAllowed == null || groupsAllowed.length == 0) {
            return true;
        }
        for (UsersSubscription owner : subscribers) {
            UsersAffiliation affiliation = affiliations.getSubscriberAffiliation(owner.getJid());
            if (affiliation.getAffiliation() != Affiliation.owner) continue;
            if (bareJid.equals((Object)owner)) {
                return true;
            }
            Map<BareJID, RosterElement> buddies = this.getRepository().getUserRoster(owner.getJid());
            RosterElement re = buddies.get(bareJid);
            if (re == null || re.getGroups() == null) continue;
            for (String group : groupsAllowed) {
                if (!Utils.contain(group, groupsAllowed)) continue;
                return true;
            }
        }
        return false;
    }
}

