/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.dnswebservice;

import java.util.Map;
import tigase.http.AbstractModule;
import tigase.http.DeploymentInfo;
import tigase.http.HttpServer;
import tigase.http.dnswebservice.JsonServlet;

public class DnsWebServiceModule
extends AbstractModule {
    private HttpServer httpServer = null;
    private DeploymentInfo deployment = null;
    private String contextPath = null;
    private String[] vhosts = null;

    @Override
    public String getName() {
        return "dns-webservice";
    }

    @Override
    public String getDescription() {
        return "WebService for DNS resolution";
    }

    @Override
    public Map<String, Object> getDefaults() {
        Map<String, Object> props = super.getDefaults();
        props.put("context-path", "/" + this.getName());
        return props;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        if (props.size() == 1) {
            return;
        }
        if (props.containsKey("http-server")) {
            this.httpServer = (HttpServer)props.get("http-server");
        }
        if (props.containsKey("context-path")) {
            this.contextPath = (String)props.get("context-path");
        }
        this.vhosts = (String[])props.get("vhosts");
    }

    @Override
    public void start() {
        if (this.deployment != null) {
            this.stop();
        }
        super.start();
        this.deployment = HttpServer.deployment().setClassLoader(this.getClass().getClassLoader()).setContextPath(this.contextPath).setDeploymentName("DnsWebService").addServlets(HttpServer.servlet("JsonServlet", JsonServlet.class).addMapping("/*"));
        if (this.vhosts != null) {
            this.deployment.setVHosts(this.vhosts);
        }
        this.httpServer.deploy(this.deployment);
    }

    @Override
    public void stop() {
        if (this.deployment != null) {
            this.httpServer.undeploy(this.deployment);
            this.deployment = null;
        }
        super.stop();
    }
}

