/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.sreceiver;

import java.util.Queue;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.server.sreceiver.AbstractReceiverTask;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class TesterTask
extends AbstractReceiverTask {
    private static final String TASK_HELP = "This task pretends to be a user. Allows you to [un]subscribe to its roster, send a message and perform some other actions. Roster of this task is stored in memory only and is cleared on server restart. Full list of supported actions will be sent to you as a response to //help message. The purpose of this task is testing of the Tigase server and the task should not be normally loaded on to live system.";
    private static final String TASK_TYPE = "Tester Task";

    @Override
    public String getHelp() {
        return TASK_HELP;
    }

    @Override
    public String getType() {
        return TASK_TYPE;
    }

    @Override
    protected void processMessage(Packet packet, Queue<Packet> results) {
        if (this.isPostCommand(packet)) {
            this.runCommand(packet, results);
        } else {
            String body = packet.getElemCDataStaticStr(Message.MESSAGE_BODY_PATH);
            results.offer(Message.getMessage(packet.getStanzaTo(), packet.getStanzaFrom(), StanzaType.normal, "This is response to your message: [" + body + "]", "Response", null, packet.getStanzaId()));
        }
    }

    private String commandsHelp() {
        return "Available commands are:\n//help - display this help info\n//genn N - generates N messages to random, non-existen users on the server and responds with a simple reply masse: 'Completed N.'\n For now you can only subsribe to and unsubscribe from task roster and send a message to task as it was a user. The task will always respond to your messages with following text:\n This is response to your message: [your message included here]";
    }

    private boolean isPostCommand(Packet packet) {
        String body = packet.getElemCDataStaticStr(Message.MESSAGE_BODY_PATH);
        if (body != null) {
            for (command comm : command.values()) {
                if (!body.startsWith("//" + comm.toString())) continue;
                return true;
            }
        }
        return false;
    }

    private void runCommand(Packet packet, Queue<Packet> results) {
        String body = packet.getElemCDataStaticStr(Message.MESSAGE_BODY_PATH);
        String[] body_split = body.split(" |\n|\r");
        command comm = command.valueOf(body_split[0].substring(2));
        switch (comm) {
            case help: {
                results.offer(Message.getMessage(packet.getStanzaTo(), packet.getStanzaFrom(), StanzaType.chat, this.commandsHelp(), "Commands description", null, packet.getStanzaId()));
                break;
            }
            case genn: {
                try {
                    int number = Integer.parseInt(body_split[1]);
                    String domain = packet.getStanzaFrom().getDomain();
                    for (int i = 0; i < number; ++i) {
                        results.offer(Message.getMessage(packet.getStanzaTo(), JID.jidInstance("nonename_" + i + "@" + domain), StanzaType.normal, "Traffic generattion: " + number, "Internal load test", null, packet.getStanzaId()));
                    }
                    results.offer(Message.getMessage(packet.getStanzaTo(), packet.getStanzaFrom(), StanzaType.normal, "Completed " + number, "Response", null, packet.getStanzaId()));
                    break;
                }
                catch (Exception e) {
                    results.offer(Message.getMessage(packet.getStanzaTo(), packet.getStanzaFrom(), StanzaType.normal, "Incorrect command parameter: " + (body_split.length > 1 ? body_split[1] : null) + ", expecting Integer.", "Response", null, packet.getStanzaId()));
                }
            }
        }
    }

    private static enum command {
        help,
        genn;

    }
}

