/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.conf.ConfigurationException;
import tigase.conf.ConfiguratorAbstract;
import tigase.disco.XMPPService;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Command;
import tigase.server.ComponentRegistrator;
import tigase.server.DisableDisco;
import tigase.server.Iq;
import tigase.server.MessageReceiver;
import tigase.server.MessageRouterConfig;
import tigase.server.MessageRouterIfc;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.server.ServerComponent;
import tigase.server.XMPPServer;
import tigase.stats.StatisticsList;
import tigase.sys.TigaseRuntime;
import tigase.util.TigaseStringprepException;
import tigase.util.UpdatesChecker;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;

public class MessageRouter
extends AbstractMessageReceiver
implements MessageRouterIfc {
    private static final Logger log = Logger.getLogger(MessageRouter.class.getName());
    private ConfiguratorAbstract config = null;
    private String disco_name = "Tigase";
    private boolean disco_show_version = true;
    private UpdatesChecker updates_checker = null;
    private Map<String, XMPPService> xmppServices = new ConcurrentHashMap<String, XMPPService>();
    private ConcurrentHashMap<String, ComponentRegistrator> registrators = new ConcurrentHashMap();
    private Map<String, MessageReceiver> receivers = new ConcurrentHashMap<String, MessageReceiver>();
    private boolean inProperties = false;
    private Set<String> connectionManagerNames = new ConcurrentSkipListSet<String>();
    private Map<JID, ServerComponent> components_byId = new ConcurrentHashMap<JID, ServerComponent>();
    private Map<String, ServerComponent> components = new ConcurrentHashMap<String, ServerComponent>();

    public void addComponent(ServerComponent component) throws ConfigurationException {
        log.log(Level.INFO, "Adding component: ", component.getClass().getSimpleName());
        for (ComponentRegistrator registr : this.registrators.values()) {
            if (registr == component) continue;
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Adding: {0} component to {1} registrator.", new Object[]{component.getName(), registr.getName()});
            }
            registr.addComponent(component);
        }
        this.components.put(component.getName(), component);
        this.components_byId.put(component.getComponentId(), component);
        if (component instanceof XMPPService) {
            this.xmppServices.put(component.getName(), (XMPPService)component);
        }
    }

    public void addRegistrator(ComponentRegistrator registr) throws ConfigurationException {
        log.log(Level.INFO, "Adding registrator: {0}", registr.getClass().getSimpleName());
        this.registrators.put(registr.getName(), registr);
        this.addComponent(registr);
        for (ServerComponent comp : this.components.values()) {
            registr.addComponent(comp);
        }
    }

    public void addRouter(MessageReceiver receiver) throws ConfigurationException {
        log.info("Adding receiver: " + receiver.getClass().getSimpleName());
        this.addComponent(receiver);
        this.receivers.put(receiver.getName(), receiver);
    }

    @Override
    public int hashCodeForPacket(Packet packet) {
        if (packet.getPacketFrom() != null && packet.getPacketFrom().getLocalpart() != null && this.connectionManagerNames.contains(packet.getPacketFrom().getLocalpart())) {
            return packet.getPacketFrom().hashCode();
        }
        if (packet.getPacketTo() != null && packet.getPacketTo().getLocalpart() != null && this.connectionManagerNames.contains(packet.getPacketTo().getLocalpart())) {
            return packet.getPacketTo().hashCode();
        }
        if (packet.getStanzaTo() != null) {
            return packet.getStanzaTo().getBareJID().hashCode();
        }
        if (packet.getPacketFrom() != null && !this.getComponentId().equals(packet.getPacketFrom())) {
            return packet.getPacketFrom().hashCode();
        }
        if (packet.getPacketTo() != null && !this.getComponentId().equals(packet.getPacketTo())) {
            return packet.getPacketTo().hashCode();
        }
        return 1;
    }

    @Override
    public int processingInThreads() {
        return Runtime.getRuntime().availableProcessors() * 4;
    }

    @Override
    public int processingOutThreads() {
        return 1;
    }

    @Override
    public void processPacket(Packet packet) {
        if (packet.getTo() == null) {
            log.log(Level.WARNING, "Packet with TO attribute set to NULL: {0}", packet);
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Processing packet: {0}", packet);
        }
        if (packet.getType() == StanzaType.error && packet.getFrom() != null && packet.getFrom().equals(packet.getTo())) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Possible infinite loop, dropping packet: {0}", packet);
            }
            return;
        }
        if (this.isLocalDiscoRequest(packet)) {
            ArrayDeque<Packet> results = new ArrayDeque<Packet>();
            this.processDiscoQuery(packet, results);
            if (results.size() > 0) {
                for (Packet res : results) {
                    this.addOutPacketNB(res);
                }
            }
            return;
        }
        ServerComponent comp = this.getLocalComponent(packet.getTo());
        if (comp != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "1. Packet will be processed by: {0}, {1}", new Object[]{comp.getComponentId(), packet});
            }
            ArrayDeque<Packet> results = new ArrayDeque<Packet>();
            if (comp == this) {
                this.processPacketMR(packet, results);
            } else {
                comp.processPacket(packet, results);
            }
            if (results.size() > 0) {
                for (Packet res : results) {
                    this.addOutPacketNB(res);
                }
            }
            return;
        }
        String host = packet.getTo().getDomain();
        ServerComponent[] comps = this.getComponentsForLocalDomain(host);
        if (comps == null) {
            comps = this.getServerComponentsForRegex(packet.getTo().getBareJID().toString());
        }
        if (comps == null && !this.isLocalDomain(host)) {
            comps = this.getComponentsForNonLocalDomain(host);
        }
        if (comps != null) {
            ArrayDeque<Packet> results = new ArrayDeque<Packet>();
            for (ServerComponent serverComponent : comps) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "2. Packet will be processed by: {0}, {1}", new Object[]{serverComponent.getComponentId(), packet});
                }
                serverComponent.processPacket(packet, results);
                if (results.size() <= 0) continue;
                for (Packet res : results) {
                    this.addOutPacketNB(res);
                }
            }
        } else {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("There is no component for the packet, sending it back");
            }
            try {
                this.addOutPacketNB(Authorization.SERVICE_UNAVAILABLE.getResponseMessage(packet, "There is no service found to process your request.", true));
            }
            catch (PacketErrorTypeException e) {
                log.warning("Can't process packet to local domain, dropping..." + packet.toStringSecure());
            }
        }
    }

    public void processPacketMR(Packet packet, Queue<Packet> results) {
        Iq iq = null;
        if (!(packet instanceof Iq)) {
            log.warning("I expect command (Iq) packet here, instead I got: " + packet.toString());
            return;
        }
        iq = (Iq)packet;
        if (packet.getPermissions() != Permissions.ADMIN) {
            try {
                Packet res = Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You are not authorized for this action.", true);
                results.offer(res);
            }
            catch (PacketErrorTypeException e) {
                log.warning("Packet processing exception: " + e);
            }
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Command received: " + iq.toString());
        }
        switch (iq.getCommand()) {
            case OTHER: {
                String[] spl;
                String cmd;
                if (iq.getStrCommand() == null || !iq.getStrCommand().startsWith("controll/") || !(cmd = (spl = iq.getStrCommand().split("/"))[1]).equals("stop")) break;
                Packet result = iq.commandResult(Command.DataType.result);
                results.offer(result);
                new Timer("Stopping...", true).schedule(new TimerTask(){

                    @Override
                    public void run() {
                        System.exit(0);
                    }
                }, 2000L);
                break;
            }
        }
    }

    public void removeComponent(ServerComponent component) {
        for (ComponentRegistrator registr : this.registrators.values()) {
            if (registr == component) continue;
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Removing: {0} component from {1} registrator.", new Object[]{component.getName(), registr.getName()});
            }
            registr.deleteComponent(component);
        }
        this.components.remove(component.getName());
        this.components_byId.remove(component.getComponentId());
        if (component instanceof XMPPService) {
            this.xmppServices.remove(component.getName());
        }
    }

    public void removeRegistrator(ComponentRegistrator registr) {
        log.log(Level.INFO, "Removing registrator: {0}", registr.getClass().getSimpleName());
        this.registrators.remove(registr.getName(), registr);
        this.removeComponent(registr);
        for (ServerComponent comp : this.components.values()) {
            registr.deleteComponent(comp);
        }
    }

    public void removeRouter(MessageReceiver receiver) {
        log.info("Removing receiver: " + receiver.getClass().getSimpleName());
        this.receivers.remove(receiver.getName());
        this.removeComponent(receiver);
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public void stop() {
        TreeSet<String> comp_names = new TreeSet<String>();
        comp_names.addAll(this.components.keySet());
        for (String name : comp_names) {
            ServerComponent comp = this.components.remove(name);
            if (comp == this || comp == null) continue;
            comp.release();
        }
        super.stop();
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> defs = super.getDefaults(params);
        MessageRouterConfig.getDefaults(defs, params, this.getName());
        return defs;
    }

    @Override
    public String getDiscoCategoryType() {
        return "im";
    }

    @Override
    public String getDiscoDescription() {
        return this.disco_name + (this.disco_show_version ? " ver. " + XMPPServer.getImplementationVersion() : "");
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        list.add(this.getName(), "Local hostname", this.getDefHostName().getDomain(), Level.INFO);
        TigaseRuntime runtime = TigaseRuntime.getTigaseRuntime();
        list.add(this.getName(), "Uptime", runtime.getUptimeString(), Level.INFO);
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(4);
        list.add(this.getName(), "Load average", format.format(runtime.getLoadAverage()), Level.FINE);
        list.add(this.getName(), "CPUs no", runtime.getCPUsNumber(), Level.FINEST);
        list.add(this.getName(), "Threads count", runtime.getThreadsNumber(), Level.FINEST);
        float cpuUsage = runtime.getCPUUsage();
        float heapUsage = runtime.getHeapMemUsage();
        float nonHeapUsage = runtime.getNonHeapMemUsage();
        list.add(this.getName(), "CPU usage [%]", cpuUsage, Level.FINE);
        list.add(this.getName(), "HEAP usage [%]", heapUsage, Level.FINE);
        list.add(this.getName(), "NONHEAP usage [%]", nonHeapUsage, Level.FINE);
        format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(1);
        list.add(this.getName(), "CPU usage", format.format(cpuUsage) + "%", Level.INFO);
        MemoryUsage heap = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        MemoryUsage nonHeap = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
        format = NumberFormat.getIntegerInstance();
        if (format instanceof DecimalFormat) {
            DecimalFormat decf = (DecimalFormat)format;
            decf.applyPattern(decf.toPattern() + " KB");
        }
        list.add(this.getName(), "Max Heap mem", format.format(heap.getMax() / 1024L), Level.INFO);
        list.add(this.getName(), "Used Heap", format.format(heap.getUsed() / 1024L), Level.INFO);
        list.add(this.getName(), "Free Heap", format.format(heap.getMax() == -1L ? 0L : (heap.getMax() - heap.getUsed()) / 1024L), Level.FINE);
        list.add(this.getName(), "Max NonHeap mem", format.format(nonHeap.getMax() / 1024L), Level.FINE);
        list.add(this.getName(), "Used NonHeap", format.format(nonHeap.getUsed() / 1024L), Level.FINE);
        list.add(this.getName(), "Free NonHeap", format.format(nonHeap.getMax() == -1L ? 0L : (nonHeap.getMax() - nonHeap.getUsed()) / 1024L), Level.FINE);
    }

    @Override
    public void setConfig(ConfiguratorAbstract config) throws ConfigurationException {
        this.components.put(this.getName(), this);
        this.config = config;
        this.addRegistrator(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        if (this.inProperties) {
            return;
        }
        this.inProperties = true;
        this.connectionManagerNames.add("c2s");
        this.connectionManagerNames.add("bosh");
        this.connectionManagerNames.add("s2s");
        if (props.get("disco-show-version") != null) {
            this.disco_show_version = (Boolean)props.get("disco-show-version");
        }
        if (props.get("disco-name") != null) {
            this.disco_name = (String)props.get("disco-name");
        }
        try {
            String[] reg_names;
            super.setProperties(props);
            this.updateServiceDiscoveryItem(this.getName(), null, this.getDiscoDescription(), "server", "im", false, new String[0]);
            if (props.size() == 1) {
                return;
            }
            HashSet<String> inactive_msgrec = new HashSet<String>(this.receivers.keySet());
            MessageRouterConfig conf = new MessageRouterConfig(props);
            for (String name : reg_names = conf.getRegistrNames()) {
                inactive_msgrec.remove(name);
                ComponentRegistrator cr = this.registrators.remove(name);
                String cls_name = (String)props.get("components/registrators/" + name + ".class");
                try {
                    if (cr == null || !cr.getClass().getName().equals(cls_name)) {
                        if (cr != null) {
                            cr.release();
                        }
                        cr = conf.getRegistrInstance(name);
                        cr.setName(name);
                    }
                    this.addRegistrator(cr);
                }
                catch (ConfigurationException ex) {
                    log.log(Level.WARNING, "configuration of component " + name + " failed - disabling component, error: " + ex.getMessage());
                    if (cr == null) continue;
                    this.removeRegistrator(cr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String[] msgrcv_names = conf.getMsgRcvActiveNames();
            for (String name : msgrcv_names) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Loading and registering message receiver: {0}", name);
                }
                inactive_msgrec.remove(name);
                ServerComponent mr = this.receivers.remove(name);
                this.xmppServices.remove(name);
                String cls_name = (String)props.get("components/msg-receivers/" + name + ".class");
                try {
                    if (mr == null || mr != null && !conf.componentClassEquals(cls_name, mr.getClass())) {
                        if (mr != null) {
                            if (mr instanceof MessageReceiver) {
                                this.removeRouter((MessageReceiver)mr);
                            } else {
                                this.removeComponent(mr);
                            }
                            mr.release();
                        }
                        mr = conf.getMsgRcvInstance(name);
                        mr.setName(name);
                        if (mr instanceof MessageReceiver) {
                            ((MessageReceiver)mr).setParent(this);
                            ((MessageReceiver)mr).start();
                        }
                    }
                    if (mr instanceof MessageReceiver) {
                        this.addRouter((MessageReceiver)mr);
                    } else {
                        this.addComponent(mr);
                    }
                    System.out.println("Loading component: " + mr.getComponentInfo());
                }
                catch (ClassNotFoundException e) {
                    log.log(Level.WARNING, "class for component = {0} could not be found - disabling component", name);
                }
                catch (ConfigurationException ex) {
                    log.log(Level.WARNING, "configuration of component " + name + " failed - disabling component, error: " + ex.getMessage());
                    if (mr == null) continue;
                    if (mr instanceof MessageReceiver) {
                        this.removeRouter((MessageReceiver)mr);
                        ((MessageReceiver)mr).release();
                        continue;
                    }
                    this.removeComponent(mr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (String name : inactive_msgrec) {
                ServerComponent mr = this.receivers.remove(name);
                this.xmppServices.remove(name);
                if (mr == null) continue;
                try {
                    if (mr instanceof MessageReceiver) {
                        this.removeRouter((MessageReceiver)mr);
                    } else {
                        this.removeComponent(mr);
                    }
                    mr.release();
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "exception releasing component:", ex);
                }
            }
            if (((Boolean)props.get("updates-checking")).booleanValue()) {
                this.installUpdatesChecker((Long)props.get("updates-checking-interval"));
            } else {
                log.log(Level.INFO, "Disabling updates checker.");
                this.stopUpdatesChecker();
            }
        }
        finally {
            this.inProperties = false;
        }
        for (ServerComponent comp : this.components.values()) {
            log.log(Level.INFO, "Initialization completed notification to: {0}", comp.getName());
            comp.initializationCompleted();
        }
    }

    @Override
    protected Integer getMaxQueueSize(int def) {
        return def * 10;
    }

    private void installUpdatesChecker(long interval) {
        this.stopUpdatesChecker();
        this.updates_checker = new UpdatesChecker(interval, this, "This is automated message generated by updates checking module.\n You can disable this function changing configuration option: '/" + this.getName() + "/" + "updates-checking" + "' or adjust" + " updates checking interval time changing option: " + "'/" + this.getName() + "/" + "updates-checking-interval" + "' which" + " now set to " + interval + " days.");
        this.updates_checker.start();
    }

    private void processDiscoQuery(Packet packet, Queue<Packet> results) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Processing disco query by: {0}", packet.toStringSecure());
        }
        JID toJid = packet.getStanzaTo();
        JID fromJid = packet.getStanzaFrom();
        String node = packet.getAttributeStaticStr(Iq.IQ_QUERY_PATH, "node");
        Element query = packet.getElement().getChild("query").clone();
        if (packet.isXMLNSStaticStr(Iq.IQ_QUERY_PATH, "http://jabber.org/protocol/disco#info")) {
            if (this.isLocalDomain(toJid.toString()) && node == null) {
                try {
                    query = this.getDiscoInfo(node, toJid.getLocalpart() == null ? JID.jidInstance(this.getName(), toJid.toString(), null) : toJid, fromJid);
                }
                catch (TigaseStringprepException e) {
                    log.log(Level.WARNING, "processing by stringprep throw exception for = {0}@{1}", new Object[]{this.getName(), toJid.toString()});
                }
                for (XMPPService xMPPService : this.xmppServices.values()) {
                    try {
                        List<Element> features = xMPPService.getDiscoFeatures(fromJid);
                        if (features == null) continue;
                        query.addChildren(features);
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Component service disco problem: " + xMPPService.getName(), e);
                    }
                }
            } else {
                for (XMPPService xMPPService : this.xmppServices.values()) {
                    try {
                        Element resp = xMPPService.getDiscoInfo(node, toJid, fromJid);
                        if (resp == null) continue;
                        query.addChildren(resp.getChildren());
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Component service disco problem: " + xMPPService.getName(), e);
                    }
                }
            }
        }
        if (packet.isXMLNSStaticStr(Iq.IQ_QUERY_PATH, "http://jabber.org/protocol/disco#items")) {
            boolean localDomain = this.isLocalDomain(toJid.toString());
            if (localDomain) {
                for (XMPPService comp : this.xmppServices.values()) {
                    try {
                        List<Element> items = comp.getDiscoItems(node, toJid, fromJid);
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "Localdomain: {0}, DiscoItems processed by: {1}, items: {2}", new Object[]{toJid, comp.getComponentId(), items == null ? null : items.toString()});
                        }
                        if (items == null || items.size() <= 0) continue;
                        query.addChildren(items);
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Component service disco problem: " + comp.getName(), e);
                    }
                }
            } else {
                ServerComponent serverComponent = this.getLocalComponent(toJid);
                if (serverComponent != null && serverComponent instanceof XMPPService) {
                    List<Element> items = ((XMPPService)serverComponent).getDiscoItems(node, toJid, fromJid);
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "DiscoItems processed by: {0}, items: {1}", new Object[]{serverComponent.getComponentId(), items == null ? null : items.toString()});
                    }
                    if (items != null && items.size() > 0) {
                        query.addChildren(items);
                    }
                }
            }
        }
        results.offer(packet.okResult(query, 0));
    }

    private void stopUpdatesChecker() {
        if (this.updates_checker != null) {
            this.updates_checker.interrupt();
            this.updates_checker = null;
        }
    }

    private ServerComponent[] getComponentsForLocalDomain(String domain) {
        return this.vHostManager.getComponentsForLocalDomain(domain);
    }

    private ServerComponent[] getComponentsForNonLocalDomain(String domain) {
        return this.vHostManager.getComponentsForNonLocalDomain(domain);
    }

    private ServerComponent getLocalComponent(JID jid) {
        int idx;
        ServerComponent comp;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Called for : {0}", jid);
        }
        if ((comp = this.components_byId.get(jid)) != null) {
            return comp;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "No componentID matches (fast lookup against exact address): {0}, for map: {1}; trying VHost lookup", new Object[]{jid, this.components_byId.keySet()});
        }
        if (jid.getLocalpart() != null && (comp = this.components.get(jid.getLocalpart())) != null && (this.isLocalDomain(jid.getDomain()) || jid.getDomain().equals(this.getDefHostName().getDomain()))) {
            return comp;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "No component name matches (VHost lookup against component name): {0}, for map: {1}, for all VHosts: {2}; trying other forms of addressing", new Object[]{jid, this.components.keySet(), this.vHostManager.getAllVHosts()});
        }
        if ((idx = jid.getDomain().indexOf(46)) > 0) {
            String cmpName = jid.getDomain().substring(0, idx);
            String basename = jid.getDomain().substring(idx + 1);
            comp = this.components.get(cmpName);
            if (comp != null && (this.isLocalDomain(basename) || basename.equals(this.getDefHostName().getDomain()))) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Component matched: {0}, for comp: {1}, basename: {3}", new Object[]{jid, this.components.keySet(), comp, basename});
                }
                return comp;
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Component match failed: {0}, for comp: {1}, basename: {3}", new Object[]{jid, this.components.keySet(), comp, basename});
            }
        }
        return null;
    }

    private ServerComponent[] getServerComponentsForRegex(String id) {
        LinkedHashSet<MessageReceiver> comps = new LinkedHashSet<MessageReceiver>();
        for (MessageReceiver mr : this.receivers.values()) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Checking routings for: " + mr.getName());
            }
            if (!mr.isInRegexRoutings(id)) continue;
            comps.add(mr);
        }
        if (comps.size() > 0) {
            return comps.toArray(new ServerComponent[comps.size()]);
        }
        return null;
    }

    private boolean isDiscoDisabled(ServerComponent comp, JID to) {
        if (comp != null) {
            return comp instanceof DisableDisco;
        }
        ServerComponent[] comps = this.getComponentsForLocalDomain(to.getDomain());
        if (comps != null) {
            for (ServerComponent c : comps) {
                if (!(c instanceof DisableDisco)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isLocalDiscoRequest(Packet packet) {
        boolean result = false;
        JID to = packet.getStanzaTo();
        ServerComponent comp = to == null ? null : this.getLocalComponent(to);
        result = packet.isServiceDisco() && packet.getType() == StanzaType.get && packet.getStanzaFrom() != null && (packet.getStanzaTo() == null || (comp != null || this.isLocalDomain(packet.getStanzaTo().toString())) && !this.isDiscoDisabled(comp, to));
        return result;
    }
}

