/*
 * Decompiled with CFR 0.152.
 */
package tigase.kernel;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tigase.kernel.BeanConfig;
import tigase.kernel.Dependency;
import tigase.kernel.Inject;

public class DependencyManager {
    private final Map<String, BeanConfig> beanConfigs = new HashMap<String, BeanConfig>();

    private static Field[] getAllFields(Class<?> klass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(klass.getDeclaredFields()));
        if (klass.getSuperclass() != null) {
            fields.addAll(Arrays.asList(DependencyManager.getAllFields(klass.getSuperclass())));
        }
        return fields.toArray(new Field[0]);
    }

    protected BeanConfig createBeanConfig(String beanName, Class<?> beanClass) {
        BeanConfig result = new BeanConfig(beanName, beanClass);
        this.prepareDependencies(result);
        return result;
    }

    private Map<Field, Inject> createFieldsDependencyList(Class<?> cls) {
        HashMap<Field, Inject> deps = new HashMap<Field, Inject>();
        for (Field field : DependencyManager.getAllFields(cls)) {
            Inject injectAnnotation = field.getAnnotation(Inject.class);
            if (injectAnnotation == null) continue;
            deps.put(field, injectAnnotation);
        }
        return deps;
    }

    public BeanConfig[] getBeanConfig(Dependency dependency) {
        if (dependency.getBeanName() != null) {
            return new BeanConfig[]{this.beanConfigs.get(dependency.getBeanName())};
        }
        if (dependency.getType() != null) {
            List<BeanConfig> bcs = this.getBeanConfigs(dependency.getType());
            return bcs.toArray(new BeanConfig[0]);
        }
        throw new RuntimeException("Unsupported dependecy type.");
    }

    public BeanConfig getBeanConfig(String beanName) {
        return this.beanConfigs.get(beanName);
    }

    public Collection<BeanConfig> getBeanConfigs() {
        return Collections.unmodifiableCollection(this.beanConfigs.values());
    }

    public List<BeanConfig> getBeanConfigs(Class<?> type) {
        ArrayList<BeanConfig> result = new ArrayList<BeanConfig>();
        for (BeanConfig bc : this.beanConfigs.values()) {
            if (!type.isAssignableFrom(bc.getClazz())) continue;
            result.add(bc);
        }
        return result;
    }

    protected void prepareDependencies(BeanConfig beanConfig) {
        String id = beanConfig.getBeanName();
        Class<?> cls = beanConfig.getClazz();
        Map<Field, Inject> deps = this.createFieldsDependencyList(cls);
        for (Map.Entry<Field, Inject> e : deps.entrySet()) {
            Dependency d = new Dependency();
            d.setField(e.getKey());
            if (!e.getValue().bean().isEmpty()) {
                d.setBeanName(e.getValue().bean());
            } else if (e.getValue().type() != Inject.EMPTY.class) {
                d.setType(e.getValue().type());
            } else if (e.getKey().getType().isArray()) {
                d.setType(e.getKey().getType().getComponentType());
            } else {
                d.setType(e.getKey().getType());
            }
            beanConfig.getFieldDependencies().put(e.getKey(), d);
        }
    }

    public BeanConfig registerBeanClass(String beanName, Class<?> beanClass) {
        BeanConfig c = this.createBeanConfig(beanName, beanClass);
        this.beanConfigs.put(beanName, c);
        return c;
    }

    public void unregister(String beanName) {
        this.beanConfigs.remove(beanName);
    }
}

