/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.jdbc;

import java.io.IOException;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import tigase.db.AuthRepository;
import tigase.db.AuthorizationException;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.Repository;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.util.Algorithms;
import tigase.util.Base64;
import tigase.xmpp.BareJID;

@Repository.Meta(supportedUris={"jdbc:[^:]+:.*"})
public class DrupalWPAuth
implements AuthRepository {
    private static final Logger log = Logger.getLogger(DrupalWPAuth.class.getName());
    private static final String[] non_sasl_mechs = new String[]{"password"};
    private static final String[] sasl_mechs = new String[]{"PLAIN"};
    public static final String DRUPAL_USERS_TBL = "users";
    public static final String DRUPAL_NAME_FLD = "name";
    public static final String DRUPAL_PASS_FLD = "pass";
    public static final String DRUPAL_STATUS_FLD = "status";
    public static final int DRUPAL_OK_STATUS_VAL = 1;
    public static final String WP_USERS_TBL = "wp_users";
    public static final String WP_NAME_FLD = "user_login";
    public static final String WP_PASS_FLD = "user_pass";
    public static final String WP_STATUS_FLD = "user_status";
    public static final int WP_OK_STATUS_VAL = 0;
    private static final String SELECT_PASSWORD_QUERY_KEY = "select-password-drupal-wp-query-key";
    private static final String SELECT_STATUS_QUERY_KEY = "select-status-drupal-wp-query-key";
    private static final String INSERT_USER_QUERY_KEY = "insert-user-drupal-wp-query-key";
    private static final String UPDATE_LAST_LOGIN_QUERY_KEY = "update-last-login-drupal-wp-query-key";
    private static final String UPDATE_ONLINE_STATUS_QUERY_KEY = "update-online-status-drupal-wp-query-key";
    private DataRepository data_repo = null;
    private String name_fld = "name";
    private String users_tbl = "users";
    private int status_val = 1;
    private String status_fld = "status";
    private String pass_fld = "pass";
    private boolean online_status = false;
    private boolean last_login = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUser(BareJID user, String password) throws UserExistsException, TigaseDBException {
        try {
            PreparedStatement user_add_st;
            PreparedStatement preparedStatement = user_add_st = this.data_repo.getPreparedStatement(user, INSERT_USER_QUERY_KEY);
            synchronized (preparedStatement) {
                user_add_st.setString(1, user.getLocalpart());
                user_add_st.setString(2, Algorithms.hexDigest("", password, "MD5"));
                user_add_st.executeUpdate();
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new TigaseDBException("Password encoding algorithm is not supported.", e);
        }
        catch (SQLException e) {
            throw new UserExistsException("Error while adding user to repository, user exists?", e);
        }
    }

    @Override
    @Deprecated
    public boolean digestAuth(BareJID user, String digest, String id, String alg) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        throw new AuthorizationException("Not supported.");
    }

    @Override
    public String getResourceUri() {
        return this.data_repo.getResourceUri();
    }

    @Override
    public long getUsersCount() {
        return -1L;
    }

    @Override
    public long getUsersCount(String domain) {
        return -1L;
    }

    @Override
    public void initRepository(String connection_str, Map<String, String> params) throws DBInitException {
        try {
            this.data_repo = RepositoryFactory.getDataRepository(null, connection_str, params);
            if (connection_str.contains("online_status=true")) {
                this.online_status = true;
            }
            if (connection_str.contains("wp_mode=true")) {
                this.online_status = false;
                this.last_login = false;
                this.name_fld = WP_NAME_FLD;
                this.users_tbl = WP_USERS_TBL;
                this.status_val = 0;
                this.status_fld = WP_STATUS_FLD;
                this.pass_fld = WP_PASS_FLD;
                log.log(Level.INFO, "Initializing Wordpress repository: {0}", connection_str);
            } else {
                log.log(Level.INFO, "Initializing Drupal repository: {0}", connection_str);
            }
            String query = "select " + this.pass_fld + " from " + this.users_tbl + " where " + this.name_fld + " = ?";
            this.data_repo.initPreparedStatement(SELECT_PASSWORD_QUERY_KEY, query);
            query = "select " + this.status_fld + " from " + this.users_tbl + " where " + this.name_fld + " = ?";
            this.data_repo.initPreparedStatement(SELECT_STATUS_QUERY_KEY, query);
            query = "insert into " + this.users_tbl + " (" + this.name_fld + ", " + this.pass_fld + ", " + this.status_fld + ")" + " values (?, ?, " + this.status_val + ")";
            this.data_repo.initPreparedStatement(INSERT_USER_QUERY_KEY, query);
            query = "update " + this.users_tbl + " set access=?, login=? where " + this.name_fld + " = ?";
            this.data_repo.initPreparedStatement(UPDATE_LAST_LOGIN_QUERY_KEY, query);
            query = "update " + this.users_tbl + " set online_status=online_status+? where " + this.name_fld + " = ?";
            this.data_repo.initPreparedStatement(UPDATE_ONLINE_STATUS_QUERY_KEY, query);
        }
        catch (Exception e) {
            this.data_repo = null;
            throw new DBInitException("Problem initializing jdbc connection: " + connection_str, e);
        }
        try {
            if (this.online_status) {
                Statement stmt = this.data_repo.createStatement(null);
                stmt.executeUpdate("update users set online_status = 0;");
                stmt.close();
                stmt = null;
            }
        }
        catch (SQLException e) {
            if (e.getMessage().contains("'online_status'")) {
                try {
                    Statement stmt = this.data_repo.createStatement(null);
                    stmt.executeUpdate("alter table users add online_status int default 0;");
                    stmt.close();
                    stmt = null;
                }
                catch (SQLException ex) {
                    this.data_repo = null;
                    throw new DBInitException("Problem initializing jdbc connection: " + connection_str, ex);
                }
            }
            this.data_repo = null;
            throw new DBInitException("Problem initializing jdbc connection: " + connection_str, e);
        }
    }

    @Override
    public void logout(BareJID user) throws UserNotFoundException, TigaseDBException {
        this.updateOnlineStatus(user, -1);
    }

    @Override
    public boolean otherAuth(Map<String, Object> props) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        String proto = (String)props.get("protocol");
        if (proto.equals("sasl")) {
            String mech = (String)props.get("mechanism");
            try {
                if (mech.equals("PLAIN")) {
                    boolean login_ok = this.saslAuth(props);
                    if (login_ok) {
                        BareJID user = (BareJID)props.get("user-id");
                        if (!this.isActive(user)) {
                            throw new AuthorizationException("User account has been blocked.");
                        }
                        this.updateLastLogin(user);
                        this.updateOnlineStatus(user, 1);
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "User authenticated: {0}", user);
                        }
                    } else if (log.isLoggable(Level.FINEST)) {
                        log.finest("User NOT authenticated");
                    }
                    return login_ok;
                }
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "OTHER authentication error: ", e);
                }
                throw new AuthorizationException("Sasl exception.", e);
            }
            throw new AuthorizationException("Mechanism is not supported: " + mech);
        }
        if (proto.equals("nonsasl")) {
            String password = (String)props.get("password");
            BareJID user_id = (BareJID)props.get("user-id");
            if (password != null) {
                return this.plainAuth(user_id, password);
            }
            String digest = (String)props.get("digest");
            if (digest != null) {
                String digest_id = (String)props.get("digest-id");
                return this.digestAuth(user_id, digest, digest_id, "SHA");
            }
        }
        throw new AuthorizationException("Protocol is not supported: " + proto);
    }

    @Override
    @Deprecated
    public boolean plainAuth(BareJID user, String password) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        try {
            if (!this.isActive(user)) {
                throw new AuthorizationException("User account has been blocked.");
            }
            String enc_passwd = Algorithms.hexDigest("", password, "MD5");
            String db_password = this.getPassword(user);
            boolean login_ok = db_password.equals(enc_passwd);
            if (login_ok) {
                this.updateLastLogin(user);
                this.updateOnlineStatus(user, 1);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "User authenticated: {0}", user);
                }
            } else if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "User NOT authenticated: {0}", user);
            }
            return login_ok;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AuthorizationException("Password encoding algorithm is not supported.", e);
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", e);
        }
    }

    @Override
    public void queryAuth(Map<String, Object> authProps) {
        String protocol = (String)authProps.get("protocol");
        if (protocol.equals("nonsasl")) {
            authProps.put("result", non_sasl_mechs);
        }
        if (protocol.equals("sasl")) {
            authProps.put("result", sasl_mechs);
        }
    }

    @Override
    public void removeUser(BareJID user) throws UserNotFoundException, TigaseDBException {
        throw new TigaseDBException("Removing user is not supported.");
    }

    @Override
    public void updatePassword(BareJID user, String password) throws UserNotFoundException, TigaseDBException {
        throw new TigaseDBException("Updating user password is not supported.");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getPassword(BareJID user) throws UserNotFoundException, TigaseDBException {
        ResultSet rs = null;
        try {
            String string;
            PreparedStatement pass_st;
            PreparedStatement preparedStatement = pass_st = this.data_repo.getPreparedStatement(user, SELECT_PASSWORD_QUERY_KEY);
            synchronized (preparedStatement) {
                pass_st.setString(1, user.getLocalpart());
                rs = pass_st.executeQuery();
                if (!rs.next()) throw new UserNotFoundException("User does not exist: " + user);
                string = rs.getString(1);
            }
            this.data_repo.release(null, rs);
            return string;
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem with retrieving user password.", e);
        }
        catch (Throwable throwable) {
            this.data_repo.release(null, rs);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isActive(BareJID user) throws SQLException, UserNotFoundException {
        ResultSet rs = null;
        try {
            boolean bl;
            PreparedStatement status_st;
            PreparedStatement preparedStatement = status_st = this.data_repo.getPreparedStatement(user, SELECT_STATUS_QUERY_KEY);
            synchronized (preparedStatement) {
                status_st.setString(1, user.getLocalpart());
                rs = status_st.executeQuery();
                if (!rs.next()) throw new UserNotFoundException("User does not exist: " + user);
                bl = rs.getInt(1) == this.status_val;
            }
            this.data_repo.release(null, rs);
            return bl;
        }
        catch (Throwable throwable) {
            this.data_repo.release(null, rs);
            throw throwable;
        }
    }

    private boolean saslAuth(Map<String, Object> props) throws AuthorizationException {
        try {
            String data_str;
            SaslServer ss = (SaslServer)props.get("SaslServer");
            if (ss == null) {
                TreeMap<String, String> sasl_props = new TreeMap<String, String>();
                sasl_props.put("javax.security.sasl.qop", "auth");
                sasl_props.put("password-encryption", "MD5");
                ss = Sasl.createSaslServer((String)props.get("mechanism"), "xmpp", (String)props.get("server-name"), sasl_props, new SaslCallbackHandler(props));
                props.put("SaslServer", ss);
            }
            byte[] in_data = (data_str = (String)props.get("data")) != null ? Base64.decode(data_str) : new byte[]{};
            byte[] challenge = ss.evaluateResponse(in_data);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "challenge: {0}", challenge != null ? new String(challenge) : "null");
            }
            String challenge_str = challenge != null && challenge.length > 0 ? Base64.encode(challenge) : null;
            props.put("result", challenge_str);
            return ss.isComplete();
        }
        catch (SaslException e) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "SASL authentication error: ", e);
            }
            throw new AuthorizationException("Sasl exception.", e);
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "SASL authentication error: ", e);
            }
            throw new AuthorizationException("Sasl exception.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLastLogin(BareJID user) throws TigaseDBException {
        if (this.last_login) {
            try {
                PreparedStatement update_last_login_st;
                PreparedStatement preparedStatement = update_last_login_st = this.data_repo.getPreparedStatement(user, UPDATE_LAST_LOGIN_QUERY_KEY);
                synchronized (preparedStatement) {
                    BigDecimal bd = new BigDecimal(System.currentTimeMillis() / 1000L);
                    update_last_login_st.setBigDecimal(1, bd);
                    update_last_login_st.setBigDecimal(2, bd);
                    update_last_login_st.setString(3, user.getLocalpart());
                    update_last_login_st.executeUpdate();
                }
            }
            catch (SQLException e) {
                throw new TigaseDBException("Error accessing repository.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOnlineStatus(BareJID user, int status) throws TigaseDBException {
        if (this.online_status) {
            try {
                PreparedStatement update_online_status;
                PreparedStatement preparedStatement = update_online_status = this.data_repo.getPreparedStatement(user, UPDATE_ONLINE_STATUS_QUERY_KEY);
                synchronized (preparedStatement) {
                    update_online_status.setInt(1, status);
                    update_online_status.setString(2, user.getLocalpart());
                    update_online_status.executeUpdate();
                }
            }
            catch (SQLException e) {
                throw new TigaseDBException("Error accessing repository.", e);
            }
        }
    }

    private class SaslCallbackHandler
    implements CallbackHandler {
        private Map<String, Object> options = null;

        private SaslCallbackHandler(Map<String, Object> options) {
            this.options = options;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            BareJID jid = null;
            for (int i = 0; i < callbacks.length; ++i) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Callback: {0}", callbacks[i].getClass().getSimpleName());
                }
                if (callbacks[i] instanceof RealmCallback) {
                    RealmCallback rc = (RealmCallback)callbacks[i];
                    String realm = (String)this.options.get("realm");
                    if (realm != null) {
                        rc.setText(realm);
                    }
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.log(Level.FINEST, "RealmCallback: {0}", realm);
                    continue;
                }
                if (callbacks[i] instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callbacks[i];
                    String user_name = nc.getName();
                    if (user_name == null) {
                        user_name = nc.getDefaultName();
                    }
                    jid = BareJID.bareJIDInstanceNS(user_name, (String)this.options.get("realm"));
                    this.options.put("user-id", jid);
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.log(Level.FINEST, "NameCallback: {0}", user_name);
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callbacks[i];
                    try {
                        String passwd = DrupalWPAuth.this.getPassword(jid);
                        pc.setPassword(passwd.toCharArray());
                        if (!log.isLoggable(Level.FINEST)) continue;
                        log.log(Level.FINEST, "PasswordCallback: {0}", passwd);
                        continue;
                    }
                    catch (Exception e) {
                        throw new IOException("Password retrieving problem.", e);
                    }
                }
                if (callbacks[i] instanceof AuthorizeCallback) {
                    AuthorizeCallback authCallback = (AuthorizeCallback)callbacks[i];
                    String authenId = authCallback.getAuthenticationID();
                    String authorId = authCallback.getAuthorizationID();
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "AuthorizeCallback: authenId: {0}", authenId);
                        log.log(Level.FINEST, "AuthorizeCallback: authorId: {0}", authorId);
                    }
                    authCallback.setAuthorized(true);
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
        }
    }
}

