/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats.collector;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xml.XMLUtils;
import tigase.xmpp.BareJID;

public class StatisticsData {
    private static final Logger a = Logger.getLogger(StatisticsData.class.getCanonicalName());
    private static final String b = "statistics";
    private static final String c = "timestamp";
    private static final String d = "domain";
    private static final String e = "vhosts";
    private static final String f = "uptime";
    private static final String g = "heap";
    private static final String h = "item";
    private static final String i = "max";
    private static final String j = "used";
    private static final String k = "users";
    private static final String l = "online";
    private static final String m = "active";
    private static final String n = "cluster";
    private static final String o = "nodes_count";
    private static final String p = "additional_data";
    private static final String q = "max_today";
    private static final String r = "max_yesterday";
    public static final String[] DOMAIN_PATH = new String[]{"statistics", "domain"};
    public static final String[] TIMESTAMP_PATH = new String[]{"statistics", "timestamp"};
    public static final String[] VHOSTS_ITEM_PATH = new String[]{"statistics", "vhosts"};
    public static final String[] UPTIME_PATH = new String[]{"statistics", "uptime"};
    public static final String[] HEAP_USED_PATH = new String[]{"statistics", "heap", "used"};
    public static final String[] HEAP_MAX_PATH = new String[]{"statistics", "heap", "max"};
    public static final String[] CLUSTER_NODES_COUNT_PATH = new String[]{"statistics", "cluster", "nodes_count"};
    public static final String[] USERS_ONLINE_PATH = new String[]{"statistics", "users", "online"};
    public static final String[] USERS_ACTIVE_PATH = new String[]{"statistics", "users", "active"};
    public static final String[] MAX_SESSIONS_TODAY_PATH = new String[]{"statistics", "users", "max_today"};
    public static final String[] MAX_SESSIONS_YESTERDAY_PATH = new String[]{"statistics", "users", "max_yesterday"};
    public static final String[] ADDITIONAL_DATA_PATH = new String[]{"statistics", "additional_data"};
    private static final SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    protected static int VERSION = 1;
    private final BareJID t;
    private final Date u;
    private List v;
    private long w;
    private long x;
    private long y;
    private long z;
    private long A;
    private int B;
    private String C;
    private long D;
    private long E;

    public StatisticsData(BareJID bareJID) {
        this(bareJID, new Date());
    }

    private StatisticsData(BareJID bareJID, Date date) {
        this.t = bareJID;
        this.u = date;
        this.v = new ArrayList();
    }

    public int getVersion() {
        return VERSION;
    }

    public BareJID getDomain() {
        return this.t;
    }

    public Date getTimestamp() {
        return this.u;
    }

    public List getVHosts() {
        return Collections.unmodifiableList(this.v);
    }

    public void addVHost(BareJID bareJID) {
        this.v.add(bareJID);
    }

    public void addVHosts(Collection collection) {
        this.v.addAll(collection);
    }

    public long getUptime() {
        return this.w;
    }

    public void setUptime(long l) {
        this.w = l;
    }

    public long getHeapUsed() {
        return this.y;
    }

    public void setHeapUsed(long l) {
        this.y = l;
    }

    public long getHeapMax() {
        return this.x;
    }

    public void setHeapMax(long l) {
        this.x = l;
    }

    public int getClusterNodesCount() {
        return this.B;
    }

    public void setClusterNodesCount(int n) {
        this.B = n;
    }

    public long getUsersActive() {
        return this.A;
    }

    public void setUsersActive(long l) {
        this.A = l;
    }

    public long getUsersOnline() {
        return this.z;
    }

    public void setUsersOnline(long l) {
        this.z = l;
    }

    public String getAdditionalData() {
        return this.C;
    }

    public void setAdditionalData(String string) {
        this.C = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatisticsData fromElement(Element element) throws TigaseStringprepException {
        a.log(Level.FINEST, "element = " + element);
        if (element.getName() != b) {
            throw new IllegalArgumentException("Invalid element passed, elem = " + element.toString());
        }
        int n = Integer.parseInt(element.getAttributeStaticStr("version"));
        if (n != VERSION) {
            throw new IllegalArgumentException("Invalid version, expected " + VERSION + " got " + n);
        }
        a.log(Level.FINEST, "version = " + n);
        Object object = null;
        Object object2 = element.getChildCData(DOMAIN_PATH);
        if (object2 != null) {
            object = BareJID.bareJIDInstance((String)object2);
        }
        a.log(Level.FINEST, "domain = " + object);
        object2 = null;
        String string = element.getChildCData(TIMESTAMP_PATH);
        Object object3 = s;
        synchronized (object3) {
            try {
                object2 = s.parse(string);
            }
            catch (ParseException parseException) {}
        }
        a.log(Level.FINEST, "timestamp = " + object2);
        object3 = new StatisticsData((BareJID)object, (Date)object2);
        object = element.getChildren(VHOSTS_ITEM_PATH);
        a.log(Level.FINEST, "vhosts = " + Arrays.asList(object));
        object = object.iterator();
        while (object.hasNext()) {
            object2 = (Element)object.next();
            ((StatisticsData)object3).v.add(BareJID.bareJIDInstance((String)object2.getCData()));
        }
        a.log(Level.FINEST, "data.vhosts = " + Arrays.asList(((StatisticsData)object3).v));
        ((StatisticsData)object3).w = Long.parseLong(element.getCData(UPTIME_PATH));
        ((StatisticsData)object3).y = Long.parseLong(element.getCData(HEAP_USED_PATH));
        ((StatisticsData)object3).x = Long.parseLong(element.getCData(HEAP_MAX_PATH));
        ((StatisticsData)object3).B = Integer.parseInt(element.getCData(CLUSTER_NODES_COUNT_PATH));
        ((StatisticsData)object3).z = Long.parseLong(element.getCData(USERS_ONLINE_PATH));
        ((StatisticsData)object3).A = Long.parseLong(element.getCData(USERS_ACTIVE_PATH));
        ((StatisticsData)object3).C = element.getCData(ADDITIONAL_DATA_PATH);
        if (((StatisticsData)object3).C != null) {
            ((StatisticsData)object3).C = XMLUtils.unescape((String)((StatisticsData)object3).C);
        }
        ((StatisticsData)object3).E = (object = element.getCData(MAX_SESSIONS_TODAY_PATH)) == null ? -1L : Long.parseLong((String)object);
        object = element.getCData(MAX_SESSIONS_YESTERDAY_PATH);
        ((StatisticsData)object3).D = object == null ? -1L : Long.parseLong((String)object);
        return object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element toElement() {
        BareJID bareJID2;
        Object object;
        Element element = new Element(b);
        element.setAttribute("version", String.valueOf(this.getVersion()));
        element.addChild((XMLNodeIfc)new Element(d, this.t.toString()));
        SimpleDateFormat simpleDateFormat = s;
        synchronized (simpleDateFormat) {
            object = s.format(this.u);
        }
        element.addChild((XMLNodeIfc)new Element(c, (String)object));
        if (!this.v.isEmpty()) {
            simpleDateFormat = new Element(e);
            for (BareJID bareJID2 : this.v) {
                simpleDateFormat.addChild((XMLNodeIfc)new Element(h, bareJID2.toString()));
            }
            element.addChild((XMLNodeIfc)simpleDateFormat);
        }
        element.addChild((XMLNodeIfc)new Element(f, String.valueOf(this.w)));
        simpleDateFormat = new Element(g);
        simpleDateFormat.addChild((XMLNodeIfc)new Element(j, String.valueOf(this.y)));
        simpleDateFormat.addChild((XMLNodeIfc)new Element(i, String.valueOf(this.x)));
        element.addChild((XMLNodeIfc)simpleDateFormat);
        object = new Element(n);
        object.addChild((XMLNodeIfc)new Element(o, String.valueOf(this.B)));
        element.addChild((XMLNodeIfc)object);
        bareJID2 = new Element(k);
        bareJID2.addChild((XMLNodeIfc)new Element(l, String.valueOf(this.z)));
        bareJID2.addChild((XMLNodeIfc)new Element(m, String.valueOf(this.A)));
        bareJID2.addChild((XMLNodeIfc)new Element(q, String.valueOf(this.E)));
        bareJID2.addChild((XMLNodeIfc)new Element(r, String.valueOf(this.D)));
        element.addChild((XMLNodeIfc)bareJID2);
        if (this.C != null && !this.C.isEmpty()) {
            object = new Element(p);
            object.setCData(XMLUtils.escape((String)this.C));
            element.addChild((XMLNodeIfc)object);
        }
        return element;
    }

    public void setMaxSessionsToday(long l) {
        this.E = l;
    }

    public void setMaxSessionsYesterday(long l) {
        this.D = l;
    }

    public long getMaxSessionsYesterday() {
        return this.D;
    }

    public long getMaxSessionsToday() {
        return this.E;
    }
}

