/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.roster;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import tigase.util.TigaseStringprepException;
import tigase.util.XMPPStringPrepFactory;
import tigase.xml.Element;
import tigase.xml.XMLUtils;
import tigase.xmpp.JID;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.roster.RosterAbstract;

public class RosterElement {
    protected static final long INITIAL_LAST_SEEN_VAL = 1000L;
    private static final String ACTIVITY_ATT = "activity";
    private static final String ELEM_NAME = "contact";
    private static final String GRP_ATT = "groups";
    private static final double INITIAL_ACTIVITY_VAL = 1.0;
    private static final double INITIAL_WEIGHT_VAL = 1.0;
    private static final String JID_ATT = "jid";
    private static final String LAST_SEEN_ATT = "last-seen";
    private static final Logger log = Logger.getLogger(RosterElement.class.getName());
    private static final String NAME_ATT = "name";
    private static final String OTHER_ATT = "other";
    private static final String STRINGPREP_ATT = "preped";
    private static final String SUBS_ATT = "subs";
    private static final String WEIGHT_ATT = "weight";
    private String[] groups = null;
    private JID jid = null;
    private String name = null;
    private String otherData = null;
    private long lastSeen = 1000L;
    private double activity = 1.0;
    private XMPPResourceConnection session = null;
    private String stringpreped = null;
    private RosterAbstract.SubscriptionType subscription = null;
    private double weight = 1.0;
    private boolean presence_sent = false;
    private boolean persistent = true;
    private Map<String, Boolean> onlineMap = new ConcurrentHashMap<String, Boolean>();
    private boolean modified = false;

    public RosterElement(Element roster_el, XMPPResourceConnection session) throws TigaseStringprepException {
        this.session = session;
        if (roster_el.getName() == ELEM_NAME) {
            String num_str;
            String other_data;
            this.stringpreped = roster_el.getAttributeStaticStr(STRINGPREP_ATT);
            this.setJid(roster_el.getAttributeStaticStr(JID_ATT));
            this.setName(roster_el.getAttributeStaticStr(NAME_ATT));
            this.subscription = roster_el.getAttributeStaticStr(SUBS_ATT) == null ? RosterAbstract.SubscriptionType.none : RosterAbstract.SubscriptionType.valueOf(roster_el.getAttributeStaticStr(SUBS_ATT));
            String grps = roster_el.getAttributeStaticStr(GRP_ATT);
            if (grps != null && !grps.trim().isEmpty()) {
                this.setGroups(grps.split(","));
            }
            if ((other_data = roster_el.getAttributeStaticStr(OTHER_ATT)) != null && !other_data.trim().isEmpty()) {
                this.otherData = other_data;
            }
            if ((num_str = roster_el.getAttributeStaticStr(ACTIVITY_ATT)) != null) {
                try {
                    this.activity = Double.parseDouble(num_str);
                }
                catch (NumberFormatException nfe) {
                    log.warning("Incorrect activity field: " + num_str);
                    this.activity = 1.0;
                }
            }
            if ((num_str = roster_el.getAttributeStaticStr(WEIGHT_ATT)) != null) {
                try {
                    this.weight = Double.parseDouble(num_str);
                }
                catch (NumberFormatException nfe) {
                    log.warning("Incorrect weight field: " + num_str);
                    this.weight = 1.0;
                }
            }
            if ((num_str = roster_el.getAttributeStaticStr(LAST_SEEN_ATT)) != null) {
                try {
                    this.lastSeen = Long.parseLong(num_str);
                }
                catch (NumberFormatException nfe) {
                    log.warning("Incorrect last seen field: " + num_str);
                    this.lastSeen = 1000L;
                }
            }
        } else {
            log.warning("Incorrect roster data: " + roster_el.toString());
        }
    }

    public RosterElement(JID jid, String name, String[] groups, XMPPResourceConnection session) {
        this.stringpreped = XMPPStringPrepFactory.STRINGPREP_PROCESSOR;
        this.session = session;
        this.setJid(jid);
        this.setName(name);
        this.setGroups(groups);
        this.subscription = RosterAbstract.SubscriptionType.none;
    }

    public void addGroups(String[] groups) {
        if (groups != null) {
            if (this.groups == null) {
                this.setGroups(groups);
            } else {
                HashSet<String> groupsSet = new HashSet<String>();
                for (String group : this.groups) {
                    groupsSet.add(group);
                }
                for (String group : groups) {
                    groupsSet.add(group);
                }
                this.setGroups(groupsSet.toArray(new String[groupsSet.size()]));
            }
        }
    }

    public String[] getGroups() {
        return this.groups;
    }

    public JID getJid() {
        return this.jid;
    }

    public String getName() {
        return this.name;
    }

    public String getOtherData() {
        return this.otherData;
    }

    public Element getRosterElement() {
        Element elem = new Element(ELEM_NAME, new String[]{JID_ATT, SUBS_ATT, NAME_ATT, STRINGPREP_ATT}, new String[]{this.jid.toString(), this.subscription.toString(), XMLUtils.escape(this.name), "" + this.stringpreped});
        if (this.groups != null && this.groups.length > 0) {
            String grps = "";
            for (String group : this.groups) {
                grps = grps + XMLUtils.escape(group) + ",";
            }
            grps = grps.substring(0, grps.length() - 1);
            elem.setAttribute(GRP_ATT, grps);
        }
        if (this.otherData != null) {
            elem.setAttribute(OTHER_ATT, this.otherData);
        }
        elem.setAttribute(ACTIVITY_ATT, Double.toString(this.activity));
        elem.setAttribute(WEIGHT_ATT, Double.toString(this.weight));
        elem.setAttribute(LAST_SEEN_ATT, Long.toString(this.lastSeen));
        this.modified = false;
        return elem;
    }

    public Element getRosterItem() {
        Element item = new Element("item");
        item.setAttribute(JID_ATT, this.jid.toString());
        item.addAttributes(this.subscription.getSubscriptionAttr());
        if (this.name != null) {
            item.setAttribute(NAME_ATT, XMLUtils.escape(this.name));
        }
        if (this.groups != null) {
            for (String gr : this.groups) {
                Element group = new Element("group");
                group.setCData(XMLUtils.escape(gr));
                item.addChild(group);
            }
        }
        return item;
    }

    public String toString() {
        return this.getRosterItem().toString();
    }

    public RosterAbstract.SubscriptionType getSubscription() {
        return this.subscription;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isOnline() {
        return this.onlineMap.size() > 0;
    }

    public boolean isPresence_sent() {
        return this.presence_sent;
    }

    public final void setGroups(String[] groups) {
        if (groups != null && groups.length > 0) {
            this.groups = new String[groups.length];
            for (int i = 0; i < groups.length; ++i) {
                this.groups[i] = XMLUtils.unescape(groups[i]);
            }
            this.modified = true;
        }
    }

    public final void setName(String name) {
        String old_name = this.name;
        if (name == null) {
            this.name = this.jid.getLocalpart();
            if (this.name == null || this.name.trim().isEmpty()) {
                this.name = this.jid.getBareJID().toString();
            }
        } else {
            this.name = XMLUtils.unescape(name);
        }
        if (!this.name.equals(old_name)) {
            this.modified = true;
        }
    }

    public void setOnline(String resource, boolean online) {
        if (this.onlineMap != null && resource != null) {
            if (online) {
                this.onlineMap.put(resource, Boolean.TRUE);
            } else {
                this.onlineMap.remove(resource);
            }
        }
    }

    public void setOtherData(String other_data) {
        this.otherData = other_data;
    }

    public void setPresence_sent(boolean presence_sent) {
        this.presence_sent = presence_sent;
    }

    public void setSubscription(RosterAbstract.SubscriptionType subscription) {
        this.subscription = subscription == null ? RosterAbstract.SubscriptionType.none : subscription;
        this.modified = true;
    }

    private void setJid(JID jid) {
        this.jid = jid;
        this.modified = true;
    }

    private void setJid(String jid) throws TigaseStringprepException {
        if (XMPPStringPrepFactory.STRINGPREP_PROCESSOR.equals(this.stringpreped)) {
            this.jid = JID.jidInstanceNS(jid);
        } else {
            this.jid = JID.jidInstance(jid);
            this.modified = true;
        }
        this.stringpreped = XMPPStringPrepFactory.STRINGPREP_PROCESSOR;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public double getActivity() {
        return this.activity;
    }

    public void setActivity(double activity) {
        this.activity = activity;
        if (activity != 0.0) {
            this.weight = 1.0 / activity;
        }
        this.modified = true;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
        this.modified = true;
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    public void setLastSeen(long lastSeen) {
        this.lastSeen = lastSeen;
        this.modified = true;
    }
}

