/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.osgi.ModulesManagerImpl;
import tigase.server.ConnectionManager;
import tigase.server.xmppclient.StreamManagementIOProcessor;
import tigase.server.xmppclient.XMPPIOProcessor;

public class XMPPIOProcessorsFactory {
    private static final Logger log = Logger.getLogger(XMPPIOProcessorsFactory.class.getCanonicalName());
    private static final String IO_PROCESSORS_PROP_KEY = "processors";
    private static final Map<String, String> DEF_PROCESSORS = new HashMap<String, String>();

    public static XMPPIOProcessor[] updateIOProcessors(ConnectionManager connectionManager, XMPPIOProcessor[] activeProcessors, Map<String, Object> props) {
        if (props.containsKey(IO_PROCESSORS_PROP_KEY)) {
            String[] processorsArr = (String[])props.get(IO_PROCESSORS_PROP_KEY);
            ArrayList<XMPPIOProcessor> processors = new ArrayList<XMPPIOProcessor>();
            if (processorsArr != null) {
                for (String procStr : processorsArr) {
                    String procClass;
                    String[] procStrArr = procStr.split("=");
                    String procId = procStrArr[0];
                    XMPPIOProcessor proc = XMPPIOProcessorsFactory.findProcessor(activeProcessors, procId, procClass = procStrArr.length > 1 ? procStrArr[1] : DEF_PROCESSORS.get(procId));
                    if (proc == null) continue;
                    proc.setConnectionManager(connectionManager);
                    Map<String, Object> procSettings = XMPPIOProcessorsFactory.getProcSettings(props, procId);
                    proc.setProperties(procSettings);
                    processors.add(proc);
                }
            }
            return processors.toArray(new XMPPIOProcessor[processors.size()]);
        }
        return activeProcessors;
    }

    public static Map<String, Object> getProcSettings(Map<String, Object> props, String procId) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        String keyPrefix = "processors/" + procId + "/";
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            String key;
            if (!entry.getKey().startsWith(keyPrefix) || (key = entry.getKey().replace(keyPrefix, "")) == null || key.isEmpty()) continue;
            results.put(key, entry.getValue());
        }
        return results;
    }

    public static XMPPIOProcessor findProcessor(XMPPIOProcessor[] activeProcessors, String procId, String procClassName) {
        Class<?> procCls = null;
        try {
            procCls = ModulesManagerImpl.getInstance().forName(procClassName);
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        for (XMPPIOProcessor proc : activeProcessors) {
            if (!procId.equals(proc.getId()) || !proc.getClass().equals(procCls)) continue;
            return proc;
        }
        try {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "looking for XMPP processors of id = {0} of class {1} and found {2}", new Object[]{procId, procClassName, procCls != null ? procCls.toString() : "null"});
            }
            return (XMPPIOProcessor)procCls.newInstance();
        }
        catch (Exception ex) {
            return null;
        }
    }

    static {
        DEF_PROCESSORS.put("urn:xmpp:sm:3", StreamManagementIOProcessor.class.getCanonicalName());
    }
}

