/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Message;
import tigase.server.Permissions;
import tigase.server.Presence;
import tigase.server.Priority;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class Packet {
    public static final String CLIENT_XMLNS = "jabber:client";
    public static final String FROM_ATT = "from";
    public static final String ID_ATT = "id";
    public static final String PERM_ATT = "perm";
    public static final String PRIORITY_ATT = "pr";
    public static final String TO_ATT = "to";
    public static final String TYPE_ATT = "type";
    public static final String XMLNS_ATT = "xmlns";
    private static final String ERROR_NS = "urn:ietf:params:xml:ns:xmpp-stanzas";
    public static boolean FULL_DEBUG = Boolean.getBoolean("packet.debug.full");
    protected Element elem;
    private JID packetFrom = null;
    private JID packetTo = null;
    private String packetToString = null;
    private String packetToStringSecure = null;
    private Set<String> processorsIds = new LinkedHashSet<String>(4, 0.9f);
    private JID stanzaFrom = null;
    private String stanzaId = null;
    private JID stanzaTo = null;
    private Priority priority = Priority.NORMAL;
    private Permissions permissions = Permissions.NONE;
    private boolean routed;
    private StanzaType type;

    protected Packet(Element elem) throws TigaseStringprepException {
        this.setElem(elem);
        this.initVars();
    }

    protected Packet(Element elem, JID stanzaFrom, JID stanzaTo) {
        this.setElem(elem);
        this.initVars(stanzaFrom, stanzaTo);
    }

    public static String elemToString(Element el) {
        String elemData = el.toString();
        int size = elemData.length();
        if (size > 1024) {
            elemData = elemData.substring(0, 1024) + " ... ";
        }
        return elemData;
    }

    public static String elemToStringSecure(Element el) {
        String elemData = el.toStringSecure();
        int size = elemData.length();
        if (size > 1024) {
            elemData = elemData.substring(0, 1024) + " ... ";
        }
        return elemData;
    }

    public static Packet packetInstance(Element elem) throws TigaseStringprepException {
        Packet result = null;
        if (elem.getName() == "message") {
            result = new Message(elem);
        }
        if (elem.getName() == "presence") {
            result = new Presence(elem);
        }
        if (elem.getName() == "iq") {
            result = new Iq(elem);
        }
        if (result == null) {
            result = new Packet(elem);
        }
        return result;
    }

    public static Packet packetInstance(Element elem, JID stanzaFrom, JID stanzaTo) {
        Packet result = null;
        if (elem.getName() == "message") {
            result = new Message(elem, stanzaFrom, stanzaTo);
        }
        if (elem.getName() == "presence") {
            result = new Presence(elem, stanzaFrom, stanzaTo);
        }
        if (elem.getName() == "iq") {
            result = new Iq(elem, stanzaFrom, stanzaTo);
        }
        if (result == null) {
            result = new Packet(elem, stanzaFrom, stanzaTo);
        }
        return result;
    }

    public static Packet packetInstance(String el_name, String from, String to, StanzaType type) throws TigaseStringprepException {
        Element elem = new Element(el_name, new String[]{FROM_ATT, TO_ATT, TYPE_ATT}, new String[]{from, to, type.toString()});
        return Packet.packetInstance(elem);
    }

    public Packet copyElementOnly() {
        Element res_elem = this.elem.clone();
        Packet result = Packet.packetInstance(res_elem, this.getStanzaFrom(), this.getStanzaTo());
        result.setPriority(this.priority);
        return result;
    }

    public String debug() {
        return this.toString() + ", stanzaFrom=" + this.stanzaFrom + ", stanzaTo=" + this.stanzaTo;
    }

    public Packet errorResult(String errorType, Integer errorCode, String errorCondition, String errorText, boolean includeOriginalXML) {
        Element reply = new Element(this.elem.getName());
        reply.setAttribute(TYPE_ATT, StanzaType.error.toString());
        if (this.getStanzaId() != null) {
            reply.setAttribute(ID_ATT, this.getStanzaId());
        }
        if (includeOriginalXML) {
            reply.addChildren(this.elem.getChildren());
        }
        if (this.getXMLNS() != null) {
            reply.setXMLNS(this.getXMLNS());
        }
        Element error = new Element("error");
        if (errorCode != null) {
            error.setAttribute("code", errorCode.toString());
        }
        error.setAttribute(TYPE_ATT, errorType);
        Element cond = new Element(errorCondition);
        cond.setXMLNS(ERROR_NS);
        error.addChild(cond);
        if (errorText != null) {
            Element t = new Element("text", errorText, new String[]{"xml:lang", XMLNS_ATT}, new String[]{"en", ERROR_NS});
            error.addChild(t);
        }
        reply.addChild(error);
        return this.swapFromTo(reply, this.getStanzaTo(), this.getStanzaFrom());
    }

    @Deprecated
    public String getAttribute(String key) {
        return this.elem.getAttribute(key);
    }

    public String getAttributeStaticStr(String key) {
        return this.elem.getAttributeStaticStr(key);
    }

    public String getAttributeStaticStr(String[] path, String key) {
        return this.elem.getAttributeStaticStr(path, key);
    }

    @Deprecated
    public String getAttribute(String[] path, String key) {
        return this.elem.getAttribute(path, key);
    }

    @Deprecated
    public String getAttribute(String path, String key) {
        return this.elem.getAttribute(path, key);
    }

    public Command getCommand() {
        return null;
    }

    public String getElemCDataStaticStr(String[] xmlPath) {
        return this.elem.getCDataStaticStr(xmlPath);
    }

    @Deprecated
    public String getElemCData(String[] xmlPath) {
        return this.elem.getCData(xmlPath);
    }

    @Deprecated
    public String getElemCData(String xmlPath) {
        return this.elem.getCData(xmlPath);
    }

    public String getElemCData() {
        return this.elem.getCData();
    }

    public List<Element> getElemChildrenStaticStr(String[] xmlPath) {
        return this.elem.getChildrenStaticStr(xmlPath);
    }

    @Deprecated
    public List<Element> getElemChildren(String[] xmlPath) {
        return this.elem.getChildren(xmlPath);
    }

    @Deprecated
    public List<Element> getElemChildren(String xmlPath) {
        return this.elem.getChildren(xmlPath);
    }

    @Deprecated
    public String getElemFrom() {
        return this.stanzaFrom != null ? this.stanzaFrom.toString() : null;
    }

    public String getElemName() {
        return this.elem.getName();
    }

    @Deprecated
    public String getElemTo() {
        return this.stanzaTo != null ? this.stanzaTo.toString() : null;
    }

    public Element getElement() {
        return this.elem;
    }

    public String getErrorCondition() {
        List<Element> children = this.elem.getChildrenStaticStr(this.getElNameErrorPath());
        if (children != null) {
            for (Element cond : children) {
                if (cond.getName().equals("text")) continue;
                return cond.getName();
            }
        }
        return null;
    }

    protected String[] getElNameErrorPath() {
        return new String[]{this.elem.getName(), "error"};
    }

    public JID getFrom() {
        return this.packetFrom != null ? this.packetFrom : this.stanzaFrom;
    }

    public JID getPacketFrom() {
        return this.packetFrom;
    }

    public JID getPacketTo() {
        return this.packetTo;
    }

    public Permissions getPermissions() {
        return this.permissions;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public Set<String> getProcessorsIds() {
        return this.processorsIds;
    }

    public JID getStanzaFrom() {
        return this.stanzaFrom;
    }

    public String getStanzaId() {
        return this.stanzaId;
    }

    public JID getStanzaTo() {
        return this.stanzaTo;
    }

    public JID getTo() {
        return this.packetTo != null ? this.packetTo : this.stanzaTo;
    }

    public StanzaType getType() {
        return this.type;
    }

    public String getXMLNS() {
        return this.elem.getXMLNS();
    }

    public void initVars(JID stanzaFrom, JID stanzaTo) {
        if (this.stanzaFrom != stanzaFrom) {
            this.stanzaFrom = stanzaFrom;
            if (stanzaFrom == null) {
                this.elem.removeAttribute(FROM_ATT);
            } else {
                this.elem.setAttribute(FROM_ATT, stanzaFrom.toString());
            }
        }
        if (this.stanzaTo != stanzaTo) {
            this.stanzaTo = stanzaTo;
            if (stanzaTo == null) {
                this.elem.removeAttribute(TO_ATT);
            } else {
                this.elem.setAttribute(TO_ATT, stanzaTo.toString());
            }
        }
        this.stanzaId = this.elem.getAttributeStaticStr(ID_ATT);
        this.packetToString = null;
        this.packetToStringSecure = null;
    }

    public void initVars() throws TigaseStringprepException {
        String tmp = this.elem.getAttributeStaticStr(TO_ATT);
        this.stanzaTo = tmp != null ? JID.jidInstance(tmp) : null;
        tmp = this.elem.getAttributeStaticStr(FROM_ATT);
        this.stanzaFrom = tmp != null ? JID.jidInstance(tmp) : null;
        this.stanzaId = this.elem.getAttributeStaticStr(ID_ATT);
        this.packetToString = null;
        this.packetToStringSecure = null;
        tmp = this.elem.getAttributeStaticStr(PRIORITY_ATT);
        if (tmp != null) {
            this.priority = Priority.valueOf(tmp);
        }
        if ((tmp = this.elem.getAttributeStaticStr(PERM_ATT)) != null) {
            this.permissions = Permissions.valueOf(tmp);
        }
    }

    public boolean isCommand() {
        return false;
    }

    public boolean isElement(String name, String xmlns) {
        return this.elem.getName() == name && xmlns == this.elem.getXMLNS();
    }

    public boolean isRouted() {
        return this.routed;
    }

    public boolean isServiceDisco() {
        return false;
    }

    public boolean isXMLNSStaticStr(String[] elementPath, String xmlns) {
        String this_xmlns = this.elem.getXMLNSStaticStr(elementPath);
        return this_xmlns == xmlns;
    }

    @Deprecated
    public boolean isXMLNS(String[] elementPath, String xmlns) {
        String this_xmlns = this.elem.getXMLNS(elementPath);
        return this_xmlns == xmlns;
    }

    @Deprecated
    public boolean isXMLNS(String elementPath, String xmlns) {
        String this_xmlns = this.elem.getXMLNS(elementPath);
        return this_xmlns == xmlns;
    }

    public void setXMLNS(String xmlns) {
        this.elem.setXMLNS(xmlns);
        this.packetToString = null;
        this.packetToStringSecure = null;
    }

    public Packet okResult(String includeXML, int originalXML) {
        List<Element> old_children;
        Element reply = new Element(this.elem.getName());
        if (this.getXMLNS() != null) {
            reply.setXMLNS(this.getXMLNS());
        }
        reply.setAttribute(TYPE_ATT, StanzaType.result.toString());
        if (this.getStanzaId() != null) {
            reply.setAttribute(ID_ATT, this.getStanzaId());
        }
        Element old_child = this.elem;
        Element new_child = reply;
        for (int i = 0; i < originalXML && (old_children = old_child.getChildren()) != null && old_children.size() > 0; ++i) {
            old_child = old_children.get(0);
            Element tmp = new Element(old_child.getName());
            tmp.setAttributes(old_child.getAttributes());
            new_child.addChild(tmp);
            new_child = tmp;
        }
        if (includeXML != null) {
            new_child.setCData(includeXML);
        }
        Packet result = this.swapFromTo(reply, this.getStanzaTo(), this.getStanzaFrom());
        result.setPriority(this.priority);
        return result;
    }

    public Packet okResult(Element includeXML, int originalXML) {
        List<Element> old_children;
        Element reply = new Element(this.elem.getName());
        if (this.getXMLNS() != null) {
            reply.setXMLNS(this.getXMLNS());
        }
        reply.setAttribute(TYPE_ATT, StanzaType.result.toString());
        if (this.getStanzaId() != null) {
            reply.setAttribute(ID_ATT, this.getStanzaId());
        }
        Element old_child = this.elem;
        Element new_child = reply;
        for (int i = 0; i < originalXML && (old_children = old_child.getChildren()) != null && old_children.size() > 0; ++i) {
            old_child = old_children.get(0);
            Element tmp = new Element(old_child.getName());
            tmp.setAttributes(old_child.getAttributes());
            new_child.addChild(tmp);
            new_child = tmp;
        }
        if (includeXML != null) {
            new_child.addChild(includeXML);
        }
        Packet result = this.swapFromTo(reply, this.getStanzaTo(), this.getStanzaFrom());
        result.setPriority(this.priority);
        return result;
    }

    public Packet packRouted() {
        Element routedp = new Element("route", new String[]{TO_ATT, FROM_ATT, PRIORITY_ATT, PERM_ATT}, new String[]{this.getTo().toString(), this.getFrom().toString(), this.priority.toString(), this.permissions.toString()});
        routedp.addChild(this.elem);
        return Packet.packetInstance(routedp, this.getFrom(), this.getTo());
    }

    public void processedBy(String id) {
        this.processorsIds.add(id);
    }

    public void setPacketFrom(JID from) {
        this.packetFrom = from;
    }

    public void setPacketTo(JID to) {
        this.packetTo = to;
    }

    public void setPermissions(Permissions perm) {
        this.packetToString = null;
        this.packetToStringSecure = null;
        this.permissions = perm;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    @Deprecated
    public Packet swapElemFromTo() {
        return this.swapStanzaFromTo();
    }

    @Deprecated
    public Packet swapElemFromTo(StanzaType type) {
        return this.swapStanzaFromTo(type);
    }

    public Packet swapFromTo(Element el, JID stanzaFrom, JID stanzaTo) {
        Packet packet = Packet.packetInstance(el, stanzaFrom, stanzaTo);
        packet.setPacketTo(this.getFrom());
        packet.setPacketFrom(this.getTo());
        packet.setPriority(this.priority);
        return packet;
    }

    public Packet swapFromTo() {
        Element el = this.elem.clone();
        Packet packet = Packet.packetInstance(el, this.getStanzaFrom(), this.getStanzaTo());
        packet.setPacketTo(this.getFrom());
        packet.setPacketFrom(this.getTo());
        packet.setPriority(this.priority);
        return packet;
    }

    public Packet swapStanzaFromTo() {
        Element copy = this.elem.clone();
        Packet result = Packet.packetInstance(copy, this.getStanzaTo(), this.getStanzaFrom());
        result.setPriority(this.priority);
        return result;
    }

    public Packet swapStanzaFromTo(StanzaType type) {
        Element copy = this.elem.clone();
        copy.setAttribute(TYPE_ATT, type.toString());
        Packet result = Packet.packetInstance(copy, this.getStanzaTo(), this.getStanzaFrom());
        result.setPriority(this.priority);
        return result;
    }

    public String toStringFull() {
        if (this.packetToString == null) {
            String elemData = Packet.elemToString(this.elem);
            this.packetToString = this.calcToString(elemData);
        }
        return "from=" + this.packetFrom + ", to=" + this.packetTo + this.packetToString;
    }

    public String toString() {
        return this.toString(FULL_DEBUG);
    }

    public String toString(boolean secure) {
        String result = secure ? this.toStringSecure() : this.toStringFull();
        return result;
    }

    public String toStringSecure() {
        if (FULL_DEBUG) {
            return this.toStringFull();
        }
        if (this.packetToStringSecure == null) {
            String elemData = Packet.elemToStringSecure(this.elem);
            this.packetToStringSecure = this.calcToString(elemData);
        }
        return "from=" + this.packetFrom + ", to=" + this.packetTo + this.packetToStringSecure;
    }

    public Packet unpackRouted() throws TigaseStringprepException {
        Packet result = Packet.packetInstance(this.elem.getChildren().get(0));
        result.setPacketTo(this.getTo());
        result.setPacketFrom(this.getFrom());
        result.setPriority(this.priority);
        result.setPermissions(this.permissions);
        return result;
    }

    public boolean wasProcessed() {
        return this.processorsIds.size() > 0;
    }

    public boolean wasProcessedBy(String id) {
        return this.processorsIds.contains(id);
    }

    private String calcToString(String elemData) {
        return ", DATA=" + elemData + ", SIZE=" + this.elem.toString().length() + ", XMLNS=" + this.elem.getXMLNS() + ", PRIORITY=" + (Object)((Object)this.priority) + ", PERMISSION=" + (Object)((Object)this.permissions) + ", TYPE=" + (Object)((Object)this.type);
    }

    private void setElem(Element elem) {
        if (elem == null) {
            throw new NullPointerException();
        }
        this.elem = elem;
        this.type = elem.getAttributeStaticStr(TYPE_ATT) != null ? StanzaType.valueof(elem.getAttributeStaticStr(TYPE_ATT)) : null;
        if (elem.getName() == "cluster") {
            this.setPriority(Priority.CLUSTER);
        } else if (elem.getName() == "presence" && (this.type == null || this.type == StanzaType.available || this.type == StanzaType.unavailable || this.type == StanzaType.probe)) {
            this.setPriority(Priority.PRESENCE);
        } else {
            this.routed = elem.getName() == "route";
        }
    }
}

