/*
 * Decompiled with CFR 0.152.
 */
package tigase.osgi;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.conf.Configurable;
import tigase.conf.Configurator;
import tigase.osgi.ModulesManager;
import tigase.server.ServerComponent;
import tigase.server.XMPPServer;
import tigase.util.ClassUtil;
import tigase.xmpp.XMPPImplIfc;

public class ModulesManagerImpl
implements ModulesManager {
    private static final Logger log = Logger.getLogger(ModulesManagerImpl.class.getCanonicalName());
    private static ModulesManagerImpl instance = null;
    private Map<String, XMPPImplIfc> plugins = new ConcurrentHashMap<String, XMPPImplIfc>();
    private Map<String, Class<? extends Configurable>> componentsClasses = new ConcurrentHashMap<String, Class<? extends Configurable>>();
    private ConcurrentHashMap<String, Class<?>> classes = new ConcurrentHashMap();
    private boolean active = false;

    public static ModulesManagerImpl getInstance() {
        if (instance == null) {
            instance = new ModulesManagerImpl();
        }
        return instance;
    }

    private ModulesManagerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerPluginClass(Class<? extends XMPPImplIfc> pluginCls) {
        ModulesManagerImpl modulesManagerImpl = this;
        synchronized (modulesManagerImpl) {
            try {
                XMPPImplIfc plugin = pluginCls.newInstance();
                this.plugins.put(plugin.id(), plugin);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(ModulesManagerImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(ModulesManagerImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterPluginClass(Class<? extends XMPPImplIfc> pluginClass) {
        ModulesManagerImpl modulesManagerImpl = this;
        synchronized (modulesManagerImpl) {
            String key = null;
            for (Map.Entry<String, XMPPImplIfc> entry : this.plugins.entrySet()) {
                if (!pluginClass.equals(entry.getValue())) continue;
                key = entry.getKey();
            }
            if (key != null) {
                this.plugins.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerServerComponentClass(Class<? extends Configurable> compCls) {
        ModulesManagerImpl modulesManagerImpl = this;
        synchronized (modulesManagerImpl) {
            this.componentsClasses.put(compCls.getCanonicalName(), compCls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterServerComponentClass(Class<? extends Configurable> compCls) {
        ModulesManagerImpl modulesManagerImpl = this;
        synchronized (modulesManagerImpl) {
            this.componentsClasses.remove(compCls.getCanonicalName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerClass(Class<?> cls) {
        ModulesManagerImpl modulesManagerImpl = this;
        synchronized (modulesManagerImpl) {
            String clsName = cls.getCanonicalName();
            this.classes.put(clsName, cls);
            if (XMPPImplIfc.class.isAssignableFrom(cls)) {
                this.registerPluginClass(cls);
            }
            if (Configurable.class.isAssignableFrom(cls)) {
                this.registerServerComponentClass(cls);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterClass(Class<?> cls) {
        ModulesManagerImpl modulesManagerImpl = this;
        synchronized (modulesManagerImpl) {
            String clsName = cls.getCanonicalName();
            this.classes.remove(clsName, cls);
            if (XMPPImplIfc.class.isAssignableFrom(cls)) {
                this.unregisterPluginClass(cls);
            }
            if (Configurable.class.isAssignableFrom(cls)) {
                this.unregisterServerComponentClass(cls);
            }
        }
    }

    @Override
    public Class<?> forName(String className) throws ClassNotFoundException {
        Class<?> cls;
        if ("tigase.cluster.strategy.OnlineUsersCachingStrategy".equals(className)) {
            log.warning("You are using old name for SM clustering strategy in property --sm-cluster-strategy-class\nYou are using name: " + className + "\n" + " while name: tigase.server.cluster.strategy.OnlineUsersCachingStrategy" + " should be used.");
            className = "tigase.server.cluster.strategy.OnlineUsersCachingStrategy";
        }
        if ((cls = this.classes.get(className)) == null) {
            cls = this.getClass().getClassLoader().loadClass(className);
        }
        return cls;
    }

    public <T extends Class> Set<T> getImplementations(T cls) {
        return ClassUtil.getClassesImplementing(this.classes.values(), cls);
    }

    @Override
    public void update() {
        Configurator configurator;
        if (this.active && (configurator = (Configurator)XMPPServer.getConfigurator()) != null) {
            configurator.updateMessageRouter();
        }
    }

    public XMPPImplIfc getPlugin(String plug_id) throws InstantiationException, IllegalAccessException {
        return this.plugins.get(plug_id);
    }

    public boolean hasPluginForId(String plug_id) {
        return this.plugins.containsKey(plug_id);
    }

    public Class<? extends ServerComponent> getServerComponentClass(String className) {
        return this.componentsClasses.get(className);
    }

    public ServerComponent getServerComponent(String className) throws InstantiationException, IllegalAccessException {
        Class<? extends Configurable> compCls = this.componentsClasses.get(className);
        if (compCls == null) {
            return null;
        }
        return compCls.newInstance();
    }

    public boolean hasClassForServerComponent(String className) {
        return this.componentsClasses.containsKey(className);
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

