/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor;

import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptEngineManager;
import tigase.component.AbstractComponent;
import tigase.component.AbstractContext;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.modules.Module;
import tigase.component.modules.impl.JabberVersionModule;
import tigase.component.modules.impl.XmppPingModule;
import tigase.conf.ConfigurationException;
import tigase.kernel.Kernel;
import tigase.monitor.MonitorContext;
import tigase.monitor.TasksScriptRegistrar;
import tigase.monitor.TimerTaskService;
import tigase.monitor.modules.AdHocCommandMonitorModule;
import tigase.monitor.modules.AddScriptTaskCommand;
import tigase.monitor.modules.AddTimerScriptTaskCommand;
import tigase.monitor.modules.DeleteScriptTaskCommand;
import tigase.monitor.modules.DiscoveryMonitorModule;
import tigase.server.monitor.MonitorRuntime;
import tigase.util.TimerTask;

public class MonitorComponent
extends AbstractComponent<MonitorContext> {
    private Kernel kernel = new Kernel();
    private final TimerTaskService timerTaskService = new TimerTaskService(){

        @Override
        public void addTimerTask(TimerTask task, long delay) {
            MonitorComponent.this.addTimerTask(task, delay);
        }

        @Override
        public void addTimerTask(TimerTask task, long initialDelay, long period) {
            MonitorComponent.this.addTimerTask(task, initialDelay, period);
        }
    };

    @Override
    protected MonitorContext createContext() {
        return new MonitorContextImpl(this);
    }

    @Override
    public String getComponentVersion() {
        String version = this.getClass().getPackage().getImplementationVersion();
        return version == null ? "0.0.0" : version;
    }

    @Override
    protected Map<String, Class<? extends Module>> getDefaultModulesList() {
        HashMap<String, Class<? extends Module>> result = new HashMap<String, Class<? extends Module>>();
        result.put("urn:xmpp:ping", XmppPingModule.class);
        result.put("jabber:iq:version", JabberVersionModule.class);
        result.put("commands", AdHocCommandMonitorModule.class);
        result.put("disco", DiscoveryMonitorModule.class);
        return result;
    }

    @Override
    public String getDiscoCategory() {
        return "component";
    }

    @Override
    public String getDiscoCategoryType() {
        return "monitor";
    }

    @Override
    public String getDiscoDescription() {
        return "Monitor Component";
    }

    @Override
    public boolean isDiscoNonAdmin() {
        return true;
    }

    @Override
    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        super.setProperties(props);
        this.kernel.registerBeanClass("TasksScriptRegistrar", TasksScriptRegistrar.class);
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        this.kernel.registerBean("scriptEngineManager", scriptEngineManager);
        this.kernel.registerBean("bindings", scriptEngineManager.getBindings());
        this.kernel.registerBean("context", this.getContext());
        this.kernel.registerBean("monitorComponent", this);
        this.kernel.registerBean("timerTaskService", this.timerTaskService);
        this.kernel.registerBean("runtime", MonitorRuntime.getMonitorRuntime());
        this.kernel.registerBean("kernel", this.kernel);
        AdHocCommand ahc = new AddScriptTaskCommand((MonitorContext)this.context);
        ((AdHocCommandMonitorModule)this.getModuleProvider().getModule("commands")).register(ahc);
        this.kernel.registerBean(ahc.getName(), ahc);
        ahc = new AddTimerScriptTaskCommand((MonitorContext)this.context);
        ((AdHocCommandMonitorModule)this.getModuleProvider().getModule("commands")).register(ahc);
        this.kernel.registerBean(ahc.getName(), ahc);
        ahc = new DeleteScriptTaskCommand((MonitorContext)this.context);
        ((AdHocCommandMonitorModule)this.getModuleProvider().getModule("commands")).register(ahc);
        this.kernel.registerBean(ahc.getName(), ahc);
        ((TasksScriptRegistrar)this.kernel.getInstance("TasksScriptRegistrar")).load();
    }

    private class MonitorContextImpl
    extends AbstractContext
    implements MonitorContext {
        public MonitorContextImpl(AbstractComponent<?> component) {
            super(component);
        }

        @Override
        public Kernel getKernel() {
            return MonitorComponent.this.kernel;
        }
    }
}

