/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.cached;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.Subscription;
import tigase.pubsub.Utils;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.NodeAffiliations;
import tigase.pubsub.repository.NodeSubscriptions;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.cached.Items;
import tigase.pubsub.repository.cached.Node;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.stats.StatisticsList;
import tigase.xmpp.BareJID;
import tigase.xmpp.impl.roster.RosterElement;

public class CachedPubSubRepository<T>
implements IPubSubRepository {
    public static final long MAX_WRITE_DELAY = 15000L;
    protected final IPubSubDAO<T> dao;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private final Integer maxCacheSize;
    protected final Map<String, Node> nodes;
    private long nodes_added = 0L;
    private final ConcurrentSkipListSet<Node> nodesToSave = new ConcurrentSkipListSet<Node>(new NodeComparator());
    private long repo_writes = 0L;
    private final ConcurrentHashMap<BareJID, Set<String>> rootCollection = new ConcurrentHashMap();
    private NodeSaver nodeSaver;
    private long updateSubscriptionsCalled = 0L;
    private long writingTime = 0L;

    public CachedPubSubRepository(PubSubDAO dao, Integer maxCacheSize) {
        this.dao = dao;
        this.maxCacheSize = maxCacheSize;
        this.nodes = Collections.synchronizedMap(new SizedCache(this.maxCacheSize));
        this.log.config("Initializing Cached Repository with cache size = " + (maxCacheSize == null ? "OFF" : maxCacheSize));
        this.nodeSaver = new NodeSaver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStats(String name, StatisticsList stats) {
        if (this.nodes.size() > 0) {
            stats.add(name, "Cached nodes", this.nodes.size(), Level.FINE);
        } else {
            stats.add(name, "Cached nodes", this.nodes.size(), Level.FINEST);
        }
        if (this.nodesToSave.size() > 0) {
            stats.add(name, "Unsaved nodes", this.nodesToSave.size(), Level.INFO);
        } else {
            stats.add(name, "Unsaved nodes", this.nodesToSave.size(), Level.FINEST);
        }
        long subscriptionsCount = 0L;
        long affiliationsCount = 0L;
        LinkedHashMap<String, Node> tmp = null;
        Map<String, Node> map = this.nodes;
        synchronized (map) {
            tmp = new LinkedHashMap<String, Node>(this.nodes);
        }
        for (Node nd : tmp.values()) {
            subscriptionsCount += (long)nd.getNodeSubscriptions().getSubscriptionsMap().size();
            affiliationsCount += (long)nd.getNodeAffiliations().getAffiliationsMap().size();
        }
        if (this.updateSubscriptionsCalled > 0L) {
            stats.add(name, "Update subscriptions calls", this.updateSubscriptionsCalled, Level.FINE);
        } else {
            stats.add(name, "Update subscriptions calls", this.updateSubscriptionsCalled, Level.FINEST);
        }
        if (subscriptionsCount > 0L) {
            stats.add(name, "Subscriptions count (in cache)", subscriptionsCount, Level.FINE);
        } else {
            stats.add(name, "Subscriptions count (in cache)", subscriptionsCount, Level.FINEST);
        }
        if (affiliationsCount > 0L) {
            stats.add(name, "Affiliations count (in cache)", affiliationsCount, Level.FINE);
        } else {
            stats.add(name, "Affiliations count (in cache)", affiliationsCount, Level.FINEST);
        }
        if (this.repo_writes > 0L) {
            stats.add(name, "Repository writes", this.repo_writes, Level.FINE);
        } else {
            stats.add(name, "Repository writes", this.repo_writes, Level.FINEST);
        }
        if (this.nodes_added > 0L) {
            stats.add(name, "Added new nodes", this.nodes_added, Level.INFO);
        } else {
            stats.add(name, "Added new nodes", this.nodes_added, Level.FINEST);
        }
        if (this.nodes_added > 0L) {
            stats.add(name, "Total writing time", Utils.longToTime(this.writingTime), Level.INFO);
        } else {
            stats.add(name, "Total writing time", Utils.longToTime(this.writingTime), Level.FINEST);
        }
        if (this.nodes_added + this.repo_writes > 0L) {
            if (this.nodes_added > 0L) {
                stats.add(name, "Average DB write time [ms]", this.writingTime / (this.nodes_added + this.repo_writes), Level.INFO);
            } else {
                stats.add(name, "Average DB write time [ms]", this.writingTime / (this.nodes_added + this.repo_writes), Level.FINEST);
            }
        }
    }

    @Override
    public void addToRootCollection(BareJID serviceJid, String nodeName) throws RepositoryException {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "Addint to root collection, serviceJid: {0}, nodeName: {1}", new Object[]{serviceJid, nodeName});
        }
        this.dao.addToRootCollection(serviceJid, nodeName);
        this.getRootCollectionSet(serviceJid).add(nodeName);
    }

    protected String createKey(BareJID serviceJid, String nodeName) {
        return serviceJid.toString() + "/" + nodeName;
    }

    @Override
    public void createNode(BareJID serviceJid, String nodeName, BareJID ownerJid, AbstractNodeConfig nodeConfig, NodeType nodeType, String collection) throws RepositoryException {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "Creating node, serviceJid: {0}, nodeName: {1}, ownerJid: {2}, nodeConfig: {3}, nodeType: {4}, collection: {5}", new Object[]{serviceJid, nodeName, ownerJid, nodeConfig, nodeType, collection});
        }
        long start = System.currentTimeMillis();
        Object collectionId = null;
        if (collection != null && !collection.equals("") && (collectionId = (Object)this.dao.getNodeId(serviceJid, collection)) == null) {
            throw new RepositoryException("Parent collection does not exists yet!");
        }
        Object nodeId = this.dao.createNode(serviceJid, nodeName, ownerJid, nodeConfig, nodeType, collectionId);
        tigase.pubsub.repository.cached.NodeAffiliations nodeAffiliations = NodeAffiliations.create((Queue<UsersAffiliation>)null);
        tigase.pubsub.repository.cached.NodeSubscriptions nodeSubscriptions = NodeSubscriptions.create();
        Node<Object> node = new Node<Object>(nodeId, serviceJid, nodeConfig, nodeAffiliations, nodeSubscriptions);
        String key = this.createKey(serviceJid, nodeName);
        this.nodes.put(key, node);
        long end = System.currentTimeMillis();
        ++this.nodes_added;
        this.writingTime += end - start;
    }

    protected tigase.pubsub.repository.cached.NodeSubscriptions wrapNodeSubscriptions(NodeSubscriptions nodeSubscriptions) {
        return new tigase.pubsub.repository.cached.NodeSubscriptions(nodeSubscriptions);
    }

    @Override
    public void deleteNode(BareJID serviceJid, String nodeName) throws RepositoryException {
        Object nodeId;
        String key = this.createKey(serviceJid, nodeName);
        Node node = this.nodes.get(key);
        Object t = nodeId = node != null ? node.getNodeId() : this.dao.getNodeId(serviceJid, nodeName);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "Getting node items, serviceJid: {0}, nodeName: {1}, key: {2}, node: {3}, nodeId: {4}", new Object[]{serviceJid, nodeName, key, node, nodeId});
        }
        this.dao.deleteNode(serviceJid, nodeId);
        if (node != null) {
            node.setDeleted(true);
        }
        this.nodes.remove(key);
    }

    @Override
    public void destroy() {
    }

    @Override
    public void forgetConfiguration(BareJID serviceJid, String nodeName) throws RepositoryException {
        String key = this.createKey(serviceJid, nodeName);
        this.nodes.remove(key);
    }

    public Collection<Node> getAllNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    @Override
    public String[] getBuddyGroups(BareJID owner, BareJID bareJid) throws RepositoryException {
        return this.dao.getBuddyGroups(owner, bareJid);
    }

    @Override
    public String getBuddySubscription(BareJID owner, BareJID buddy) throws RepositoryException {
        return this.dao.getBuddySubscription(owner, buddy);
    }

    protected Node getNode(BareJID serviceJid, String nodeName) throws RepositoryException {
        String key = this.createKey(serviceJid, nodeName);
        Node<T> node = this.nodes.get(key);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "Getting node, serviceJid: {0}, nodeName: {1}, key: {2}, node: {3}", new Object[]{serviceJid, nodeName, key, node});
        }
        if (node == null) {
            T nodeId = this.dao.getNodeId(serviceJid, nodeName);
            if (nodeId == null) {
                return null;
            }
            String cfgData = this.dao.getNodeConfig(serviceJid, nodeId);
            AbstractNodeConfig nodeConfig = this.dao.parseConfig(nodeName, cfgData);
            if (nodeConfig == null) {
                return null;
            }
            tigase.pubsub.repository.cached.NodeAffiliations nodeAffiliations = new tigase.pubsub.repository.cached.NodeAffiliations(this.dao.getNodeAffiliations(serviceJid, nodeId));
            tigase.pubsub.repository.cached.NodeSubscriptions nodeSubscriptions = this.wrapNodeSubscriptions(this.dao.getNodeSubscriptions(serviceJid, nodeId));
            node = new Node<T>(nodeId, serviceJid, nodeConfig, nodeAffiliations, nodeSubscriptions);
            this.nodes.put(key, node);
        }
        return node;
    }

    @Override
    public IAffiliations getNodeAffiliations(BareJID serviceJid, String nodeName) throws RepositoryException {
        Node node = this.getNode(serviceJid, nodeName);
        return node == null ? null : node.getNodeAffiliations();
    }

    @Override
    public AbstractNodeConfig getNodeConfig(BareJID serviceJid, String nodeName) throws RepositoryException {
        Node node = this.getNode(serviceJid, nodeName);
        try {
            return node == null ? null : node.getNodeConfig().clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public IItems getNodeItems(BareJID serviceJid, String nodeName) throws RepositoryException {
        Object nodeId;
        String key = this.createKey(serviceJid, nodeName);
        Node node = this.nodes.get(key);
        Object t = nodeId = node != null ? node.getNodeId() : this.dao.getNodeId(serviceJid, nodeName);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "Getting node items, serviceJid: {0}, nodeName: {1}, key: {2}, node: {3}, nodeId: {4}", new Object[]{serviceJid, nodeName, key, node, nodeId});
        }
        return new Items(nodeId, serviceJid, nodeName, this.dao);
    }

    @Override
    public ISubscriptions getNodeSubscriptions(BareJID serviceJid, String nodeName) throws RepositoryException {
        Node node = this.getNode(serviceJid, nodeName);
        return node == null ? null : node.getNodeSubscriptions();
    }

    @Override
    public IPubSubDAO getPubSubDAO() {
        return this.dao;
    }

    @Override
    public String[] getRootCollection(BareJID serviceJid) throws RepositoryException {
        Set<String> rootCollection = this.getRootCollectionSet(serviceJid);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "Getting root collection, serviceJid: {0}", new Object[]{serviceJid});
        }
        if (rootCollection == null) {
            return null;
        }
        return rootCollection.toArray(new String[rootCollection.size()]);
    }

    protected Set<String> getRootCollectionSet(BareJID serviceJid) throws RepositoryException {
        Set<String> rootCollection = this.rootCollection.get(serviceJid);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "Getting root collection, serviceJid: {0}", new Object[]{serviceJid});
        }
        if (rootCollection == null || rootCollection.isEmpty()) {
            Set oldRootCollection;
            if (rootCollection == null && (oldRootCollection = this.rootCollection.putIfAbsent(serviceJid, Collections.synchronizedSet(new HashSet()))) != null) {
                rootCollection = oldRootCollection;
            }
            String[] x = this.dao.getChildNodes(serviceJid, null);
            if (rootCollection == null) {
                rootCollection = Collections.synchronizedSet(new HashSet());
            }
            if (x != null) {
                for (String string : x) {
                    rootCollection.add(string);
                }
            }
        }
        return rootCollection;
    }

    @Override
    public Map<BareJID, RosterElement> getUserRoster(BareJID owner) throws RepositoryException {
        return this.dao.getUserRoster(owner);
    }

    @Override
    public Map<String, UsersSubscription> getUserSubscriptions(BareJID serviceJid, BareJID userJid) throws RepositoryException {
        return this.dao.getUserSubscriptions(serviceJid, userJid);
    }

    @Override
    public void init() {
        this.log.config("Cached PubSubRepository initialising...");
    }

    @Override
    public void removeFromRootCollection(BareJID serviceJid, String nodeName) throws RepositoryException {
        Object nodeId;
        String key = this.createKey(serviceJid, nodeName);
        Node node = this.nodes.get(key);
        Object t = nodeId = node != null ? node.getNodeId() : this.dao.getNodeId(serviceJid, nodeName);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "Getting node items, serviceJid: {0}, nodeName: {1}, key: {2}, node: {3}, nodeId: {4}", new Object[]{serviceJid, nodeName, key, node, nodeId});
        }
        this.dao.removeFromRootCollection(serviceJid, nodeId);
        Set<String> nodes = this.rootCollection.get(serviceJid);
        if (nodes != null) {
            nodes.remove(nodeName);
        }
    }

    @Override
    public void update(BareJID serviceJid, String nodeName, AbstractNodeConfig nodeConfig) throws RepositoryException {
        Node node = this.getNode(serviceJid, nodeName);
        if (node != null) {
            node.configCopyFrom(nodeConfig);
            this.log.finest("Node '" + nodeName + "' added to lazy write queue (config)");
            this.nodeSaver.save(node);
        }
    }

    @Override
    public void update(BareJID serviceJid, String nodeName, IAffiliations nodeAffiliations) throws RepositoryException {
        if (nodeAffiliations instanceof tigase.pubsub.repository.cached.NodeAffiliations) {
            Node node = this.getNode(serviceJid, nodeName);
            if (node != null) {
                if (node.getNodeAffiliations() != nodeAffiliations) {
                    throw new RuntimeException("INCORRECT");
                }
                this.log.finest("Node '" + nodeName + "' added to lazy write queue (affiliations)");
                this.nodeSaver.save(node);
            }
        } else {
            throw new RuntimeException("Wrong class");
        }
    }

    @Override
    public void update(BareJID serviceJid, String nodeName, ISubscriptions nodeSubscriptions) throws RepositoryException {
        ++this.updateSubscriptionsCalled;
        Node node = this.getNode(serviceJid, nodeName);
        if (node != null) {
            this.log.finest("Node '" + nodeName + "' added to lazy write queue (subscriptions)");
            this.nodeSaver.save(node);
        }
    }

    private class SizedCache
    extends LinkedHashMap<String, Node> {
        private static final long serialVersionUID = 1L;
        private int maxCacheSize;

        public SizedCache(int maxSize) {
            super(maxSize, 0.1f, true);
            this.maxCacheSize = 1000;
            this.maxCacheSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Node> eldest) {
            return this.size() > this.maxCacheSize && !eldest.getValue().needsWriting();
        }
    }

    private class NodeComparator
    implements Comparator<Node> {
        private NodeComparator() {
        }

        @Override
        public int compare(Node o1, Node o2) {
            if (o1.getCreationTime() < o2.getCreationTime()) {
                return -1;
            }
            if (o1.getCreationTime() > o2.getCreationTime()) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    }

    private class NodeSaver {
        private NodeSaver() {
        }

        public void save(Node<T> node) throws RepositoryException {
            this.save(node, 0);
        }

        public void save(Node<T> node, int iteration) throws RepositoryException {
            long start = System.currentTimeMillis();
            ++CachedPubSubRepository.this.repo_writes;
            try {
                if (node.isDeleted()) {
                    return;
                }
                if (node.configNeedsWriting()) {
                    String collection = node.getNodeConfig().getCollection();
                    Object collectionId = null;
                    if (collection != null && !collection.equals("") && (collectionId = (Object)CachedPubSubRepository.this.dao.getNodeId(node.getServiceJid(), collection)) == null) {
                        throw new RepositoryException("Parent collection does not exists yet!");
                    }
                    CachedPubSubRepository.this.dao.updateNodeConfig(node.getServiceJid(), node.getNodeId(), node.getNodeConfig().getFormElement().toString(), collectionId);
                    node.configSaved();
                }
                if (node.affiliationsNeedsWriting()) {
                    Map<BareJID, UsersAffiliation> changedAffiliations = node.getNodeAffiliations().getChanged();
                    for (Map.Entry<BareJID, Cloneable> entry : changedAffiliations.entrySet()) {
                        CachedPubSubRepository.this.dao.updateNodeAffiliation(node.getServiceJid(), node.getNodeId(), node.getName(), (UsersAffiliation)entry.getValue());
                    }
                    node.affiliationsSaved();
                }
                if (node.subscriptionsNeedsWriting()) {
                    Map<BareJID, UsersSubscription> changedSubscriptions = node.getNodeSubscriptions().getChanged();
                    for (Map.Entry<BareJID, Cloneable> entry : changedSubscriptions.entrySet()) {
                        UsersSubscription subscription = (UsersSubscription)entry.getValue();
                        if (subscription.getSubscription() == Subscription.none) {
                            CachedPubSubRepository.this.dao.removeNodeSubscription(node.getServiceJid(), node.getNodeId(), subscription.getJid());
                            continue;
                        }
                        CachedPubSubRepository.this.dao.updateNodeSubscription(node.getServiceJid(), node.getNodeId(), node.getName(), subscription);
                    }
                    node.subscriptionsSaved();
                }
            }
            catch (Exception e) {
                CachedPubSubRepository.this.log.log(Level.WARNING, "Problem saving pubsub data: ", e);
                node.resetChanges();
                throw new RepositoryException("Problem saving pubsub data", e);
            }
            if (node.needsWriting()) {
                if (iteration >= 10) {
                    String msg = "Was not able to save data for node " + node.getName() + " on " + iteration + " iteration" + ", config saved = " + !node.configNeedsWriting() + ", affiliations saved = " + !node.affiliationsNeedsWriting() + ", subscriptions saved = " + !node.subscriptionsNeedsWriting();
                    CachedPubSubRepository.this.log.log(Level.WARNING, msg);
                    throw new RepositoryException("Problem saving pubsub data");
                }
                this.save(node, iteration++);
            }
            long end = System.currentTimeMillis();
            CachedPubSubRepository.this.writingTime += end - start;
        }
    }
}

