/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import tigase.component2.PacketWriter;
import tigase.component2.modules.ModulesManager;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.form.Field;
import tigase.form.Form;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.Utils;
import tigase.pubsub.exceptions.PubSubException;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;

public class DiscoverInfoModule
extends AbstractPubSubModule {
    private static final Criteria CRIT = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)ElementCriteria.name((String)"query", (String)"http://jabber.org/protocol/disco#info"));
    private final ModulesManager modulesManager;

    public DiscoverInfoModule(PubSubConfig config, PacketWriter packetWriter, ModulesManager modulesManager) {
        super(config, packetWriter);
        this.modulesManager = modulesManager;
    }

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public void process(Packet packet) throws PubSubException {
        try {
            Element element = packet.getElement();
            JID senderJid = packet.getStanzaFrom();
            Element query = element.getChild("query", "http://jabber.org/protocol/disco#info");
            String nodeName = query.getAttributeStaticStr("node");
            Element resultQuery = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/disco#info"});
            Packet resultIq = packet.okResult(resultQuery, 0);
            if (nodeName == null) {
                resultQuery.addChild((XMLNodeIfc)new Element("identity", new String[]{"category", "type", "name"}, new String[]{"pubsub", "service", "Publish-Subscribe"}));
                for (String f : this.modulesManager.getFeatures()) {
                    resultQuery.addChild((XMLNodeIfc)new Element("feature", new String[]{"var"}, new String[]{f}));
                }
            } else {
                boolean allowed;
                AbstractNodeConfig nodeConfig = this.getRepository().getNodeConfig(packet.getStanzaTo().getBareJID(), nodeName);
                if (nodeConfig == null) {
                    throw new PubSubException(Authorization.ITEM_NOT_FOUND);
                }
                boolean bl = allowed = senderJid == null || nodeConfig == null ? true : Utils.isAllowedDomain(senderJid.getBareJID(), nodeConfig.getDomains());
                if (!allowed) {
                    throw new PubSubException(Authorization.FORBIDDEN);
                }
                resultQuery.addChild((XMLNodeIfc)new Element("identity", new String[]{"category", "type"}, new String[]{"pubsub", nodeConfig.getNodeType().name()}));
                resultQuery.addChild((XMLNodeIfc)new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/pubsub"}));
                Form form = new Form("result", null, null);
                form.addField(Field.fieldHidden((String)"FORM_TYPE", (String)"http://jabber.org/protocol/pubsub#meta-data"));
                form.addField(Field.fieldTextSingle((String)"pubsub#title", (String)nodeConfig.getTitle(), (String)"A short name for the node"));
                resultQuery.addChild((XMLNodeIfc)form.getElement());
            }
            this.packetWriter.write(resultIq);
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

