/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.cluster;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.CommandListener;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.muc.Affiliation;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.cluster.AbstractClusteredRoomStrategy;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class ClusteredRoomStrategyNoPresence
extends AbstractClusteredRoomStrategy {
    private static final Logger a = Logger.getLogger(ClusteredRoomStrategyNoPresence.class.getCanonicalName());
    private static final String b = "occupants-remote-key";
    private static final String c = "muc-occupant-presence-cmd";
    private static final String d = "request-occupants-sync";
    private final b e = new b();
    private final c f = new c();

    @Override
    public void setClusterController(ClusterControllerIfc cl_controller) {
        if (this.cl_controller != null) {
            this.cl_controller.removeCommandListener((CommandListener)this.e);
            this.cl_controller.removeCommandListener((CommandListener)this.f);
        }
        super.setClusterController(cl_controller);
        if (cl_controller != null) {
            cl_controller.setCommandListener((CommandListener)this.e);
            cl_controller.setCommandListener((CommandListener)this.f);
        }
    }

    public void onOccupantChangedPresence(Room room, JID occupantJid, String nickname, Element presence, boolean newOccupant) {
        List<JID> list = this.getAllNodes();
        list.remove(this.localNodeJid);
        if (occupantJid != null && presence == null) {
            presence = new Element("presence", new String[]{"type", "xmlns"}, new String[]{"unavailable", "jabber:client"});
        }
        if (occupantJid == null) {
            occupantJid = JID.jidInstanceNS((String)presence.getAttributeStaticStr("from"));
        }
        Affiliation affiliation = room.getAffiliation(occupantJid.getBareJID());
        Role role = room.getRole(nickname);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("room", room.getRoomJID().toString());
        hashMap.put("userId", occupantJid.toString());
        hashMap.put("nickname", nickname);
        hashMap.put("affiliation", affiliation.name());
        hashMap.put("role", role.name());
        if (newOccupant) {
            hashMap.put("new-occupant", String.valueOf(newOccupant));
        }
        if (a.isLoggable(Level.FINEST)) {
            StringBuilder stringBuilder = new StringBuilder(100);
            for (JID jID : list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(jID.toString());
            }
            a.log(Level.FINEST, "room = {0}, notifing nodes [{1}] that occupant {2} in room {3} changed presence = {4}", new Object[]{room.getRoomJID(), stringBuilder, occupantJid, room.getRoomJID(), presence});
        }
    }

    @Override
    protected void requestSync(JID nodeJid) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentMap<String, a> a(Room room) {
        ConcurrentMap concurrentMap = (ConcurrentHashMap)room.getRoomCustomData(b);
        if (concurrentMap == null) {
            Room room2 = room;
            synchronized (room2) {
                concurrentMap = new ConcurrentHashMap();
                ConcurrentMap concurrentMap2 = (ConcurrentMap)room.getRoomCustomData(b);
                if (concurrentMap2 == null) {
                    room.setRoomCustomData(b, concurrentMap);
                } else {
                    concurrentMap = concurrentMap2;
                }
            }
        }
        return concurrentMap;
    }

    @Override
    protected void sendRemoteOccupantRemovalOnDisconnect(Room room, JID occupant, String occupantNick, boolean sendRemovalToOccupant) {
        super.sendRemoteOccupantRemovalOnDisconnect(room, occupant, occupantNick, sendRemovalToOccupant);
        ConcurrentMap<String, a> concurrentMap = this.a(room);
        concurrentMap.remove(occupantNick);
    }

    private class a {
        private JID b;
        private String c;
        private Affiliation d;
        private Role e;
        private Element f;

        public JID a() {
            return this.b;
        }

        public void a(JID jID) {
            this.b = jID;
        }

        public String b() {
            return this.c;
        }

        public void a(String string) {
            this.c = string;
        }

        public Affiliation c() {
            return this.d;
        }

        public void a(Affiliation affiliation) {
            this.d = affiliation;
        }

        public Role d() {
            return this.e;
        }

        public void a(Role role) {
            this.e = role;
        }

        public Element e() {
            return this.f;
        }

        public void a(Element element) {
            this.f = element;
        }
    }

    private class c
    extends CommandListenerAbstract {
        public c() {
            super(ClusteredRoomStrategyNoPresence.d);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            ArrayList arrayList = new ArrayList(ClusteredRoomStrategyNoPresence.this.muc.getMucRepository().getActiveRooms().values());
            a.log(Level.FINEST, "executig OccupantsSyncRequestCmd command fromNode = {0}, rooms = {1}", new Object[]{fromNode.toString(), ((Object)arrayList).toString()});
        }
    }

    private class b
    extends CommandListenerAbstract {
        public b() {
            super(ClusteredRoomStrategyNoPresence.c);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            BareJID bareJID = BareJID.bareJIDInstanceNS((String)data.get("room"));
            JID jID = JID.jidInstanceNS((String)data.get("userId"));
            String string = data.get("nickname");
            Affiliation affiliation = Affiliation.valueOf((String)data.get("affiliation"));
            Role role = Role.valueOf((String)data.get("role"));
            boolean bl = data.containsKey("new-occupant");
            a.log(Level.FINEST, "executig OccupantChangedPresenceCmd command for room = {0}, occupantJID = {1},nickname: {2}, occupantAffiliation = {3}, occupantRole = {4}, newOccupant = {5} ", new Object[]{bareJID.toString(), jID.toString(), string, affiliation, role, bl});
        }
    }
}

