/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.muc.Affiliation;
import tigase.muc.MucContext;
import tigase.muc.Room;
import tigase.muc.exceptions.MUCException;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class DiscoveryModule
extends tigase.component.modules.impl.DiscoveryModule<MucContext> {
    private static void addFeature(Element query, String feature) {
        query.addChild((XMLNodeIfc)new Element("feature", new String[]{"var"}, new String[]{feature}));
    }

    protected void processDiscoInfo(Packet packet, JID requestedJID, String node, JID senderJID) throws ComponentException, RepositoryException {
        if (node == null && requestedJID.getLocalpart() == null && requestedJID.getResource() == null) {
            super.processDiscoInfo(packet, requestedJID, node, senderJID);
        } else if (node == null && requestedJID.getLocalpart() != null && requestedJID.getResource() == null) {
            Element resultQuery = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/disco#info"});
            Room room = ((MucContext)this.context).getMucRepository().getRoom(requestedJID.getBareJID());
            if (room == null) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND);
            }
            String roomName = room.getConfig().getRoomName();
            Element resultIdentity = new Element("identity", new String[]{"category", "name", "type"}, new String[]{"conference", roomName == null ? "" : roomName, "text"});
            resultQuery.addChild((XMLNodeIfc)resultIdentity);
            DiscoveryModule.addFeature(resultQuery, "http://jabber.org/protocol/muc");
            switch (room.getConfig().getRoomAnonymity()) {
                case fullanonymous: {
                    DiscoveryModule.addFeature(resultQuery, "muc_fullyanonymous");
                    break;
                }
                case semianonymous: {
                    DiscoveryModule.addFeature(resultQuery, "muc_semianonymous");
                    break;
                }
                case nonanonymous: {
                    DiscoveryModule.addFeature(resultQuery, "muc_nonanonymous");
                }
            }
            if (room.getConfig().isRoomModerated()) {
                DiscoveryModule.addFeature(resultQuery, "muc_moderated");
            } else {
                DiscoveryModule.addFeature(resultQuery, "muc_unmoderated");
            }
            if (room.getConfig().isRoomMembersOnly()) {
                DiscoveryModule.addFeature(resultQuery, "muc_membersonly");
            } else {
                DiscoveryModule.addFeature(resultQuery, "muc_open");
            }
            if (room.getConfig().isPersistentRoom()) {
                DiscoveryModule.addFeature(resultQuery, "muc_persistent");
            } else {
                DiscoveryModule.addFeature(resultQuery, "muc_temporary");
            }
            if (!room.getConfig().isRoomconfigPublicroom()) {
                DiscoveryModule.addFeature(resultQuery, "muc_hidden");
            } else {
                DiscoveryModule.addFeature(resultQuery, "muc_public");
            }
            if (room.getConfig().isPasswordProtectedRoom()) {
                DiscoveryModule.addFeature(resultQuery, "muc_passwordprotected");
            } else {
                DiscoveryModule.addFeature(resultQuery, "muc_unsecured");
            }
            this.write(packet.okResult(resultQuery, 0));
        } else if (node == null && requestedJID.getLocalpart() != null && requestedJID.getResource() != null) {
            this.write(packet.okResult((Element)null, 0));
        } else {
            throw new MUCException(Authorization.BAD_REQUEST);
        }
    }

    protected void processDiscoItems(Packet packet, JID requestedJID, String node, JID senderJID) throws ComponentException, RepositoryException {
        Element resultQuery = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/disco#items"});
        Packet result = packet.okResult(resultQuery, 0);
        if (node == null && requestedJID.getLocalpart() == null && requestedJID.getResource() == null) {
            BareJID[] roomsId;
            for (BareJID jid : roomsId = ((MucContext)this.context).getMucRepository().getPublicVisibleRoomsIdList()) {
                if (!jid.getDomain().equals(requestedJID.getDomain())) continue;
                String name = ((MucContext)this.context).getMucRepository().getRoomName(jid.toString());
                Room room = ((MucContext)this.context).getMucRepository().getRoom(jid);
                if (!room.getConfig().isRoomconfigPublicroom()) {
                    Affiliation senderAff = room.getAffiliation(senderJID.getBareJID());
                    if (!room.isOccupantInRoom(senderJID) && (senderAff == Affiliation.none || senderAff == Affiliation.outcast)) continue;
                }
                resultQuery.addChild((XMLNodeIfc)new Element("item", new String[]{"jid", "name"}, new String[]{jid.toString(), name != null ? name : jid.getLocalpart()}));
            }
        } else if (node == null && requestedJID.getLocalpart() != null && requestedJID.getResource() == null) {
            Room room = ((MucContext)this.context).getMucRepository().getRoom(requestedJID.getBareJID());
            if (room == null) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND);
            }
            String nickname = room.getOccupantsNickname(packet.getStanzaFrom());
            if (nickname == null) {
                throw new MUCException(Authorization.FORBIDDEN);
            }
            for (String nick : room.getOccupantsNicknames()) {
                resultQuery.addChild((XMLNodeIfc)new Element("item", new String[]{"jid", "name"}, new String[]{room.getRoomJID() + "/" + nick, nick}));
            }
        } else if (node == null && requestedJID.getLocalpart() != null && requestedJID.getResource() != null) {
            this.write(packet.okResult((Element)null, 0));
        } else {
            throw new MUCException(Authorization.BAD_REQUEST);
        }
        this.write(result);
    }
}

