/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppsession;

import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;

public class PacketDefaultHandler {
    private static final Logger log = Logger.getLogger(PacketDefaultHandler.class.getName());
    private String[] IGNORE_PACKETS = new String[]{"stream:features"};
    private StanzaType[] IGNORE_TYPES = new StanzaType[]{StanzaType.error};

    public boolean canHandle(Packet packet, XMPPResourceConnection session) {
        if (session == null) {
            return false;
        }
        if (packet.getStanzaTo() == null) {
            if (packet.getElemName() == "iq" && packet.getType() == StanzaType.result) {
                return true;
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "No ''to'' address, can''t deliver packet: {0}", packet);
            }
            return false;
        }
        return true;
    }

    public boolean forward(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        return false;
    }

    public boolean preprocess(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        if (session != null) {
            session.incPacketsCounter();
            XMPPSession parent = session.getParentSession();
            if (parent != null) {
                parent.incPacketsCounter();
            }
        }
        for (int i = 0; i < this.IGNORE_PACKETS.length; ++i) {
            if (packet.getElemName() != this.IGNORE_PACKETS[i] || packet.getType() != this.IGNORE_TYPES[i]) continue;
            return true;
        }
        return false;
    }

    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) throws XMPPException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Processing packet: {0}", packet.toStringSecure());
        }
        try {
            BareJID from;
            JID to = packet.getStanzaTo();
            if (to == null && packet.getElemName() == "iq" && packet.getType() == StanzaType.result) {
                return;
            }
            if (session.isUserId(to.getBareJID())) {
                Packet result;
                String resource = packet.getStanzaTo().getResource();
                if (resource == null) {
                    result = Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(packet, "The feature is not supported yet.", true);
                    result.setPacketFrom(null);
                    result.setPacketTo(null);
                } else {
                    XMPPResourceConnection con = session.getParentSession().getResourceForResource(resource);
                    if (con != null) {
                        result = packet.copyElementOnly();
                        result.setPacketTo(con.getConnectionId());
                        result.setPacketFrom(packet.getTo());
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "Delivering message, packet: {0}, to session: {1}", new Object[]{packet, con});
                        }
                    } else {
                        result = Authorization.RECIPIENT_UNAVAILABLE.getResponseMessage(packet, "The recipient is no longer available.", true);
                        result.setPacketFrom(null);
                        result.setPacketTo(null);
                    }
                }
                results.offer(result);
                return;
            }
            if (packet.getStanzaFrom() != null && session.isUserId(from = packet.getStanzaFrom().getBareJID())) {
                Packet result = packet.copyElementOnly();
                results.offer(result);
            }
        }
        catch (NotAuthorizedException e) {
            try {
                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
                log.log(Level.FINE, "NotAuthorizedException for packet: {0}", packet.toString());
            }
            catch (PacketErrorTypeException e2) {
                log.log(Level.FINE, "Packet processing exception: {0}", e2);
            }
        }
    }
}

