/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver.proc;

import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.net.ConnectionType;
import tigase.server.xmppserver.CID;
import tigase.server.xmppserver.CIDConnections;
import tigase.server.xmppserver.LocalhostException;
import tigase.server.xmppserver.NotLocalhostException;
import tigase.server.xmppserver.S2SConnection;
import tigase.server.xmppserver.S2SIOService;
import tigase.server.xmppserver.proc.S2SAbstractProcessor;

public class StreamOpen
extends S2SAbstractProcessor {
    private static final Logger log = Logger.getLogger(StreamOpen.class.getName());

    @Override
    public int order() {
        return S2SAbstractProcessor.Order.StreamOpen.ordinal();
    }

    @Override
    public void serviceStarted(S2SIOService serv) {
        switch (serv.connectionType()) {
            case connect: {
                S2SConnection s2s_conn;
                CID cid = (CID)serv.getSessionData().get("cid");
                serv.getSessionData().put("hostname-key", cid.getLocalHost());
                String data = "<stream:stream xmlns:stream='http://etherx.jabber.org/streams' xmlns='jabber:server' xmlns:db='jabber:server:dialback' from='" + cid.getLocalHost() + "'" + " to='" + cid.getRemoteHost() + "'" + " version='1.0'>";
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "{0}, sending: {1}", new Object[]{serv, data});
                }
                if ((s2s_conn = (S2SConnection)serv.getSessionData().get("s2s-connection-key")) == null) {
                    log.log(Level.WARNING, "Protocol error s2s_connection not set for outgoing connection: {0}", serv);
                    serv.stop();
                } else {
                    s2s_conn.setS2SIOService(serv);
                    serv.setS2SConnection(s2s_conn);
                }
                serv.xmppStreamOpen(data);
                break;
            }
        }
    }

    @Override
    public void serviceStopped(S2SIOService serv) {
        CID cid = (CID)serv.getSessionData().get("cid");
        if (cid == null) {
            if (serv.connectionType() == ConnectionType.connect) {
                log.log(Level.WARNING, "Protocol error cid not set for outgoing connection: {0}", serv);
            }
            return;
        }
        try {
            CIDConnections cid_conns = this.handler.getCIDConnections(cid, false);
            if (cid_conns == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Protocol error cid_conns not found for outgoing connection: {0}", serv);
                }
                return;
            }
            cid_conns.connectionStopped(serv);
        }
        catch (NotLocalhostException ex) {
            log.log(Level.WARNING, "Not a local host for cid: {0}", cid);
        }
        catch (LocalhostException ex) {
            log.log(Level.WARNING, "A local host for cid: {0}", cid);
        }
    }

    @Override
    public String streamOpened(S2SIOService serv, Map<String, String> attribs) {
        CID cid = (CID)serv.getSessionData().get("cid");
        String remote_hostname = attribs.get("from");
        String local_hostname = attribs.get("to");
        String version = attribs.get("version");
        if (version != null) {
            serv.getSessionData().put("version", version);
        }
        if (cid == null && remote_hostname != null && local_hostname != null) {
            cid = new CID(local_hostname, remote_hostname);
        }
        try {
            CIDConnections cid_conns = this.handler.getCIDConnections(cid, false);
            switch (serv.connectionType()) {
                case connect: {
                    String remote_id = attribs.get("id");
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "{0}, Connect Stream opened for: {1}, session id{2}", new Object[]{serv, cid, remote_id});
                    }
                    if (cid_conns == null) {
                        log.log(Level.WARNING, "{0} This might be a bug in s2s code, should not happen. Missing CIDConnections for stream open to ''connect'' service type.", serv);
                        this.generateStreamError(false, "internal-server-error", serv);
                        return null;
                    }
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "{0}, stream open for cid: {1}, outgoint: {2}, incoming: {3}", new Object[]{serv, cid, cid_conns.getOutgoingCount(), cid_conns.getIncomingCount()});
                    }
                    serv.setSessionId(remote_id);
                    return null;
                }
                case accept: {
                    if (local_hostname != null) {
                        serv.getSessionData().put("hostname-key", local_hostname);
                    } else if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "{0}, Unknown local hostname.", serv);
                    }
                    String id = UUID.randomUUID().toString();
                    serv.setSessionId(id);
                    String stream_open = "<stream:stream xmlns:stream='http://etherx.jabber.org/streams' xmlns='jabber:server' xmlns:db='jabber:server:dialback' id='" + id + "'";
                    if (cid != null) {
                        stream_open = stream_open + " from='" + cid.getLocalHost() + "'" + " to='" + cid.getRemoteHost() + "'";
                        if (cid_conns == null) {
                            cid_conns = this.handler.getCIDConnections(cid, true);
                        }
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "{0}, Accept Stream opened for: {1}, session id: {2}", new Object[]{serv, cid, id});
                        }
                        serv.getSessionData().put("cid", cid);
                        cid_conns.addIncoming(serv);
                    } else if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "{0}, Accept Stream opened for unknown CID, session id: {1}", new Object[]{serv, id});
                    }
                    if (FORCE_VERSION || attribs.containsKey("version")) {
                        stream_open = stream_open + " version='1.0'";
                    }
                    stream_open = stream_open + ">";
                    return stream_open;
                }
            }
            log.log(Level.SEVERE, "{0}, Warning, program shouldn't reach that point.", serv);
        }
        catch (NotLocalhostException ex) {
            this.generateStreamError(false, "host-unknown", serv);
        }
        catch (LocalhostException ex) {
            this.generateStreamError(false, "invalid-from", serv);
        }
        return null;
    }
}

