/*
 * Decompiled with CFR 0.152.
 */
package tigase.disteventbus.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.disteventbus.EventBus;
import tigase.disteventbus.EventHandler;
import tigase.disteventbus.FireEventException;
import tigase.disteventbus.impl.EventName;
import tigase.disteventbus.impl.EventsNameMap;
import tigase.xml.Element;

public class LocalEventBus
implements EventBus {
    private final EventsNameMap<EventHandler> handlers;
    private final Collection<LocalEventBusListener> internalListeners = new HashSet<LocalEventBusListener>();
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    private boolean throwingExceptionOn = true;

    public LocalEventBus() {
        this.handlers = this.createHandlersMap();
    }

    @Override
    public void addHandler(String name, String xmlns, EventHandler handler) {
        this.handlers.put(name, xmlns, handler);
        this.fireOnAddHandler(name, xmlns, handler);
    }

    public void addListener(LocalEventBusListener listener) {
        if (!this.internalListeners.contains(listener)) {
            this.internalListeners.add(listener);
        }
    }

    protected EventsNameMap<EventHandler> createHandlersMap() {
        return new EventsNameMap<EventHandler>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFire(String name, String xmlns, Element event) {
        if (event == null) {
            throw new NullPointerException("Cannot fire null event");
        }
        ArrayList<EventHandler> handlers = new ArrayList<EventHandler>();
        EventsNameMap<EventHandler> eventsNameMap = this.handlers;
        synchronized (eventsNameMap) {
            handlers.addAll(this.getHandlersList(name, xmlns));
            handlers.addAll(this.getHandlersList(null, xmlns));
        }
        this.doFire(name, xmlns, event, handlers);
    }

    public void doFire(String name, String xmlns, Element event, ArrayList<EventHandler> handlersList) {
        HashSet<Throwable> causes = new HashSet<Throwable>();
        for (EventHandler eventHandler : handlersList) {
            try {
                eventHandler.onEvent(name, xmlns, event);
            }
            catch (Throwable e) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.log(Level.WARNING, "", e);
                }
                causes.add(e);
            }
        }
        if (!causes.isEmpty() && this.throwingExceptionOn) {
            throw new FireEventException(causes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fire(Element event) {
        String name = event.getName();
        String xmlns = event.getXMLNS();
        try {
            this.doFire(name, xmlns, event);
        }
        finally {
            this.fireOnFire(name, xmlns, event);
        }
    }

    private void fireOnAddHandler(String name, String xmlns, EventHandler handler) {
        for (LocalEventBusListener listener : this.internalListeners) {
            listener.onAddHandler(name, xmlns, handler);
        }
    }

    private void fireOnFire(String name, String xmlns, Element event) {
        for (LocalEventBusListener listener : this.internalListeners) {
            listener.onFire(name, xmlns, event);
        }
    }

    private void fireOnRemoveHandler(String name, String xmlns, EventHandler handler) {
        for (LocalEventBusListener listener : this.internalListeners) {
            listener.onRemoveHandler(name, xmlns, handler);
        }
    }

    public Set<EventName> getAllListenedEvents() {
        Set<EventName> result = this.handlers.getAllListenedEvents();
        return result;
    }

    protected Collection<EventHandler> getHandlersList(String name, String xmlns) {
        return this.handlers.get(name, xmlns);
    }

    public boolean hasHandlers(String name, String xmlns) {
        return this.handlers.hasData(name, xmlns);
    }

    @Override
    public void removeHandler(String name, String xmlns, EventHandler handler) {
        this.handlers.delete(name, xmlns, handler);
        this.fireOnRemoveHandler(name, xmlns, handler);
    }

    public void removeListener(LocalEventBusListener listener) {
        this.internalListeners.remove(listener);
    }

    public static interface LocalEventBusListener {
        public void onAddHandler(String var1, String var2, EventHandler var3);

        public void onFire(String var1, String var2, Element var3);

        public void onRemoveHandler(String var1, String var2, EventHandler var3);
    }
}

