/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPStopListenerIfc;
import tigase.xmpp.impl.JabberIqRoster;
import tigase.xmpp.impl.Presence;
import tigase.xmpp.impl.RemoteRosterManagement;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterFactory;

@Deprecated
public class RosterPresence
extends XMPPProcessor
implements XMPPProcessorIfc,
XMPPStopListenerIfc {
    private static final String ID = "roster-presence";
    private static Logger log = Logger.getLogger(RosterPresence.class.getName());
    private static final String PRESENCE = "presence";
    private static final String[][] ELEMENTS = new String[][]{{"presence"}, Iq.IQ_QUERY_PATH, Iq.IQ_QUERY_PATH};
    private static final String[] XMLNSS = new String[]{"jabber:client", "jabber:iq:roster", "jabber:iq:roster-dynamic"};
    private static final RosterAbstract roster_util = RosterFactory.getRosterImplementation(true);
    private static final Element[] FEATURES = RosterAbstract.FEATURES;
    private static final Element[] DISCO_FEATURES = RosterAbstract.DISCO_FEATURES;
    private JabberIqRoster rosterProc = new JabberIqRoster();
    private Presence presenceProc = new Presence();

    @Override
    public int concurrentQueuesNo() {
        return Runtime.getRuntime().availableProcessors() * 2;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (!session.isAuthorized()) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Session is not authorized, ignoring packet: {0}", packet);
            }
            return;
        }
        if (packet.getElemName().equals(PRESENCE)) {
            this.presenceProc.process(packet, session, repo, results, settings);
        } else if (packet.getStanzaTo() != null && packet.getStanzaFrom() != null && session.isUserId(packet.getStanzaTo().getBareJID()) && !session.isUserId(packet.getStanzaFrom().getBareJID())) {
            if (!RemoteRosterManagement.isRemoteAllowed(packet.getStanzaFrom(), session)) {
                results.offer(Authorization.NOT_ALLOWED.getResponseMessage(packet, "Not authorized for remote roster management", true));
                return;
            }
            try {
                switch (packet.getType()) {
                    case get: {
                        List<Element> ritems = roster_util.getRosterItems(session);
                        if (ritems != null && !ritems.isEmpty()) {
                            Element query = new Element("query");
                            query.setXMLNS("jabber:iq:roster");
                            String jidStr = "@" + packet.getStanzaFrom().getBareJID().toString();
                            for (Element ritem : ritems) {
                                if (!ritem.getAttributeStaticStr("jid").endsWith(jidStr)) continue;
                                query.addChild(ritem);
                            }
                            results.offer(packet.okResult(query, 0));
                            break;
                        }
                        results.offer(packet.okResult((String)null, 1));
                        break;
                    }
                    case set: {
                        this.rosterProc.processSetRequest(packet, session, results, settings);
                        break;
                    }
                    default: {
                        results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Bad stanza type", true));
                        break;
                    }
                }
            }
            catch (Throwable ex) {
                log.log(Level.WARNING, "Reflection execution exception", ex);
                results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Internal server error", true));
            }
        } else {
            this.rosterProc.process(packet, session, repo, results, settings);
        }
    }

    @Override
    public void stopped(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) {
        this.presenceProc.stopped(session, results, settings);
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        return FEATURES;
    }
}

