/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CoderResult;
import java.nio.charset.MalformedInputException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.Packet;
import tigase.server.websocket.WebSocketProtocolIfc;
import tigase.xmpp.XMPPIOService;

public class WebSocketXMPPIOService<RefObject>
extends XMPPIOService<RefObject> {
    private static final String BAD_REQUEST = "HTTP/1.0 400 Bad request\r\n\r\n";
    private static final String CONNECTION_KEY = "Connection";
    private static final Logger log = Logger.getLogger(WebSocketXMPPIOService.class.getCanonicalName());
    private static final String CLOSE_EL = "close";
    private static final String OPEN_EL = "open";
    private static final String XMLNS_FRAMING = "urn:ietf:params:xml:ns:xmpp-framing";
    protected long frameLength = -1L;
    protected byte[] maskingKey = null;
    private byte[] partialData = null;
    private boolean websocket = false;
    private boolean started = false;
    private final WebSocketProtocolIfc[] protocols;
    private WebSocketProtocolIfc protocol = null;
    private WebSocketXMPPSpec webSocketXMPPSpec = WebSocketXMPPSpec.hybi;

    public WebSocketXMPPIOService(WebSocketProtocolIfc[] enabledProtocols) {
        this.protocols = enabledProtocols;
    }

    @Override
    public void stop() {
        this.protocol.closeConnection(this);
        super.stop();
    }

    @Override
    protected void addReceivedPacket(Packet packet) {
        if (packet.getXMLNS() == XMLNS_FRAMING) {
            if (packet.getElemName() == OPEN_EL) {
                this.webSocketXMPPSpec = WebSocketXMPPSpec.xmpp;
                this.xmppStreamOpened(packet.getElement().getAttributes());
                return;
            }
            if (packet.getElemName() == CLOSE_EL) {
                this.xmppStreamClosed();
                return;
            }
        }
        super.addReceivedPacket(packet);
    }

    protected WebSocketXMPPSpec getWebSocketXMPPSpec() {
        return this.webSocketXMPPSpec;
    }

    @Override
    protected String prepareStreamClose() {
        if (this.webSocketXMPPSpec == WebSocketXMPPSpec.hybi) {
            return "</stream:stream>";
        }
        return "<close xmlns='urn:ietf:params:xml:ns:xmpp-framing' />";
    }

    @Override
    protected char[] readData() throws IOException {
        ByteBuffer cb = super.readBytes();
        if (cb == null) {
            return null;
        }
        if (this.partialData != null) {
            ByteBuffer oldtmp = cb;
            cb = ByteBuffer.allocate(this.partialData.length + oldtmp.remaining());
            cb.order(oldtmp.order());
            cb.put(this.partialData);
            cb.put(oldtmp);
            cb.flip();
            oldtmp.clear();
            this.partialData = null;
        }
        if (this.websocket) {
            ByteBuffer tmp = ByteBuffer.allocate(cb.remaining());
            ByteBuffer decoded = null;
            while (cb.hasRemaining() && (decoded = this.decodeFrame(cb)) != null) {
                if (decoded == null || !decoded.hasRemaining()) continue;
                tmp.put(decoded);
            }
            if (cb.hasRemaining()) {
                this.partialData = new byte[cb.remaining()];
                cb.get(this.partialData);
            }
            cb.compact();
            if (tmp.capacity() > 0) {
                tmp.flip();
            }
            cb = tmp;
        }
        if (this.started) {
            return this.decode(cb);
        }
        if (!cb.hasRemaining()) {
            return null;
        }
        try {
            int remaining = cb.remaining();
            byte[] buf = new byte[remaining];
            cb.get(buf, 0, remaining);
            cb.compact();
            int pos = remaining;
            if (pos > 100 && (buf[pos - 1] == 10 && buf[pos - 1] == buf[pos - 3] || buf[pos - 9] == 10 && buf[pos - 9] == buf[pos - 11])) {
                this.started = true;
                this.processWebSocketHandshake(buf);
                this.websocket = true;
            } else {
                this.partialData = buf;
            }
        }
        catch (Exception ex) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "exception processing websocket handshake", ex);
            }
            this.forceStop();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeData(String data) {
        block11: {
            boolean locked = this.writeInProgress.tryLock();
            if (!locked) {
                if (data == null) {
                    return;
                }
                this.writeInProgress.lock();
            }
            try {
                if (this.websocket) {
                    try {
                        if (data != null) {
                            if (log.isLoggable(Level.FINEST)) {
                                log.log(Level.FINEST, "sending data = {0}", data);
                            }
                            ByteBuffer buf = this.encode(data);
                            this.protocol.encodeFrameAndWrite(this, buf);
                            break block11;
                        }
                        this.writeBytes(null);
                    }
                    catch (Exception ex) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "exception writing data", ex);
                        }
                        this.forceStop();
                    }
                    break block11;
                }
                super.writeData(data);
            }
            finally {
                this.writeInProgress.unlock();
            }
        }
    }

    private void processWebSocketHandshake(byte[] buf) throws NoSuchAlgorithmException, IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        int i = 0;
        while (buf[i] != 10) {
            ++i;
        }
        ++i;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "parsing request = \n{0}", new String(buf));
        }
        StringBuilder builder = new StringBuilder(64);
        String key = null;
        while (i < buf.length) {
            switch (buf[i]) {
                case 58: {
                    if (key == null) {
                        key = builder.toString();
                        builder = new StringBuilder(64);
                        ++i;
                        break;
                    }
                    builder.append((char)buf[i]);
                    break;
                }
                case 13: {
                    headers.put(key, builder.toString());
                    key = null;
                    builder = new StringBuilder(64);
                    if (buf[i + 2] == 13) {
                        i += 3;
                        break;
                    }
                    ++i;
                    break;
                }
                default: {
                    builder.append((char)buf[i]);
                }
            }
            ++i;
        }
        if (!headers.containsKey(CONNECTION_KEY) || !((String)headers.get(CONNECTION_KEY)).contains("Upgrade")) {
            this.writeRawData(BAD_REQUEST);
            this.dumpHeaders(headers);
            this.forceStop();
            return;
        }
        if (!headers.containsKey("Sec-WebSocket-Protocol") || !headers.get("Sec-WebSocket-Protocol").contains("xmpp")) {
            this.writeRawData(BAD_REQUEST);
            this.dumpHeaders(headers);
            this.forceStop();
            return;
        }
        i = 0;
        while (this.protocol == null && i < this.protocols.length) {
            if (this.protocols[i].handshake(this, headers, buf)) {
                this.protocol = this.protocols[i];
                continue;
            }
            ++i;
        }
        if (this.protocol == null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "could not find implementation for WebSocket protocol for {0}", this);
            }
            this.dumpHeaders(headers);
            this.forceStop();
        }
    }

    @Override
    protected void writeBytes(ByteBuffer data) {
        super.writeBytes(data);
    }

    private ByteBuffer decodeFrame(ByteBuffer buf) {
        return this.protocol.decodeFrame(this, buf);
    }

    private char[] decode(ByteBuffer tmpBuffer) throws MalformedInputException {
        CoderResult cr;
        if (tmpBuffer == null) {
            return null;
        }
        char[] result = null;
        if (this.partialCharacterBytes != null) {
            ByteBuffer oldTmpBuffer = tmpBuffer;
            tmpBuffer = ByteBuffer.allocate(this.partialCharacterBytes.length + oldTmpBuffer.remaining() + 2);
            tmpBuffer.put(this.partialCharacterBytes);
            tmpBuffer.put(oldTmpBuffer);
            tmpBuffer.flip();
            oldTmpBuffer.clear();
            this.partialCharacterBytes = null;
        }
        if (this.cb.capacity() < tmpBuffer.remaining() * 4) {
            this.cb = CharBuffer.allocate(tmpBuffer.remaining() * 4);
        }
        if ((cr = this.decoder.decode(tmpBuffer, this.cb, false)).isMalformed()) {
            throw new MalformedInputException(tmpBuffer.remaining());
        }
        if (this.cb.remaining() > 0) {
            this.cb.flip();
            result = new char[this.cb.remaining()];
            this.cb.get(result);
        }
        if (cr.isUnderflow() && tmpBuffer.remaining() > 0) {
            this.partialCharacterBytes = new byte[tmpBuffer.remaining()];
            tmpBuffer.get(this.partialCharacterBytes);
        }
        tmpBuffer.clear();
        this.cb.clear();
        return result;
    }

    private ByteBuffer encode(String data) throws CharacterCodingException {
        ByteBuffer dataBuffer = null;
        this.encoder.reset();
        dataBuffer = this.encoder.encode(CharBuffer.wrap(data));
        this.encoder.flush(dataBuffer);
        return dataBuffer;
    }

    public void dumpHeaders(Map<String, String> headers) {
        if (log.isLoggable(Level.FINEST)) {
            StringBuilder builder = new StringBuilder(1000);
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                builder.append("KEY = ");
                builder.append(entry.getKey());
                builder.append("VALUE = ");
                builder.append(entry.getValue());
                builder.append('\n');
            }
            log.log(Level.FINEST, "received headers = \n{0}", builder.toString());
        }
    }

    public static enum WebSocketXMPPSpec {
        hybi,
        xmpp;

    }
}

