/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.sreceiver.sysmon;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.Packet;
import tigase.server.sreceiver.sysmon.AbstractMonitor;
import tigase.stats.StatisticsList;

public class N270Monitor
extends AbstractMonitor {
    private static final Logger log = Logger.getLogger(N270Monitor.class.getName());
    private static final String TEMP_FILE = "/proc/acpi/thermal_zone/TZ01/temperature";
    private static final String THROTT_DIR = "/proc/acpi/processor/CPU";
    private static final String THROTT_FILE = "/throttling";
    private static final String FREQ_FILE = "/proc/cpuinfo";
    private int cpu_temp = 0;
    private int[] cpu_thrott_st = new int[Runtime.getRuntime().availableProcessors()];
    private int[] cpu_thrott_pr = new int[Runtime.getRuntime().availableProcessors()];
    private float[] cpu_freq = new float[Runtime.getRuntime().availableProcessors()];
    private static final String N270_MON = "cpu-mon";

    @Override
    public void destroy() {
    }

    @Override
    public void check10Secs(Queue<Packet> results) {
        this.checkCPUTemperature();
        this.checkCPUFrequency();
        this.checkCPUThrottling();
    }

    private void checkCPUFrequency() {
        try {
            int cpu = 0;
            BufferedReader buffr = new BufferedReader(new FileReader(FREQ_FILE));
            String line = null;
            while ((line = buffr.readLine()) != null) {
                if (!line.startsWith("cpu MHz")) continue;
                int idx = line.indexOf(58);
                this.cpu_freq[cpu++] = Float.parseFloat(line.substring(idx + 1).trim());
            }
            buffr.close();
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Can't read file: /proc/cpuinfo", ex);
        }
    }

    private void checkCPUTemperature() {
        try {
            BufferedReader buffr = new BufferedReader(new FileReader(TEMP_FILE));
            String line = buffr.readLine();
            if (line != null) {
                this.cpu_temp = Integer.parseInt(line.substring("temperature:".length(), line.length() - 1).trim());
            } else {
                log.warning("Empty file: /proc/acpi/thermal_zone/TZ01/temperature");
            }
            buffr.close();
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Can't read file: /proc/acpi/thermal_zone/TZ01/temperature", ex);
        }
    }

    private void checkCPUThrottling() {
        for (int i = 0; i < this.cpu_thrott_st.length; ++i) {
            try {
                BufferedReader buffr = new BufferedReader(new FileReader(THROTT_DIR + i + THROTT_FILE));
                String line = null;
                while ((line = buffr.readLine()) != null) {
                    String line_trimmed = line.trim();
                    if (!line_trimmed.startsWith("*")) continue;
                    int idx = line_trimmed.indexOf(58);
                    this.cpu_thrott_st[i] = Integer.parseInt(line_trimmed.substring(2, idx));
                    String line_pr = line_trimmed.substring(idx + 1, line_trimmed.length() - 1).trim();
                    this.cpu_thrott_pr[i] = Integer.parseInt(line_pr);
                }
                buffr.close();
                continue;
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Can't read file: /proc/acpi/processor/CPU" + i + THROTT_FILE, ex);
            }
        }
    }

    @Override
    public String getState() {
        StringBuilder sb = new StringBuilder("CPU temperature: " + this.cpu_temp + " C\n");
        for (int i = 0; i < this.cpu_thrott_st.length; ++i) {
            sb.append("CPU " + i + ": FREQ: " + this.cpu_freq[i] + " MHz, Throtting: T" + this.cpu_thrott_st[i] + " - " + this.cpu_thrott_pr[i] + "%\n");
        }
        return sb.toString();
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        list.add(N270_MON, "CPU temp", this.cpu_temp, Level.INFO);
        if (list.checkLevel(Level.FINE)) {
            StringBuilder cpu_freq_str = new StringBuilder();
            StringBuilder cpu_thr_str = new StringBuilder();
            for (int i = 0; i < this.cpu_thrott_st.length; ++i) {
                if (cpu_freq_str.length() > 0) {
                    cpu_freq_str.append(", ");
                }
                cpu_freq_str.append("CPU").append(i).append(": ");
                cpu_freq_str.append(this.cpu_freq[i]).append(" MHz");
                if (cpu_thr_str.length() > 0) {
                    cpu_thr_str.append(", ");
                }
                cpu_thr_str.append("CPU").append(i).append(": T");
                cpu_thr_str.append(this.cpu_thrott_st[i]).append(" - ");
                cpu_thr_str.append(this.cpu_thrott_pr[i]).append("%");
            }
            list.add(N270_MON, "CPU freq", cpu_freq_str.toString(), Level.FINE);
            list.add(N270_MON, "CPU throt", cpu_thr_str.toString(), Level.FINE);
        }
    }
}

