/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster.repo;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.comp.RepositoryItemAbstract;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.util.Algorithms;
import tigase.xml.Element;
import tigase.xmpp.BareJID;

public class ClusterRepoItem
extends RepositoryItemAbstract {
    public static final String CPU_USAGE_ATTR = "cpu";
    public static final String CPU_USAGE_LABEL = "CPU usage";
    public static final String HOSTNAME_ATTR = "host";
    public static final String HOSTNAME_LABEL = "Hostname";
    public static final String LAST_UPDATE_ATTR = "updated";
    public static final String LAST_UPDATE_LABEL = "Last update";
    public static final String MEM_USAGE_ATTR = "mem";
    public static final String MEM_USAGE_LABEL = "Memory usage";
    public static final String PASSWORD_ATTR = "passwd";
    public static final String PASSWORD_LABEL = "Password";
    public static final String PASSWORD_PROP_VAL = "someSecret";
    public static final String PORT_NO_ATTR = "port";
    public static final String PORT_NO_LABEL = "Port number";
    public static final int PORT_NO_PROP_VAL = 5277;
    public static final String REPO_ITEM_ELEM_NAME = "item";
    private static final Logger log = Logger.getLogger(ClusterRepoItem.class.getName());
    private float cpuUsage = 0.0f;
    private String hostname = null;
    private long lastUpdate = 0L;
    private float memUsage = 0.0f;
    private String password = Algorithms.sha256(UUID.randomUUID().toString());
    private int portNo = 5277;

    @Override
    public void addCommandFields(Packet packet) {
        Command.addFieldValue(packet, HOSTNAME_LABEL, this.hostname != null ? this.hostname : "");
        Command.addFieldValue(packet, PASSWORD_LABEL, this.password != null ? this.password : "");
        Command.addFieldValue(packet, PORT_NO_LABEL, this.portNo > 0 ? "" + this.portNo : "");
        Command.addFieldValue(packet, LAST_UPDATE_LABEL, "" + new Date(this.lastUpdate));
        Command.addFieldValue(packet, CPU_USAGE_LABEL, "" + this.cpuUsage);
        Command.addFieldValue(packet, MEM_USAGE_LABEL, "" + this.memUsage);
        super.addCommandFields(packet);
    }

    @Override
    public void initFromCommand(Packet packet) {
        super.initFromCommand(packet);
        this.hostname = Command.getFieldValue(packet, HOSTNAME_LABEL);
        this.password = Command.getFieldValue(packet, PASSWORD_LABEL);
        String tmp = Command.getFieldValue(packet, LAST_UPDATE_LABEL);
        if (tmp != null && !tmp.isEmpty()) {
            try {
                this.lastUpdate = DateFormat.getInstance().parse(tmp).getTime();
            }
            catch (ParseException ex) {
                this.lastUpdate = System.currentTimeMillis();
            }
        }
        if ((tmp = Command.getFieldValue(packet, PORT_NO_LABEL)) != null && !tmp.isEmpty()) {
            this.portNo = this.parsePortNo(tmp);
        }
        if ((tmp = Command.getFieldValue(packet, CPU_USAGE_LABEL)) != null && !tmp.isEmpty()) {
            this.cpuUsage = Float.parseFloat(tmp);
        }
        if ((tmp = Command.getFieldValue(packet, MEM_USAGE_LABEL)) != null && !tmp.isEmpty()) {
            this.memUsage = Float.parseFloat(tmp);
        }
    }

    @Override
    public void initFromElement(Element elem) {
        if (elem.getName() != REPO_ITEM_ELEM_NAME) {
            throw new IllegalArgumentException("Incorrect element name, expected: item");
        }
        super.initFromElement(elem);
        this.hostname = elem.getAttributeStaticStr(HOSTNAME_ATTR);
        this.password = elem.getAttributeStaticStr(PASSWORD_ATTR);
        this.portNo = this.parsePortNo(elem.getAttributeStaticStr(PORT_NO_ATTR));
        this.lastUpdate = Long.parseLong(elem.getAttributeStaticStr(LAST_UPDATE_ATTR));
        this.cpuUsage = Float.parseFloat(elem.getAttributeStaticStr(CPU_USAGE_ATTR));
        this.memUsage = Float.parseFloat(elem.getAttributeStaticStr(MEM_USAGE_ATTR));
    }

    @Override
    public void initFromPropertyString(String propString) {
        String[] props = propString.split(":");
        if (props.length > 0) {
            this.hostname = BareJID.parseJID(props[0])[1];
        }
        if (props.length > 1 && !props[1].trim().isEmpty()) {
            this.password = props[1];
        }
        if (props.length > 2) {
            this.portNo = this.parsePortNo(props[2]);
        }
        if (props.length > 3) {
            this.lastUpdate = Long.parseLong(props[3]);
        }
        if (props.length > 4) {
            this.cpuUsage = Float.parseFloat(props[4]);
        }
        if (props.length > 5) {
            this.memUsage = Float.parseFloat(props[5]);
        }
    }

    @Override
    public Element toElement() {
        Element elem = super.toElement();
        elem.addAttribute(HOSTNAME_ATTR, this.hostname);
        elem.addAttribute(PASSWORD_ATTR, this.password);
        elem.addAttribute(PORT_NO_ATTR, "" + this.portNo);
        elem.addAttribute(LAST_UPDATE_ATTR, "" + this.lastUpdate);
        elem.addAttribute(CPU_USAGE_ATTR, "" + this.cpuUsage);
        elem.addAttribute(MEM_USAGE_ATTR, "" + this.memUsage);
        return elem;
    }

    @Override
    public String toPropertyString() {
        return this.hostname + ":" + this.password + ":" + this.portNo + ":" + this.lastUpdate + ":" + this.cpuUsage + ":" + this.memUsage;
    }

    public String toString() {
        return this.toPropertyString();
    }

    public float getCpuUsage() {
        return this.cpuUsage;
    }

    @Override
    public String getElemName() {
        return REPO_ITEM_ELEM_NAME;
    }

    public String getHostname() {
        return this.hostname;
    }

    @Override
    public String getKey() {
        return this.hostname;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public float getMemUsage() {
        return this.memUsage;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPortNo() {
        return this.portNo;
    }

    protected void setCpuUsage(float cpuUsage) {
        this.cpuUsage = cpuUsage;
    }

    protected void setHostname(String hostname) {
        this.hostname = hostname;
    }

    protected void setLastUpdate(long update) {
        this.lastUpdate = update;
    }

    protected void setMemUsage(float memUsage) {
        this.memUsage = memUsage;
    }

    protected void setPassword(String password) {
        this.password = password;
    }

    protected void setPort(int port) {
        this.portNo = port;
    }

    private int parsePortNo(String input) {
        int result;
        try {
            result = Integer.parseInt(input);
        }
        catch (Exception e) {
            result = 5277;
            log.log(Level.WARNING, "Incorrect port number, can't parse: {0}", input);
        }
        return result;
    }
}

