/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import tigase.auth.AuthRepositoryAware;
import tigase.auth.DomainAware;
import tigase.auth.callbacks.VerifyPasswordCallback;
import tigase.db.AuthRepository;
import tigase.xmpp.BareJID;

public class AuthRepoPlainCallbackHandler
implements CallbackHandler,
AuthRepositoryAware,
DomainAware {
    protected String domain;
    protected BareJID jid = null;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    protected AuthRepository repo;

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "Callback: {0}", callbacks[i].getClass().getSimpleName());
            }
            this.handleCallback(callbacks[i]);
        }
    }

    protected void handleAuthorizeCallback(AuthorizeCallback authCallback) {
        String authenId = authCallback.getAuthenticationID();
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "AuthorizeCallback: authenId: {0}", authenId);
        }
        String authorId = authCallback.getAuthorizationID();
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "AuthorizeCallback: authorId: {0}", authorId);
        }
        if (authenId.equals(authorId)) {
            authCallback.setAuthorized(true);
        }
    }

    protected void handleCallback(Callback callback) throws UnsupportedCallbackException, IOException {
        if (callback instanceof RealmCallback) {
            this.handleRealmCallback((RealmCallback)callback);
        } else if (callback instanceof NameCallback) {
            this.handleNameCallback((NameCallback)callback);
        } else if (callback instanceof VerifyPasswordCallback) {
            this.handleVerifyPasswordCallback((VerifyPasswordCallback)callback);
        } else if (callback instanceof AuthorizeCallback) {
            this.handleAuthorizeCallback((AuthorizeCallback)callback);
        } else {
            throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
        }
    }

    protected void handleNameCallback(NameCallback nc) throws IOException {
        String user_name = nc.getDefaultName();
        this.jid = BareJID.bareJIDInstanceNS(user_name, this.domain);
        nc.setName(this.jid.toString());
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "NameCallback: {0}", user_name);
        }
    }

    protected void handleRealmCallback(RealmCallback rc) throws IOException {
        String realm = this.domain;
        if (realm != null) {
            rc.setText(realm);
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "RealmCallback: {0}", realm);
        }
    }

    protected void handleVerifyPasswordCallback(VerifyPasswordCallback pc) throws IOException {
        String passwd = pc.getPassword();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("protocol", "nonsasl");
            map.put("user-id", this.jid);
            map.put("password", passwd);
            map.put("realm", this.jid.getDomain());
            map.put("server-name", this.jid.getDomain());
            pc.setVerified(this.repo.otherAuth(map));
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "VerifyPasswordCallback: {0}", "******");
            }
        }
        catch (Exception e) {
            pc.setVerified(false);
            throw new IOException("Password verification problem.", e);
        }
    }

    @Override
    public void setAuthRepository(AuthRepository repo) {
        this.repo = repo;
    }

    @Override
    public void setDomain(String domain) {
        this.domain = domain;
    }
}

