/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.cached;

import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.pubsub.repository.RepositoryException;
import tigase.xml.Element;
import tigase.xmpp.BareJID;

class Items<T>
implements IItems {
    private static final Logger log = Logger.getLogger(Items.class.getName());
    private final IPubSubDAO<T> dao;
    private final T nodeId;
    private final String nodeName;
    private final BareJID serviceJid;

    public Items(T nodeId, BareJID serviceJid, String nodeName, IPubSubDAO dao) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Constructing Items, serviceJid: {0}, nodeName: {1}, nodeId: {2}, dao: {3}", new Object[]{serviceJid, nodeName, nodeId, dao});
        }
        this.nodeId = nodeId;
        this.dao = dao;
        this.nodeName = nodeName;
        this.serviceJid = serviceJid;
    }

    @Override
    public void deleteItem(String id) throws RepositoryException {
        this.dao.deleteItem(this.serviceJid, this.nodeId, id);
    }

    @Override
    public Element getItem(String id) throws RepositoryException {
        return this.dao.getItem(this.serviceJid, this.nodeId, id);
    }

    @Override
    public Date getItemCreationDate(String id) throws RepositoryException {
        return this.dao.getItemCreationDate(this.serviceJid, this.nodeId, id);
    }

    @Override
    public String[] getItemsIds() throws RepositoryException {
        return this.dao.getItemsIds(this.serviceJid, this.nodeId);
    }

    @Override
    public String[] getItemsIdsSince(Date since) throws RepositoryException {
        return this.dao.getItemsIdsSince(this.serviceJid, this.nodeId, since);
    }

    @Override
    public List<IItems.ItemMeta> getItemsMeta() throws RepositoryException {
        return this.dao.getItemsMeta(this.serviceJid, this.nodeId, this.nodeName);
    }

    @Override
    public Date getItemUpdateDate(String id) throws RepositoryException {
        return this.dao.getItemUpdateDate(this.serviceJid, this.nodeId, id);
    }

    @Override
    public void writeItem(long timeInMilis, String id, String publisher, Element item) throws RepositoryException {
        this.dao.writeItem(this.serviceJid, this.nodeId, timeInMilis, id, publisher, item);
    }
}

