/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import tigase.pubsub.Affiliation;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.xmpp.BareJID;

public abstract class NodeAffiliations
implements IAffiliations {
    protected static final String DELIMITER = ";";
    protected final ConcurrentMap<BareJID, UsersAffiliation> affs = new ConcurrentHashMap<BareJID, UsersAffiliation>(16, 0.9f, 8);
    private boolean changed = false;

    public static tigase.pubsub.repository.cached.NodeAffiliations create(String data) {
        tigase.pubsub.repository.cached.NodeAffiliations a2 = new tigase.pubsub.repository.cached.NodeAffiliations();
        try {
            a2.parse(data);
            return a2;
        }
        catch (Exception e) {
            return new tigase.pubsub.repository.cached.NodeAffiliations();
        }
    }

    public static tigase.pubsub.repository.cached.NodeAffiliations create(Queue<UsersAffiliation> data) {
        tigase.pubsub.repository.cached.NodeAffiliations a2 = new tigase.pubsub.repository.cached.NodeAffiliations();
        if (data == null) {
            return a2;
        }
        a2.init(data);
        return a2;
    }

    protected NodeAffiliations() {
    }

    @Override
    public void addAffiliation(BareJID bareJid, Affiliation affiliation) {
        UsersAffiliation a2 = new UsersAffiliation(bareJid, affiliation);
        this.affs.put(bareJid, a2);
        this.changed = true;
    }

    @Override
    public void changeAffiliation(BareJID bareJid, Affiliation affiliation) {
        UsersAffiliation a2 = this.get(bareJid);
        if (a2 != null) {
            a2.setAffiliation(affiliation);
            this.changed = true;
        } else {
            a2 = new UsersAffiliation(bareJid, affiliation);
            this.affs.put(bareJid, a2);
            this.changed = true;
        }
    }

    public NodeAffiliations clone() throws CloneNotSupportedException {
        tigase.pubsub.repository.cached.NodeAffiliations clone = new tigase.pubsub.repository.cached.NodeAffiliations();
        for (UsersAffiliation a2 : this.affs.values()) {
            clone.affs.put(a2.getJid(), a2.clone());
        }
        clone.changed = this.changed;
        return clone;
    }

    protected UsersAffiliation get(BareJID bareJid) {
        return (UsersAffiliation)this.affs.get(bareJid);
    }

    @Override
    public UsersAffiliation[] getAffiliations() {
        return this.affs.values().toArray(new UsersAffiliation[0]);
    }

    public Map<BareJID, UsersAffiliation> getAffiliationsMap() {
        return this.affs;
    }

    @Override
    public UsersAffiliation getSubscriberAffiliation(BareJID bareJid) {
        UsersAffiliation a2 = this.get(bareJid);
        if (a2 == null) {
            a2 = new UsersAffiliation(bareJid, Affiliation.none);
        }
        return a2;
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    public void parse(String data) {
        String[] tokens = data.split(DELIMITER);
        this.affs.clear();
        int c = 0;
        BareJID jid = null;
        String state = null;
        for (String t : tokens) {
            if (c == 1) {
                state = t;
                ++c;
            } else if (c == 0) {
                jid = BareJID.bareJIDInstanceNS((String)t);
                ++c;
            }
            if (c != 2) continue;
            UsersAffiliation b = new UsersAffiliation(jid, Affiliation.valueOf(state));
            this.affs.put(jid, b);
            jid = null;
            state = null;
            c = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceBy(IAffiliations nodeAffiliations) {
        ConcurrentMap<BareJID, UsersAffiliation> concurrentMap = this.affs;
        synchronized (concurrentMap) {
            if (nodeAffiliations instanceof NodeAffiliations) {
                NodeAffiliations na = (NodeAffiliations)nodeAffiliations;
                this.changed = true;
                this.affs.clear();
                for (UsersAffiliation a2 : na.affs.values()) {
                    this.affs.put(a2.getJid(), a2);
                }
            }
        }
    }

    public void resetChangedFlag() {
        this.changed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String serialize() {
        StringBuilder sb = new StringBuilder();
        ConcurrentMap<BareJID, UsersAffiliation> concurrentMap = this.affs;
        synchronized (concurrentMap) {
            for (UsersAffiliation a2 : this.affs.values()) {
                if (a2.getAffiliation() == Affiliation.none) continue;
                sb.append(a2.getJid());
                sb.append(DELIMITER);
                sb.append(a2.getAffiliation().name());
                sb.append(DELIMITER);
            }
        }
        return sb.toString();
    }
}

