/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules.ext.presence;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component2.PacketWriter;
import tigase.component2.eventbus.Event;
import tigase.component2.eventbus.EventHandler;
import tigase.component2.eventbus.EventType;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.modules.PresenceCollectorModule;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class PresencePerNodeExtension {
    public static final String XMLNS_EXTENSION = "tigase:pubsub:1";
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    private final Map<BareJID, Map<String, Set<JID>>> occupants = new ConcurrentHashMap<BareJID, Map<String, Set<JID>>>();
    private final PresenceCollectorModule.PresenceChangeHandler presenceChangeHandler = new PresenceCollectorModule.PresenceChangeHandler(){

        @Override
        public void onPresenceChange(Packet packet) {
            PresencePerNodeExtension.this.process(packet);
        }
    };
    private final Map<BareJID, Map<String, Map<BareJID, Map<String, Packet>>>> presences = new ConcurrentHashMap<BareJID, Map<String, Map<BareJID, Map<String, Packet>>>>();
    private PubSubConfig pubsubContext;

    public PresencePerNodeExtension(PubSubConfig config, PacketWriter packetWriter) {
        this.pubsubContext = config;
        this.pubsubContext.getEventBus().addHandler(PresenceCollectorModule.PresenceChangeHandler.PresenceChangeEvent.TYPE, this.presenceChangeHandler);
    }

    void addJidToOccupants(BareJID serviceJID, String nodeName, JID jid) {
        Set<JID> occs;
        Map<String, Set<JID>> services = this.occupants.get(serviceJID);
        if (services == null) {
            services = new ConcurrentHashMap<String, Set<JID>>();
            this.occupants.put(serviceJID, services);
        }
        if ((occs = services.get(nodeName)) == null) {
            occs = new HashSet<JID>();
            services.put(nodeName, occs);
        }
        occs.add(jid);
    }

    public void addLoginToNodeHandler(LoginToNodeHandler handler) {
        this.pubsubContext.getEventBus().addHandler(LoginToNodeHandler.LoginToNodeEvent.TYPE, handler);
    }

    public void addLogoffFromNodeHandler(LogoffFromNodeHandler handler) {
        this.pubsubContext.getEventBus().addHandler(LogoffFromNodeHandler.LogoffFromNodeEvent.TYPE, handler);
    }

    void addPresence(BareJID serviceJID, String nodeName, Packet packet) {
        Map<String, Packet> nodesPresence;
        Map<BareJID, Map<String, Packet>> services;
        JID sender = packet.getStanzaFrom();
        Map<String, Map<BareJID, Map<String, Packet>>> resources = this.presences.get(sender.getBareJID());
        if (resources == null) {
            resources = new ConcurrentHashMap<String, Map<BareJID, Map<String, Packet>>>();
            this.presences.put(sender.getBareJID(), resources);
        }
        if ((services = resources.get(sender.getResource())) == null) {
            services = new ConcurrentHashMap<BareJID, Map<String, Packet>>();
            resources.put(sender.getResource(), services);
        }
        if ((nodesPresence = services.get(serviceJID)) == null) {
            nodesPresence = new ConcurrentHashMap<String, Packet>();
            services.put(serviceJID, nodesPresence);
        }
        boolean isUpdate = nodesPresence.containsKey(nodeName);
        nodesPresence.put(nodeName, packet);
        this.addJidToOccupants(serviceJID, nodeName, sender);
        Event event = isUpdate ? new UpdatePresenceHandler.UpdatePresenceEvent(serviceJID, nodeName, packet) : new LoginToNodeHandler.LoginToNodeEvent(serviceJID, nodeName, packet);
        this.pubsubContext.getEventBus().fire(event, this);
    }

    public void addUpdatePresenceHandler(UpdatePresenceHandler handler) {
        this.pubsubContext.getEventBus().addHandler(UpdatePresenceHandler.UpdatePresenceEvent.TYPE, handler);
    }

    public Collection<JID> getNodeOccupants(BareJID serviceJID, String nodeName) {
        Map<String, Set<JID>> services = this.occupants.get(serviceJID);
        if (services == null) {
            return Collections.emptyList();
        }
        Set<JID> occs = services.get(nodeName);
        if (occs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(occs);
    }

    public Collection<String> getNodes(BareJID serviceJID, JID occupantJID) {
        Map<String, Map<BareJID, Map<String, Packet>>> resources = this.presences.get(occupantJID.getBareJID());
        if (resources == null) {
            return Collections.emptyList();
        }
        Map<BareJID, Map<String, Packet>> x = resources.get(occupantJID.getResource());
        if (x == null) {
            return Collections.emptyList();
        }
        Map<String, Packet> p = x.get(serviceJID);
        return Collections.unmodifiableCollection(p.keySet());
    }

    public Collection<Packet> getPresence(BareJID serviceJID, String nodeName, BareJID occupantJID) {
        Map<String, Map<BareJID, Map<String, Packet>>> resources = this.presences.get(occupantJID);
        if (resources == null) {
            return Collections.emptyList();
        }
        HashSet<Packet> prs = new HashSet<Packet>();
        for (Map<BareJID, Map<String, Packet>> services : resources.values()) {
            Map<String, Packet> nodes = services.get(serviceJID);
            if (nodes == null || !nodes.containsKey(nodeName)) continue;
            prs.add(nodes.get(nodeName));
        }
        return prs;
    }

    public Packet getPresence(BareJID serviceJID, String nodeName, JID occupantJID) {
        Map<String, Map<BareJID, Map<String, Packet>>> resources = this.presences.get(occupantJID.getBareJID());
        if (resources == null) {
            return null;
        }
        Map<BareJID, Map<String, Packet>> services = resources.get(occupantJID.getResource());
        if (services == null) {
            return null;
        }
        Map<String, Packet> nodes = services.get(serviceJID);
        if (nodes == null) {
            return null;
        }
        return nodes.get(nodeName);
    }

    private void intProcessLogoffFrom(BareJID serviceJID, JID sender, Map<String, Packet> nodes, Packet presenceStanza) {
        if (nodes == null) {
            return;
        }
        for (String node : nodes.keySet()) {
            this.removeJidFromOccupants(serviceJID, node, sender);
            LogoffFromNodeHandler.LogoffFromNodeEvent event = new LogoffFromNodeHandler.LogoffFromNodeEvent(serviceJID, node, sender, presenceStanza);
            this.pubsubContext.getEventBus().fire(event, this);
        }
    }

    protected void process(Packet packet) {
        block4: {
            BareJID serviceJID;
            StanzaType type;
            block2: {
                String nodeName;
                block3: {
                    type = packet.getType();
                    serviceJID = packet.getStanzaTo().getBareJID();
                    Element pubsubExtElement = packet.getElement().getChild("pubsub", XMLNS_EXTENSION);
                    if (pubsubExtElement == null) break block2;
                    nodeName = pubsubExtElement.getAttributeStaticStr("node");
                    if (type != null && type != StanzaType.available) break block3;
                    this.addPresence(serviceJID, nodeName, packet);
                    break block4;
                }
                if (StanzaType.unavailable != type) break block4;
                this.removePresence(serviceJID, nodeName, packet.getStanzaFrom(), packet);
                break block4;
            }
            if (type == StanzaType.unavailable) {
                Collection<String> nds = this.getNodes(serviceJID, packet.getStanzaFrom());
                for (String nodeName : nds) {
                    this.removePresence(serviceJID, nodeName, packet.getStanzaFrom(), packet);
                }
            }
        }
    }

    void removeJidFromOccupants(BareJID serviceJID, String node, JID jid) {
        Map<String, Set<JID>> services = this.occupants.get(serviceJID);
        if (services != null) {
            Set<JID> occs = services.get(node);
            if (occs != null) {
                occs.remove(jid);
                if (occs.isEmpty()) {
                    this.occupants.remove(node);
                }
            }
            if (services.isEmpty()) {
                this.occupants.remove(serviceJID);
            }
        }
    }

    public void removeLoginToNodeHandler(LoginToNodeHandler handler) {
        this.pubsubContext.getEventBus().remove(LoginToNodeHandler.LoginToNodeEvent.TYPE, handler);
    }

    public void removeLogoffFromNodeHandler(LogoffFromNodeHandler handler) {
        this.pubsubContext.getEventBus().remove(LogoffFromNodeHandler.LogoffFromNodeEvent.TYPE, handler);
    }

    void removePresence(BareJID serviceJID, String nodeName, JID sender, Packet presenceStanza) {
        if (sender.getResource() == null) {
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Skip processing presence from BareJID " + sender);
            }
        } else {
            Map<String, Map<BareJID, Map<String, Packet>>> resources = this.presences.get(sender.getBareJID());
            if (resources != null) {
                Map<BareJID, Map<String, Packet>> services = resources.get(sender.getResource());
                if (services != null) {
                    Map<String, Packet> nodes = services.get(serviceJID);
                    if (nodes != null && nodeName != null) {
                        nodes.remove(nodeName);
                        this.removeJidFromOccupants(serviceJID, nodeName, sender);
                        LogoffFromNodeHandler.LogoffFromNodeEvent event = new LogoffFromNodeHandler.LogoffFromNodeEvent(serviceJID, nodeName, sender, presenceStanza);
                        this.pubsubContext.getEventBus().fire(event, this);
                        if (nodes.isEmpty()) {
                            services.remove(serviceJID);
                        }
                    } else if (nodes != null) {
                        Map<String, Packet> removed = services.remove(serviceJID);
                        this.intProcessLogoffFrom(serviceJID, sender, removed, presenceStanza);
                    }
                    if (services.isEmpty()) {
                        resources.remove(sender.getResource());
                    }
                }
                if (resources.isEmpty()) {
                    this.presences.remove(sender.getBareJID());
                }
            }
        }
    }

    public void removeUpdatePresenceHandler(UpdatePresenceHandler handler) {
        this.pubsubContext.getEventBus().remove(UpdatePresenceHandler.UpdatePresenceEvent.TYPE, handler);
    }

    public static interface UpdatePresenceHandler
    extends EventHandler {
        public void onPresenceUpdate(BareJID var1, String var2, JID var3, Packet var4);

        public static class UpdatePresenceEvent
        extends Event<UpdatePresenceHandler> {
            public static final EventType<UpdatePresenceHandler> TYPE = new EventType();
            private final String node;
            private final JID occupantJID;
            private final Packet presenceStanza;
            private final BareJID serviceJID;

            public UpdatePresenceEvent(BareJID serviceJID, String node, Packet presenceStanza) {
                super(TYPE);
                this.occupantJID = presenceStanza.getStanzaFrom();
                this.node = node;
                this.presenceStanza = presenceStanza;
                this.serviceJID = serviceJID;
            }

            @Override
            protected void dispatch(UpdatePresenceHandler handler) {
                handler.onPresenceUpdate(this.serviceJID, this.node, this.occupantJID, this.presenceStanza);
            }

            public String getNode() {
                return this.node;
            }

            public JID getOccupantJID() {
                return this.occupantJID;
            }

            public Packet getPresenceStanza() {
                return this.presenceStanza;
            }

            public BareJID getServiceJID() {
                return this.serviceJID;
            }
        }
    }

    public static interface LogoffFromNodeHandler
    extends EventHandler {
        public void onLogoffFromNode(BareJID var1, String var2, JID var3, Packet var4);

        public static class LogoffFromNodeEvent
        extends Event<LogoffFromNodeHandler> {
            public static final EventType<LogoffFromNodeHandler> TYPE = new EventType();
            private final String node;
            private final JID occupantJID;
            private final Packet presenceStanza;
            private final BareJID serviceJID;

            public LogoffFromNodeEvent(BareJID serviceJID, String node, JID occupandJID, Packet presenceStanza) {
                super(TYPE);
                this.occupantJID = occupandJID;
                this.node = node;
                this.presenceStanza = presenceStanza;
                this.serviceJID = serviceJID;
            }

            @Override
            protected void dispatch(LogoffFromNodeHandler handler) {
                handler.onLogoffFromNode(this.serviceJID, this.node, this.occupantJID, this.presenceStanza);
            }

            public String getNode() {
                return this.node;
            }

            public JID getOccupantJID() {
                return this.occupantJID;
            }

            public Packet getPresenceStanza() {
                return this.presenceStanza;
            }

            public BareJID getServiceJID() {
                return this.serviceJID;
            }
        }
    }

    public static interface LoginToNodeHandler
    extends EventHandler {
        public void onLoginToNode(BareJID var1, String var2, JID var3, Packet var4);

        public static class LoginToNodeEvent
        extends Event<LoginToNodeHandler> {
            public static final EventType<LoginToNodeHandler> TYPE = new EventType();
            private final String node;
            private final JID occupantJID;
            private final Packet presenceStanza;
            private final BareJID serviceJID;

            public LoginToNodeEvent(BareJID serviceJID, String node, Packet presenceStanza) {
                super(TYPE);
                this.occupantJID = presenceStanza.getStanzaFrom();
                this.node = node;
                this.presenceStanza = presenceStanza;
                this.serviceJID = serviceJID;
            }

            @Override
            protected void dispatch(LoginToNodeHandler handler) {
                handler.onLoginToNode(this.serviceJID, this.node, this.occupantJID, this.presenceStanza);
            }

            public String getNode() {
                return this.node;
            }

            public JID getOccupantJID() {
                return this.occupantJID;
            }

            public Packet getPresenceStanza() {
                return this.presenceStanza;
            }

            public BareJID getServiceJID() {
                return this.serviceJID;
            }
        }
    }
}

