/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules.commands;

import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class LoadTestGenerator
implements Runnable {
    private final AbstractMessageReceiver component;
    private int counter = 0;
    private final long delay;
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    private String nodeName;
    private JID packetFromJid;
    private Element payload;
    private BareJID publisher;
    private BareJID serviceJid;
    private final long testTime;
    private final boolean useBlockingMethod;

    public LoadTestGenerator(AbstractMessageReceiver component, BareJID serviceJid, String node, BareJID publisher, long time, long frequency, int messageLength, boolean useBlockingMethod) {
        this.component = component;
        this.serviceJid = serviceJid;
        this.nodeName = node;
        this.publisher = publisher;
        this.testTime = time;
        this.useBlockingMethod = useBlockingMethod;
        this.delay = (long)(1.0 / (double)frequency * 1000.0);
        this.packetFromJid = JID.jidInstanceNS((String)"sess-man", (String)serviceJid.getDomain(), null);
        String x = "";
        for (int i = 0; i < messageLength; ++i) {
            x = x + "a";
        }
        this.payload = new Element("payload", x);
    }

    @Override
    public void run() {
        try {
            long cst;
            long testStartTime = System.currentTimeMillis();
            long testEndTime = testStartTime + this.testTime * 1000L;
            while (testEndTime >= (cst = System.currentTimeMillis())) {
                long fix;
                long now;
                long dt;
                long sleepTime;
                ++this.counter;
                Element item = new Element("item", new String[]{"id"}, new String[]{this.counter + "-" + testEndTime});
                item.addChild((XMLNodeIfc)this.payload);
                Element iq = new Element("iq", new String[]{"type", "from", "to", "id"}, new String[]{"set", this.publisher.toString(), this.serviceJid.toString(), "pub-" + this.counter + "-" + testEndTime});
                Element pubsub = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
                iq.addChild((XMLNodeIfc)pubsub);
                Element publish = new Element("publish", new String[]{"node"}, new String[]{this.nodeName});
                pubsub.addChild((XMLNodeIfc)publish);
                publish.addChild((XMLNodeIfc)item);
                Packet p = Packet.packetInstance((Element)iq);
                p.setXMLNS("jabber:client");
                p.setPacketFrom(this.packetFromJid);
                if (this.component != null) {
                    if (this.useBlockingMethod) {
                        this.component.addPacket(p);
                    } else {
                        this.component.addPacketNB(p);
                    }
                }
                if ((sleepTime = this.delay - (dt = (now = System.currentTimeMillis()) - cst) + (fix = testStartTime + this.delay * (long)(this.counter - 1) - now)) <= 0L) continue;
                Thread.sleep(sleepTime);
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "LoadTest generator stopped", e);
        }
    }
}

