/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.Map;
import tigase.component2.PacketWriter;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.Affiliation;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.BareJID;

public class RetrieveAffiliationsModule
extends AbstractPubSubModule {
    private static final Criteria CRIT = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub")).add((Criteria)ElementCriteria.name((String)"affiliations"));

    public RetrieveAffiliationsModule(PubSubConfig config, PacketWriter packetWriter) {
        super(config, packetWriter);
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#retrieve-affiliations", "http://jabber.org/protocol/pubsub#publisher-affiliation", "http://jabber.org/protocol/pubsub#outcast-affiliation", "http://jabber.org/protocol/pubsub#member-affiliation"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public void process(Packet packet) throws PubSubException {
        try {
            BareJID serviceJid = packet.getStanzaTo().getBareJID();
            Element pubsub = packet.getElement().getChild("pubsub", "http://jabber.org/protocol/pubsub");
            Element affiliations = pubsub.getChild("affiliations");
            BareJID senderBareJid = packet.getStanzaFrom().getBareJID();
            Element pubsubResult = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
            Packet result = packet.okResult(pubsubResult, 0);
            Element affiliationsResult = new Element("affiliations");
            pubsubResult.addChild((XMLNodeIfc)affiliationsResult);
            IPubSubDAO directRepo = this.getRepository().getPubSubDAO();
            Map<String, UsersAffiliation> userAffiliations = directRepo.getUserAffiliations(serviceJid, senderBareJid);
            for (Map.Entry<String, UsersAffiliation> entry : userAffiliations.entrySet()) {
                Affiliation affiliation = entry.getValue().getAffiliation();
                Element a2 = new Element("affiliation", new String[]{"node", "affiliation"}, new String[]{entry.getKey(), affiliation.name()});
                affiliationsResult.addChild((XMLNodeIfc)a2);
            }
            this.packetWriter.write(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

