/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayDeque;
import java.util.Arrays;
import tigase.component2.PacketWriter;
import tigase.component2.exceptions.ComponentException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.criteria.Or;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.PubSubConfig;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.JID;
import tigase.xmpp.impl.PresenceCapabilitiesManager;

public class CapsModule
extends AbstractPubSubModule {
    private static final Criteria CRIT = new Or(new Criteria[]{ElementCriteria.nameType((String)"iq", (String)"result").add((Criteria)ElementCriteria.name((String)"query", (String)"http://jabber.org/protocol/disco#info")), ElementCriteria.nameType((String)"iq", (String)"error").add((Criteria)ElementCriteria.name((String)"query", (String)"http://jabber.org/protocol/disco#info"))});
    private static String[] FEATURES = new String[0];

    public CapsModule(PubSubConfig config, PacketWriter packetWriter) {
        super(config, packetWriter);
    }

    @Override
    public String[] getFeatures() {
        return FEATURES;
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        PresenceCapabilitiesManager.processCapsQueryResponse((Packet)packet);
    }

    public String[] processPresence(Packet packet) {
        Object[] caps = null;
        Element c = packet.getElement().getChildStaticStr("c");
        if (c != null) {
            JID jid = packet.getStanzaFrom();
            caps = PresenceCapabilitiesManager.processPresence((Element)c);
            if (caps != null) {
                Arrays.sort(caps);
            }
            ArrayDeque<Packet> results = new ArrayDeque<Packet>();
            PresenceCapabilitiesManager.prepareCapsQueries((JID)this.config.getComponentJID(), (JID)jid, (String[])caps, results);
            this.packetWriter.write(results);
        }
        return caps;
    }
}

