/*
 * Decompiled with CFR 0.152.
 */
package tigase.component2.exceptions;

import tigase.server.Packet;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;

public class ComponentException
extends Exception {
    private static final long serialVersionUID = 1L;
    private Authorization errorCondition;
    private String text;

    public ComponentException(Authorization errorCondition) {
        this(errorCondition, null, null);
    }

    public ComponentException(Authorization errorCondition, String text) {
        this(errorCondition, text, null);
    }

    public ComponentException(Authorization errorCondition, String text, String message) {
        super(message);
        this.errorCondition = errorCondition;
        this.text = text;
    }

    public String getCode() {
        return String.valueOf(this.errorCondition.getErrorCode());
    }

    public Authorization getErrorCondition() {
        return this.errorCondition;
    }

    protected String getErrorMessagePrefix() {
        return "XMPP error condition: ";
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getErrorMessagePrefix());
        sb.append(this.errorCondition.getCondition()).append(" ");
        if (this.text != null) {
            sb.append("with message: \"").append(this.text).append("\" ");
        }
        if (super.getMessage() != null) {
            sb.append("(").append(super.getMessage()).append(") ");
        }
        return sb.toString();
    }

    public String getMessageWithPosition() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessage());
        StackTraceElement[] stack = this.getStackTrace();
        if (stack.length > 0) {
            sb.append("generated by ");
            sb.append(this.getStackTrace()[0].toString());
            sb.append(" ");
        }
        return sb.toString();
    }

    public String getName() {
        return this.errorCondition.getCondition();
    }

    public String getText() {
        return this.text;
    }

    public String getType() {
        return this.errorCondition.getErrorType();
    }

    public Packet makeElement(Packet packet, boolean insertOriginal) throws PacketErrorTypeException {
        Packet result = this.errorCondition.getResponseMessage(packet, this.text, insertOriginal);
        return result;
    }
}

