/*
 * Decompiled with CFR 0.152.
 */
package tigase.licence;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.strategy.ClusteringStrategyIfc;
import tigase.conf.ConfiguratorAbstract;
import tigase.db.comp.RepositoryItem;
import tigase.licence.Licence;
import tigase.licence.LicenceCheckerUpdateCallbackImpl;
import tigase.licence.LicenceCheckerUpdater;
import tigase.server.XMPPServer;
import tigase.server.cluster.strategy.ConnectionRecordExt;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostManager;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.JID;

public class LicenceCheckerUpdateCallbackImplACS
extends LicenceCheckerUpdateCallbackImpl {
    private final ClusteringStrategyIfc<ConnectionRecordExt> a;
    private static final Logger b = Logger.getLogger(LicenceCheckerUpdateCallbackImplACS.class.getName());

    public LicenceCheckerUpdateCallbackImplACS(String cmpName, ClusteringStrategyIfc<ConnectionRecordExt> strategy) {
        super(cmpName);
        this.a = strategy;
    }

    @Override
    public Element getComponentAdditionalData() {
        Element element = super.getComponentAdditionalData();
        try {
            element.addChild((XMLNodeIfc)new Element("activeUsers", this.b()));
            element.addChild((XMLNodeIfc)new Element("clusterNodesCount", this.a()));
        }
        catch (Exception exception) {
            b.log(Level.SEVERE, "Problem creating StatisticsData", exception);
        }
        return element;
    }

    String a() {
        int n = this.a.getAllNodes().size();
        return String.valueOf(n);
    }

    @Override
    public boolean additionalValidation(Licence lic) {
        try {
            int n;
            String string = lic.getPropertyAsString("vhost-name");
            Integer n2 = lic.getPropertyAsInteger("max-number-acs-nodes");
            if (n2 != null && (n = this.a.getAllNodes().size()) > n2) {
                b.log(Level.WARNING, "Too much ACS nodes.");
                return false;
            }
            if (string != null) {
                JID jID = JID.jidInstanceNS((String)string);
                ConfiguratorAbstract configuratorAbstract = XMPPServer.getConfigurator();
                VHostManager vHostManager = (VHostManager)configuratorAbstract.getComponent("vhost-man");
                List list = vHostManager.getAllVHosts();
                if (!list.contains(jID)) {
                    b.log(Level.WARNING, "Required VHost is not managed by Tigase.");
                    return false;
                }
                VHostItem vHostItem = vHostManager.getVHostItem(jID.getDomain());
                String string2 = vHostManager.getComponentRepository().validateItem((RepositoryItem)vHostItem);
                if (string2 != null) {
                    b.log(Level.WARNING, "Cannot validate vhost " + jID + ": " + string2);
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            b.log(Level.WARNING, "Problem on validating licence", exception);
            return false;
        }
    }

    String b() {
        String string = (String)LicenceCheckerUpdater.stats.getAllStats().getValue("cl-caching-strat/Cached conns");
        return string;
    }
}

