/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor.tasks;

import javax.script.ScriptException;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.Inject;
import tigase.monitor.ConfigurableTask;
import tigase.monitor.TimerTaskService;
import tigase.monitor.tasks.ScriptTask;
import tigase.util.TimerTask;

public class ScriptTimerTask
extends ScriptTask
implements ConfigurableTask {
    private long delay = 1000L;
    private String script;
    private String scriptExtension;
    protected long taskDelay;
    @Inject(bean="timerTaskService")
    private TimerTaskService timerTaskService;
    private final TimerTask worker = new TimerTask(){

        @Override
        public void run() {
            try {
                ScriptTimerTask.super.run(ScriptTimerTask.this.script, ScriptTimerTask.this.scriptExtension);
            }
            catch (ScriptException e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    public Form getCurrentConfiguration() {
        Form f = new Form("form", "Script configuration", null);
        f.addField(Field.fieldTextSingle("delay", String.valueOf(this.delay), "Delay"));
        return f;
    }

    public void run(String script, String scriptExtension, long delay) throws ScriptException {
        this.script = script;
        this.scriptExtension = scriptExtension;
        this.delay = delay;
        this.timerTaskService.addTimerTask(this.worker, 1000L, this.delay);
    }

    @Override
    public void setNewConfiguration(Form form) {
        Long d = form.getAsLong("delay");
        try {
            if (d != this.delay) {
                this.worker.cancel();
                this.delay = d;
                this.timerTaskService.addTimerTask(this.worker, 1000L, this.delay);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

