/*
 * Decompiled with CFR 0.152.
 */
package tigase.component.modules.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import tigase.component.Context;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocCommandManager;
import tigase.component.exceptions.ComponentException;
import tigase.component.modules.AbstractModule;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.JID;

public class AdHocCommandModule<CTX extends Context>
extends AbstractModule<CTX> {
    protected static final String[] COMMAND_PATH = new String[]{"iq", "command"};
    protected static final Criteria CRIT = ElementCriteria.nameType("iq", "set").add(ElementCriteria.name("command", "http://jabber.org/protocol/commands"));
    public static final String ID = "commands";
    public static final String XMLNS = "http://jabber.org/protocol/commands";
    protected AdHocCommandManager commandsManager = new AdHocCommandManager();
    protected ScriptCommandProcessor scriptProcessor;

    public AdHocCommandModule(ScriptCommandProcessor scriptProcessor) {
        this.scriptProcessor = scriptProcessor;
    }

    public List<Element> getCommandListItems(JID senderJid, JID toJid) {
        ArrayList<Element> commandsList = new ArrayList<Element>();
        for (AdHocCommand command2 : this.commandsManager.getAllCommands()) {
            if (!command2.isAllowedFor(senderJid)) continue;
            commandsList.add(new Element("item", new String[]{"jid", "node", "name"}, new String[]{toJid.toString(), command2.getNode(), command2.getName()}));
        }
        List<Element> scriptCommandsList = this.scriptProcessor.getScriptItems(XMLNS, toJid, senderJid);
        if (scriptCommandsList != null) {
            commandsList.addAll(scriptCommandsList);
        }
        return commandsList;
    }

    @Override
    public String[] getFeatures() {
        return new String[]{XMLNS};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    public List<Element> getScriptItems(String node, JID stanzaTo, JID stanzaFrom) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (AdHocCommand c : this.commandsManager.getAllCommands()) {
            if (!c.isAllowedFor(stanzaFrom)) continue;
            Element i = new Element("item", new String[]{"jid", "node", "name"}, new String[]{stanzaTo.toString(), c.getNode(), c.getName()});
            result.add(i);
        }
        List<Element> scripts = this.scriptProcessor.getScriptItems(node, stanzaTo, stanzaFrom);
        if (scripts != null) {
            result.addAll(scripts);
        }
        return result;
    }

    @Override
    public void process(Packet packet) throws ComponentException {
        String node = packet.getAttributeStaticStr(COMMAND_PATH, "node");
        if (this.commandsManager.hasCommand(node)) {
            try {
                this.write(this.commandsManager.process(packet));
            }
            catch (AdHocCommandException e) {
                throw new ComponentException(e.getErrorCondition(), e.getMessage());
            }
        } else {
            this.processScriptAdHoc(packet);
        }
    }

    protected void processScriptAdHoc(Packet packet) {
        ArrayDeque<Packet> results = new ArrayDeque<Packet>();
        if (this.scriptProcessor.processScriptCommand(packet, results)) {
            for (Packet p : results) {
                this.write(p);
            }
        }
    }

    public void register(AdHocCommand command2) {
        this.commandsManager.registerCommand(command2);
    }

    public static interface ScriptCommandProcessor {
        public List<Element> getScriptItems(String var1, JID var2, JID var3);

        public boolean processScriptCommand(Packet var1, Queue<Packet> var2);
    }
}

