/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.jetty;

import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import tigase.http.Activator;
import tigase.http.jetty.AbstractJettyHttpServer;

public class JettyOSGiHttpServer
extends AbstractJettyHttpServer {
    private static final Logger log = Logger.getLogger(JettyOSGiHttpServer.class.getCanonicalName());
    private final BundleContext context;
    private final ConcurrentHashMap<String, ServiceRegistration> registeredContexts = new ConcurrentHashMap();

    public JettyOSGiHttpServer() {
        this.context = Activator.getContext();
    }

    @Override
    protected void deploy(ServletContextHandler ctx) {
        String contextPath = ctx.getContextPath();
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("contextFilePath", "/etc/tigase-http-context.xml");
        ServiceRegistration registration = this.context.registerService(ContextHandler.class.getName(), (Object)ctx, props);
        if (registration == null) {
            log.log(Level.SEVERE, "registration failed for {0}", contextPath);
        }
        this.registeredContexts.put(contextPath, registration);
    }

    @Override
    protected void undeploy(ServletContextHandler ctx) {
        String contextPath = ctx.getContextPath();
        try {
            ServiceRegistration registration = this.registeredContexts.get(contextPath);
            if (registration != null) {
                registration.unregister();
            }
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "exception during unregistration of context = " + contextPath, ctx);
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public void setProperties(Map<String, Object> props) {
    }
}

