/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.jetty;

import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import tigase.http.jetty.JettyOSGiHttpServer;
import tigase.http.jetty.JettyStandaloneHttpServer;
import tigase.osgi.ModulesManager;

public class Activator
implements BundleActivator,
ServiceListener {
    private static final Logger log = Logger.getLogger(Activator.class.getCanonicalName());
    private static BundleContext context;
    private ModulesManager serviceManager;
    private ServiceReference serviceReference;

    public static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext context) throws Exception {
        Activator.context = context;
        context.addServiceListener((ServiceListener)this, "(&(objectClass=" + ModulesManager.class.getName() + "))");
        this.serviceReference = context.getServiceReference(ModulesManager.class.getName());
        if (this.serviceReference != null) {
            this.serviceManager = (ModulesManager)context.getService(this.serviceReference);
            this.registerAddons();
        }
    }

    public void stop(BundleContext bc) throws Exception {
        if (this.serviceManager != null) {
            this.unregisterAddons();
            context.ungetService(this.serviceReference);
            this.serviceManager = null;
            this.serviceReference = null;
        }
    }

    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1) {
            if (this.serviceReference == null) {
                this.serviceReference = event.getServiceReference();
                this.serviceManager = (ModulesManager)context.getService(this.serviceReference);
                this.registerAddons();
            }
        } else if (event.getType() == 4 && this.serviceReference == event.getServiceReference()) {
            this.unregisterAddons();
            context.ungetService(this.serviceReference);
            this.serviceManager = null;
            this.serviceReference = null;
        }
    }

    private void registerAddons() {
        if (this.serviceManager != null) {
            this.serviceManager.registerClass(JettyStandaloneHttpServer.class);
            this.serviceManager.registerClass(JettyOSGiHttpServer.class);
            this.serviceManager.update();
        }
    }

    private void unregisterAddons() {
        if (this.serviceManager != null) {
            this.serviceManager.unregisterClass(JettyStandaloneHttpServer.class);
            this.serviceManager.unregisterClass(JettyOSGiHttpServer.class);
            this.serviceManager.update();
        }
    }
}

