/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.cluster;

import java.util.Map;
import tigase.adhoc.AdHocCommand;
import tigase.adhoc.AdHocCommandException;
import tigase.adhoc.AdHocResponse;
import tigase.adhoc.AdhHocRequest;
import tigase.form.Field;
import tigase.form.Form;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.cluster.ClusterNodeMap;
import tigase.xmpp.Authorization;

public class ViewNodeLoadCommand
implements AdHocCommand {
    private final PubSubConfig a;
    private final ClusterNodeMap b;

    public ViewNodeLoadCommand(PubSubConfig config, ClusterNodeMap nodeMap) {
        this.a = config;
        this.b = nodeMap;
    }

    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        try {
            if (!this.a.isAdmin(request.getSender())) {
                throw new AdHocCommandException(Authorization.FORBIDDEN);
            }
            Form form = new Form("result", "Cluster nodes load", "Statistics of cluster nodes");
            for (Map.Entry<String, Integer> entry : this.b.getClusterNodesLoad().entrySet()) {
                Field field = Field.fieldTextSingle((String)("tigase#node-" + entry.getKey()), (String)entry.getValue().toString(), (String)entry.getKey());
                form.addField(field);
            }
            response.getElements().add(form.getElement());
            response.completeSession();
        }
        catch (AdHocCommandException adHocCommandException) {
            throw adHocCommandException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, exception.getMessage());
        }
    }

    public String getName() {
        return "View cluster load";
    }

    public String getNode() {
        return "cluster-load";
    }
}

