/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.archive.AbstractCriteria;
import tigase.archive.RSM;
import tigase.archive.TagsHelper;
import tigase.archive.TimestampHelper;
import tigase.archive.db.MessageArchiveRepository;
import tigase.conf.ConfigurationException;
import tigase.db.DBInitException;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.osgi.ModulesManagerImpl;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.XMPPException;

public class MessageArchiveComponent
extends AbstractMessageReceiver {
    private static final Logger log = Logger.getLogger(MessageArchiveComponent.class.getCanonicalName());
    private static final String MSG_ARCHIVE_REPO_CLASS_PROP_KEY = "archive-repo-class";
    private static final String MSG_ARCHIVE_REPO_URI_PROP_KEY = "archive-repo-uri";
    private static final boolean DEF_TAGS_SUPPORT_PROP_VAL = false;
    private static final String TAGS_SUPPORT_PROP_KEY = "tags-support";
    private MessageArchiveRepository msg_repo = null;
    private boolean tagsSupport = false;

    public MessageArchiveComponent() {
        this.setName("message-archive");
    }

    public void processPacket(Packet packet) {
        block6: {
            if (packet.getStanzaTo() != null && !this.getComponentId().equals((Object)packet.getStanzaTo())) {
                this.storeMessage(packet);
                return;
            }
            try {
                try {
                    this.processActionPacket(packet);
                }
                catch (XMPPException ex) {
                    if (log.isLoggable(Level.WARNING)) {
                        log.log(Level.WARNING, "internal server while processing packet = " + packet.toString(), ex);
                    }
                    this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, (String)null, true));
                }
            }
            catch (PacketErrorTypeException ex) {
                if (!log.isLoggable(Level.FINEST)) break block6;
                log.log(Level.FINEST, "error with packet in error state - ignoring packet = {0}", packet);
            }
        }
    }

    public void release() {
        super.release();
        if (this.msg_repo != null) {
            this.msg_repo.destroy();
            this.msg_repo = null;
        }
    }

    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map defs = super.getDefaults(params);
        String db_uri = (String)params.get("user-repo-url");
        defs.put(TAGS_SUPPORT_PROP_KEY, false);
        if (db_uri == null) {
            db_uri = (String)params.get("--user-db-uri");
        }
        if (db_uri != null) {
            defs.put(MSG_ARCHIVE_REPO_URI_PROP_KEY, db_uri);
        }
        return defs;
    }

    public String getDiscoDescription() {
        return "Message Archiving (XEP-0136) Support";
    }

    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        block14: {
            try {
                super.setProperties(props);
                if (props.containsKey(TAGS_SUPPORT_PROP_KEY)) {
                    this.tagsSupport = (Boolean)props.get(TAGS_SUPPORT_PROP_KEY);
                }
                if (props.size() == 1) {
                    return;
                }
                HashMap<String, String> repoProps = new HashMap<String, String>(4);
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    repoProps.put(entry.getKey(), entry.getValue().toString());
                }
                String repoClsName = (String)props.get(MSG_ARCHIVE_REPO_CLASS_PROP_KEY);
                String uri = (String)props.get(MSG_ARCHIVE_REPO_URI_PROP_KEY);
                if (uri != null) {
                    Class repoCls = null;
                    if (repoClsName == null) {
                        repoCls = RepositoryFactory.getRepoClass(MessageArchiveRepository.class, (String)uri);
                    } else {
                        try {
                            repoCls = ModulesManagerImpl.getInstance().forName(repoClsName);
                        }
                        catch (ClassNotFoundException ex) {
                            log.log(Level.SEVERE, "Could not find class " + repoClsName + " an implementation of MessageArchive repository", ex);
                            throw new ConfigurationException("Could not find class " + repoClsName + " an implementation of MessageArchive repository", (Exception)ex);
                        }
                    }
                    if (repoCls == null && repoClsName == null) {
                        throw new ConfigurationException("Not found implementation of MessageArchive repository for URI = " + uri);
                    }
                    MessageArchiveRepository old_msg_repo = this.msg_repo;
                    this.msg_repo = (MessageArchiveRepository)repoCls.newInstance();
                    this.msg_repo.initRepository(uri, repoProps);
                    if (old_msg_repo != null) {
                        old_msg_repo.destroy();
                    }
                    break block14;
                }
                log.log(Level.SEVERE, "repository uri is NULL!");
            }
            catch (DBInitException ex) {
                throw new ConfigurationException("Could not initialize MessageArchive repository", (Exception)((Object)ex));
            }
            catch (InstantiationException ex) {
                log.log(Level.SEVERE, "Could not initialize MessageArchive repository", ex);
                throw new ConfigurationException("Could not initialize MessageArchive repository", (Exception)ex);
            }
            catch (IllegalAccessException ex) {
                log.log(Level.SEVERE, "Could not initialize MessageArchive repository", ex);
                throw new ConfigurationException("Could not initialize MessageArchive repository", (Exception)ex);
            }
        }
    }

    protected void processActionPacket(Packet packet) throws PacketErrorTypeException, XMPPException {
        block12: for (Element child : packet.getElement().getChildren()) {
            if (child.getName() == "list") {
                switch (packet.getType()) {
                    case get: {
                        this.listCollections(packet, child);
                        continue block12;
                    }
                }
                this.addOutPacket(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                continue;
            }
            if (child.getName() == "retrieve") {
                switch (packet.getType()) {
                    case get: {
                        this.getMessages(packet, child);
                        continue block12;
                    }
                }
                this.addOutPacket(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                continue;
            }
            if (child.getName() == "remove") {
                switch (packet.getType()) {
                    case set: {
                        this.removeMessages(packet, child);
                        continue block12;
                    }
                }
                this.addOutPacket(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                continue;
            }
            if (child.getName() != "tags") continue;
            switch (packet.getType()) {
                case set: {
                    this.queryTags(packet, child);
                    continue block12;
                }
            }
            this.addOutPacket(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
        }
    }

    private void listCollections(Packet packet, Element list) throws XMPPException {
        try {
            RSM rsm;
            AbstractCriteria criteria = this.msg_repo.newCriteriaInstance();
            criteria.fromElement(list, this.tagsSupport);
            List<Element> chats = this.msg_repo.getCollections(packet.getStanzaFrom().getBareJID(), criteria);
            Element retList = new Element("list");
            retList.setXMLNS("urn:xmpp:archive");
            if (chats != null && !chats.isEmpty()) {
                retList.addChildren(chats);
            }
            if ((rsm = criteria.getRSM()).getCount() == null || rsm.getCount() != 0) {
                retList.addChild((XMLNodeIfc)rsm.toElement());
            }
            this.addOutPacket(packet.okResult(retList, 0));
        }
        catch (ParseException e) {
            this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Date parsing error", true));
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Error listing collections", e);
            this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database error occured", true));
        }
    }

    private void removeMessages(Packet packet, Element remove) throws XMPPException {
        if (remove.getAttributeStaticStr("with") == null || remove.getAttributeStaticStr("start") == null || remove.getAttributeStaticStr("end") == null) {
            this.addOutPacket(Authorization.NOT_ACCEPTABLE.getResponseMessage(packet, "Parameters with, start, end cannot be null", true));
            return;
        }
        try {
            AbstractCriteria criteria = this.msg_repo.newCriteriaInstance();
            criteria.fromElement(remove, this.tagsSupport);
            this.msg_repo.removeItems(packet.getStanzaFrom().getBareJID(), criteria.getWith(), (Date)criteria.getStart(), (Date)criteria.getEnd());
            this.addOutPacket(packet.okResult((Element)null, 0));
        }
        catch (ParseException e) {
            this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Date parsing error", true));
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Error removing messages", e);
            this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database error occured", true));
        }
    }

    private void storeMessage(Packet packet) {
        String ownerStr = packet.getAttributeStaticStr("owner");
        if (ownerStr != null) {
            packet.getElement().removeAttribute("owner");
            BareJID owner = BareJID.bareJIDInstanceNS((String)ownerStr);
            MessageArchiveRepository.Direction direction = MessageArchiveRepository.Direction.getDirection(owner, packet.getStanzaFrom().getBareJID());
            BareJID buddy = direction == MessageArchiveRepository.Direction.outgoing ? packet.getStanzaTo().getBareJID() : packet.getStanzaFrom().getBareJID();
            Element msg = packet.getElement();
            Date timestamp = null;
            Element delay = msg.findChildStaticStr(Message.MESSAGE_DELAY_PATH);
            if (delay != null) {
                try {
                    String stamp = delay.getAttributeStaticStr("stamp");
                    timestamp = TimestampHelper.parseTimestamp(stamp);
                }
                catch (ParseException e1) {}
            } else {
                timestamp = new Date();
            }
            Set<String> tags = null;
            if (this.tagsSupport) {
                tags = TagsHelper.extractTags(msg);
            }
            this.msg_repo.archiveMessage(owner, buddy, direction, timestamp, msg, tags);
        } else {
            log.log(Level.INFO, "Owner attribute missing from packet: {0}", packet);
        }
    }

    private void getMessages(Packet packet, Element retrieve) throws XMPPException {
        try {
            RSM rsm;
            AbstractCriteria criteria = this.msg_repo.newCriteriaInstance();
            criteria.fromElement(retrieve, this.tagsSupport);
            List<Element> items = this.msg_repo.getItems(packet.getStanzaFrom().getBareJID(), criteria);
            Element retList = new Element("chat");
            if (criteria.getWith() != null) {
                retList.setAttribute("with", criteria.getWith());
            }
            if (criteria.getStart() != null) {
                retList.setAttribute("start", TimestampHelper.format(criteria.getStart()));
            }
            retList.setXMLNS("urn:xmpp:archive");
            if (!items.isEmpty()) {
                retList.addChildren(items);
            }
            if ((rsm = criteria.getRSM()).getCount() == null || rsm.getCount() != 0) {
                retList.addChild((XMLNodeIfc)rsm.toElement());
            }
            this.addOutPacket(packet.okResult(retList, 0));
        }
        catch (ParseException e) {
            this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Date parsing error", true));
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Error retrieving messages", e);
            this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database error occured", true));
        }
    }

    private void queryTags(Packet packet, Element tagsEl) throws XMPPException {
        try {
            AbstractCriteria criteria = this.msg_repo.newCriteriaInstance();
            criteria.getRSM().fromElement(tagsEl);
            String startsWith = tagsEl.getAttributeStaticStr("like");
            if (startsWith == null) {
                startsWith = "";
            }
            List<String> tags = this.msg_repo.getTags(packet.getStanzaFrom().getBareJID(), startsWith, criteria);
            tagsEl = new Element("tags", new String[]{"xmlns"}, new String[]{"http://tigase.org/protocol/archive#query"});
            for (String tag : tags) {
                tagsEl.addChild((XMLNodeIfc)new Element("tag", tag));
            }
            RSM rsm = criteria.getRSM();
            if (rsm.getCount() == null || rsm.getCount() != 0) {
                tagsEl.addChild((XMLNodeIfc)rsm.toElement());
            }
            this.addOutPacket(packet.okResult(tagsEl, 0));
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Error retrieving messages", e);
            this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database error occured", true));
        }
    }
}

