/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.ui;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.http.AbstractModule;
import tigase.http.DeploymentInfo;
import tigase.http.HttpServer;
import tigase.http.ui.WarServlet;

public class WebModule
extends AbstractModule {
    private static final Logger log = Logger.getLogger(WebModule.class.getCanonicalName());
    private HttpServer httpServer = null;
    private DeploymentInfo deployment = null;
    private String contextPath = null;
    private String[] vhosts = null;
    private String warPath;

    @Override
    public String getName() {
        return "ui";
    }

    @Override
    public String getDescription() {
        return "Web UI XMPP client and management utility";
    }

    @Override
    public Map<String, Object> getDefaults() {
        Map<String, Object> props = super.getDefaults();
        props.put("context-path", "/" + this.getName());
        File[] files = new File("jars").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".war") && name.startsWith("tigase-web-ui");
            }
        });
        if (files != null && files.length > 0) {
            props.put("war-path", files[0].getAbsolutePath());
        } else {
            props.put("active", false);
        }
        return props;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        if (props.size() == 1) {
            return;
        }
        if (props.containsKey("http-server")) {
            this.httpServer = (HttpServer)props.get("http-server");
        }
        if (props.containsKey("context-path")) {
            this.contextPath = (String)props.get("context-path");
        }
        this.vhosts = (String[])props.get("vhosts");
        this.warPath = (String)props.get("war-path");
    }

    @Override
    public void start() {
        if (this.deployment != null) {
            this.stop();
        }
        super.start();
        if (this.warPath != null) {
            this.deployment = HttpServer.deployment().setClassLoader(this.getClass().getClassLoader()).setContextPath(this.contextPath).setDeploymentName("UI").addServlets(HttpServer.servlet("WarServlet", WarServlet.class).addMapping("/*").addInitParam("war-path", this.warPath));
            if (this.vhosts != null) {
                this.deployment.setVHosts(this.vhosts);
            }
            this.httpServer.deploy(this.deployment);
        } else {
            log.log(Level.INFO, "not found file with Web UI - Web UI will not be available");
        }
    }

    @Override
    public void stop() {
        if (this.deployment != null) {
            this.httpServer.undeploy(this.deployment);
            this.deployment = null;
        }
        super.stop();
    }
}

