/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.ArrayList;
import java.util.logging.Logger;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.muc.Affiliation;
import tigase.muc.MucContext;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.exceptions.MUCException;
import tigase.muc.history.HistoryProvider;
import tigase.muc.modules.PresenceModule;
import tigase.muc.modules.PresenceModuleImpl;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.JID;

public class PresenceModuleNoBroadcast
extends PresenceModuleImpl {
    private static final Criteria CRIT = ElementCriteria.name((String)"presence");
    protected static final Logger log = Logger.getLogger(PresenceModuleNoBroadcast.class.getName());

    @Override
    public void doQuit(Room room, JID senderJID) throws TigaseStringprepException {
        String leavingNickname = room.getOccupantsNickname(senderJID);
        Affiliation leavingAffiliation = room.getAffiliation(leavingNickname);
        Role leavingRole = room.getRole(leavingNickname);
        Element presenceElement = new Element("presence");
        presenceElement.setAttribute("type", "unavailable");
        ArrayList<JID> occupantJIDs = new ArrayList<JID>(room.getOccupantsJidsByNickname(leavingNickname));
        ((MucContext)this.context).getGhostbuster().remove(senderJID, room);
        room.updatePresenceByJid(senderJID, leavingNickname, null);
        if (((MucContext)this.context).isMultiItemMode()) {
            PresenceModule.PresenceWrapper selfPresence = PresenceModule.PresenceWrapper.preparePresenceW(room, senderJID, presenceElement, senderJID.getBareJID(), occupantJIDs, leavingNickname, leavingAffiliation, leavingRole);
            this.write(selfPresence.getPacket());
        } else {
            ArrayList<JID> z = new ArrayList<JID>(1);
            z.add(senderJID);
            PresenceModule.PresenceWrapper selfPresence = PresenceModule.PresenceWrapper.preparePresenceW(room, senderJID, presenceElement, senderJID.getBareJID(), z, leavingNickname, leavingAffiliation, leavingRole);
            this.write(selfPresence.getPacket());
        }
        if (room.getOccupantsCount() == 0) {
            HistoryProvider historyProvider = ((MucContext)this.context).getHistoryProvider();
            if (historyProvider != null && !room.getConfig().isPersistentRoom()) {
                historyProvider.removeHistory(room);
            }
            ((MucContext)this.context).getMucRepository().leaveRoom(room);
        }
    }

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public void sendPresencesToNewOccupant(Room room, JID senderJID) throws TigaseStringprepException {
    }

    @Override
    protected void processExit(Room room, Element presenceElement, JID senderJID) throws MUCException, TigaseStringprepException {
        super.processExit(room, presenceElement, senderJID);
    }

    @Override
    protected void sendPresenceToAllOccupants(Element $presence, Room room, JID senderJID, boolean newRoomCreated, String newNickName) throws TigaseStringprepException {
        PresenceModule.PresenceWrapper presence = super.preparePresence(senderJID, $presence.clone(), room, senderJID, newRoomCreated, newNickName);
        this.write(presence.getPacket());
    }
}

