/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.muc.Affiliation;
import tigase.muc.DateUtil;
import tigase.muc.MucContext;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.exceptions.MUCException;
import tigase.muc.history.HistoryProvider;
import tigase.muc.logger.MucLogger;
import tigase.muc.modules.AbstractMucModule;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class GroupchatMessageModule
extends AbstractMucModule {
    private static final Criteria CRIT = ElementCriteria.nameType((String)"message", (String)"groupchat");
    private static final Criteria CRIT_CHAT_STAT = ElementCriteria.xmlns((String)"http://jabber.org/protocol/chatstates");
    public static final String ID = "groupchat";
    private final Set<Criteria> allowedElements = new HashSet<Criteria>();

    protected void addMessageToHistory(Room room, Element message, String body, JID senderJid, String senderNickname, Date time) {
        block7: {
            block6: {
                try {
                    HistoryProvider historyProvider = ((MucContext)this.context).getHistoryProvider();
                    if (historyProvider != null) {
                        historyProvider.addMessage(room, ((MucContext)this.context).isMessageFilterEnabled() ? null : message, body, senderJid, senderNickname, time);
                    }
                }
                catch (Exception e2) {
                    if (!this.log.isLoggable(Level.WARNING)) break block6;
                    this.log.log(Level.WARNING, "Can't add message to history!", e2);
                }
            }
            try {
                MucLogger mucLogger = ((MucContext)this.context).getMucLogger();
                if (mucLogger != null && room.getConfig().isLoggingEnabled()) {
                    mucLogger.addMessage(room, body, senderJid, senderNickname, time);
                }
            }
            catch (Exception e3) {
                if (!this.log.isLoggable(Level.WARNING)) break block7;
                this.log.log(Level.WARNING, "Can't add message to log!", e3);
            }
        }
    }

    protected void addSubjectChangeToHistory(Room room, Element message, String subject, JID senderJid, String senderNickname, Date time) {
        block7: {
            block6: {
                try {
                    HistoryProvider historyProvider = ((MucContext)this.context).getHistoryProvider();
                    if (historyProvider != null) {
                        historyProvider.addSubjectChange(room, ((MucContext)this.context).isMessageFilterEnabled() ? null : message, subject, senderJid, senderNickname, time);
                    }
                }
                catch (Exception e2) {
                    if (!this.log.isLoggable(Level.WARNING)) break block6;
                    this.log.log(Level.WARNING, "Can't add subject change to history!", e2);
                }
            }
            try {
                MucLogger mucLogger = ((MucContext)this.context).getMucLogger();
                if (mucLogger != null && room.getConfig().isLoggingEnabled()) {
                    mucLogger.addSubjectChange(room, subject, senderJid, senderNickname, time);
                }
            }
            catch (Exception e3) {
                if (!this.log.isLoggable(Level.WARNING)) break block7;
                this.log.log(Level.WARNING, "Can't add subject change to log!", e3);
            }
        }
    }

    public void afterRegistration() {
        super.afterRegistration();
    }

    public String[] getFeatures() {
        ArrayList<String> f2 = new ArrayList<String>();
        f2.add("http://jabber.org/protocol/muc");
        if (this.isChatStateAllowed()) {
            f2.add("http://jabber.org/protocol/chatstates");
        }
        return f2.toArray(new String[0]);
    }

    public Criteria getModuleCriteria() {
        return CRIT;
    }

    public boolean isChatStateAllowed() {
        return this.allowedElements.contains(CRIT_CHAT_STAT);
    }

    public void process(Packet packet) throws MUCException {
        try {
            JID senderJID = JID.jidInstance((String)packet.getAttributeStaticStr("from"));
            BareJID roomJID = BareJID.bareJIDInstance((String)packet.getAttributeStaticStr("to"));
            if (GroupchatMessageModule.getNicknameFromJid(JID.jidInstance((String)packet.getAttributeStaticStr("to"))) != null) {
                throw new MUCException(Authorization.BAD_REQUEST, "Groupchat message can't be addressed to occupant.");
            }
            Room room = ((MucContext)this.context).getMucRepository().getRoom(roomJID);
            if (room == null) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND, "There is no such room.");
            }
            String nickName = room.getOccupantsNickname(senderJID);
            Role role = room.getRole(nickName);
            Affiliation affiliation = room.getAffiliation(senderJID.getBareJID());
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Processing groupchat message. room=" + roomJID + "; senderJID=" + senderJID + "; senderNickname=" + nickName + "; role=" + (Object)((Object)role) + "; affiliation=" + (Object)((Object)affiliation) + ";");
            }
            if (!role.isSendMessagesToAll() || room.getConfig().isRoomModerated() && role == Role.visitor) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Insufficient privileges to send grouchat message: role=" + (Object)((Object)role) + "; roomModerated=" + room.getConfig().isRoomModerated() + "; stanza=" + packet.getElement().toStringNoChildren());
                }
                throw new MUCException(Authorization.FORBIDDEN, "Insufficient privileges to send groupchat message.");
            }
            Element body = null;
            Element subject = null;
            Element delay = null;
            String id = packet.getAttributeStaticStr("id");
            ArrayList<Element> content = new ArrayList<Element>();
            List ccs = packet.getElement().getChildren();
            if (ccs != null) {
                block4: for (Element c2 : ccs) {
                    if ("delay".equals(c2.getName())) {
                        delay = c2;
                        continue;
                    }
                    if ("body".equals(c2.getName())) {
                        body = c2;
                        content.add(c2);
                        continue;
                    }
                    if ("subject".equals(c2.getName())) {
                        subject = c2;
                        content.add(c2);
                        continue;
                    }
                    if (!((MucContext)this.context).isMessageFilterEnabled()) {
                        content.add(c2);
                        continue;
                    }
                    if (((MucContext)this.context).isChatStateAllowed() && CRIT_CHAT_STAT.match(c2)) {
                        content.add(c2);
                        continue;
                    }
                    for (Criteria crit : this.allowedElements) {
                        if (!crit.match(c2)) continue;
                        content.add(c2);
                        continue block4;
                    }
                }
            }
            JID senderRoomJID = JID.jidInstance((BareJID)roomJID, (String)nickName);
            if (subject != null) {
                if (!(room.getConfig().isChangeSubject() && role == Role.participant || role.isModifySubject())) {
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Insufficient privileges to change subject: role=" + (Object)((Object)role) + "; allowToChangeSubject=" + room.getConfig().isChangeSubject() + "; stanza=" + packet.getElement().toStringNoChildren());
                    }
                    throw new MUCException(Authorization.FORBIDDEN, "Insufficient privileges to change subject.");
                }
                String msg = subject.getCData();
                room.setNewSubject(msg, nickName);
            }
            Date sendDate = delay != null && affiliation == Affiliation.owner ? DateUtil.parse(delay.getAttributeStaticStr("stamp")) : new Date();
            if (body != null) {
                this.addMessageToHistory(room, packet.getElement(), body.getCData(), senderJID, nickName, sendDate);
            }
            if (subject != null) {
                this.addSubjectChangeToHistory(room, packet.getElement(), subject.getCData(), senderJID, nickName, sendDate);
            }
            if (sendDate != null) {
                content.add(new Element("delay", new String[]{"xmlns", "stamp"}, new String[]{"urn:xmpp:delay", DateUtil.formatDatetime(sendDate)}));
            }
            this.sendMessagesToAllOccupants(room, senderRoomJID, id, content.toArray(new Element[0]));
        }
        catch (MUCException e1) {
            throw e1;
        }
        catch (TigaseStringprepException e2) {
            throw new MUCException(Authorization.BAD_REQUEST);
        }
        catch (Exception e3) {
            e3.printStackTrace();
            throw new RuntimeException(e3);
        }
    }

    public void sendMessagesToAllOccupants(Room room, JID fromJID, Element ... content) throws TigaseStringprepException {
        this.sendMessagesToAllOccupants(room, fromJID, (String)null, content);
    }

    public void sendMessagesToAllOccupants(Room room, JID fromJID, String messageId, Element ... content) throws TigaseStringprepException {
        room.fireOnMessageToOccupants(fromJID, content);
        this.sendMessagesToAllOccupantsJids(room, fromJID, messageId, content);
    }

    public void sendMessagesToAllOccupantsJids(Room room, JID fromJID, Element ... content) throws TigaseStringprepException {
        this.sendMessagesToAllOccupantsJids(room, fromJID, (String)null, content);
    }

    public void sendMessagesToAllOccupantsJids(Room room, JID fromJID, String messageId, Element ... content) throws TigaseStringprepException {
        for (String nickname : room.getOccupantsNicknames()) {
            Role role = room.getRole(nickname);
            if (!role.isReceiveMessages()) continue;
            Collection<JID> occupantJids = room.getOccupantsJidsByNickname(nickname);
            for (JID jid : occupantJids) {
                Element e2 = new Element("message", new String[]{"type", "from", "to"}, new String[]{ID, fromJID.toString(), jid.toString()});
                if (messageId != null) {
                    e2.setAttribute("id", messageId);
                }
                Packet message = Packet.packetInstance((Element)e2);
                message.setXMLNS("jabber:client");
                if (content != null) {
                    for (Element sub : content) {
                        if (sub == null) continue;
                        message.getElement().addChild((XMLNodeIfc)sub);
                    }
                }
                this.write(message);
            }
        }
    }
}

